/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.util.ArrayList;
import visualizer.projection.distance.DistanceMatrix;

public class Prim {
    private int n;
    private float[][] weight;
    private boolean[] inTree;
    private float[] d;
    private int[] whoTo;

    public Prim(DistanceMatrix dmat) {
        this.n = dmat.getElementCount();
        this.weight = new float[this.n][];
        this.inTree = new boolean[this.n];
        this.d = new float[this.n];
        this.whoTo = new int[this.n];
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            this.weight[i] = new float[this.n];
            for (int j = 0; j < dmat.getElementCount(); ++j) {
                float dist = dmat.getDistance(i, j);
                this.weight[i][j] = dist < 0.0f ? 0.0f : dist;
            }
        }
    }

    public ArrayList<Edge> prim() {
        int i;
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (i = 0; i < this.n; ++i) {
            this.d[i] = Float.MAX_VALUE;
        }
        for (i = 0; i < this.n; ++i) {
            this.inTree[i] = false;
        }
        this.inTree[0] = true;
        this.updateDistances(0);
        for (int treeSize = 1; treeSize < this.n; ++treeSize) {
            int min = -1;
            for (int i2 = 0; i2 < this.n; ++i2) {
                if (this.inTree[i2] || min != -1 && !(this.d[min] > this.d[i2])) continue;
                min = i2;
            }
            edges.add(new Edge(this.whoTo[min], min, this.d[min]));
            this.inTree[min] = true;
            this.updateDistances(min);
        }
        return edges;
    }

    private void updateDistances(int target) {
        for (int i = 0; i < this.n; ++i) {
            if (this.weight[target][i] == 0.0f || !(this.d[i] > this.weight[target][i])) continue;
            this.d[i] = this.weight[target][i];
            this.whoTo[i] = target;
        }
    }

    public static class Edge {
        public int node1;
        public int node2;
        public float len;

        public Edge(int node1, int node2, float len) {
            this.node1 = node1;
            this.node2 = node2;
            this.len = len;
        }
    }
}

