/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import visualizer.util.SystemPropertiesManager;
import visualizer.view.Splash;

public class Help
extends JDialog {
    private static Help instance;
    private JPanel aboutPanel;
    private JPanel buttonPanel;
    private JPanel detailPanel;
    private JEditorPane detailsEditorPane;
    private JScrollPane detailsScrollPane;
    private JTabbedPane helpTabbedPane;
    private JButton okButton;

    private Help(JFrame parent) {
        super(parent);
        this.initComponents();
        this.createMessage();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.helpTabbedPane = new JTabbedPane();
        this.detailPanel = new JPanel();
        this.detailsScrollPane = new JScrollPane();
        this.detailsEditorPane = new JEditorPane();
        this.aboutPanel = new Splash.SplashPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("About");
        this.setModal(true);
        this.setResizable(false);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Help.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.detailPanel.setLayout(new BorderLayout());
        this.detailsEditorPane.setContentType("text/html");
        this.detailsEditorPane.setEditable(false);
        this.detailsScrollPane.setViewportView(this.detailsEditorPane);
        this.detailPanel.add((Component)this.detailsScrollPane, "Center");
        this.helpTabbedPane.addTab("Details", this.detailPanel);
        this.helpTabbedPane.addTab("About", this.aboutPanel);
        this.getContentPane().add((Component)this.helpTabbedPane, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static Help getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new Help(parent);
        }
        return instance;
    }

    public void display() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void createMessage() {
        String version = SystemPropertiesManager.getInstance().getProperty("TOOL.VERSION");
        if (version == null || version.trim().length() < 1) {
            version = "**.**.**";
        }
        String message = "<p style=\"word-spacing: 0; margin: 0\"><b><font size=\"5\" color=\"#0000FF\" face=\"Verdana\">Projection Explorer for Images (version " + version + ")</font></b></p>" + "<p style=\"word-spacing: 0; margin: 0\"><b><font face=\"Verdana\" size=\"4\">University of S\u00e3o Paulo (USP), S\u00e3o Carlos/SP, Brazil</font></b></p>" + "<p style=\"word-spacing: 0; margin: 0\"><b><font face=\"Verdana\" size=\"3\">Matemathical and Computer Science Institute (ICMC)</font></b></p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\">Computer Graphics and Image Processing Group</font></p>" + "<p style=\"word-spacing: 0; margin: 0\">&nbsp;</p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\" color=\"#0000FF\">http://infoserver.lcad.icmc.usp.br/infovis2/PExImage</font></p>" + "<p style=\"word-spacing: 0; margin: 0\">&nbsp;</p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\"><b>Supervisor:</b></font></p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\">&nbsp;&nbsp;&nbsp;&nbsp;Rosane Minghim (rminghim@icmc.usp.br)</font></p>" + "<p style=\"word-spacing: 0; margin: 0\">&nbsp;</p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\"><b>Developer:</b></font></p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\">&nbsp;&nbsp;&nbsp;&nbsp;Danilo Medeiros Eler (danilome@gmail.com)</font></p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\">&nbsp;&nbsp;&nbsp;&nbsp;Fernando Vieira Paulovich (fpaulovich@gmail.com)</font></p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\">&nbsp;&nbsp;&nbsp;&nbsp;Gabriel de Faria Andery (gfandery@gmail.com)</font></p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\">&nbsp;&nbsp;&nbsp;&nbsp;Marcel Yugo Nakazaki (myn@icmc.usp.br)</font></p>" + "<p style=\"word-spacing: 0; margin: 0\">&nbsp;</p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\"><b>Contributions:</b></font></p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\">&nbsp;&nbsp;&nbsp;&nbsp;Davi Pereira Santos</font></p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\">&nbsp;&nbsp;&nbsp;&nbsp;Jo\u00e3o Batista do Esp\u00edrito Santo Neto (jbatista@icmc.usp.br)</font></p>" + "<p style=\"word-spacing: 0; margin: 0\"><font face=\"Verdana\" size=\"3\">&nbsp;&nbsp;&nbsp;&nbsp;Maria Cristina Ferreira de Oliveira (cristina@icmc.usp.br)</font></p>";
        this.detailsEditorPane.setText(message);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Help h = new Help(null);
                h.setVisible(true);
            }
        });
    }
}

