/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.view.MultipleImage;
import visualizer.view.Viewer;

public class MultipleImageView
extends JDialog {
    private static final long serialVersionUID = 1L;
    private DefaultTableModel imagesModel;
    private MultipleImage.FilePane showedFilePane = null;
    private final int numberCharsAtTabTitle = 20;
    private static MultipleImageView instance;
    private ArrayList<Vertex> vertex;
    private Graph graph;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel dataPanel;
    private JScrollPane imagesScrollPane;
    private JTable imagesTable;

    private MultipleImageView(JFrame parent) {
        super(parent);
        this.initComponents();
        this.imagesModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return ImageIcon.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.imagesModel.addColumn("Images");
        this.imagesModel.addColumn("Images");
        this.imagesModel.addColumn("Images");
        this.imagesModel.addColumn("Images");
        this.imagesTable.setModel(this.imagesModel);
        this.imagesTable.setAutoResizeMode(4);
        this.imagesTable.setRowHeight(200);
        this.pack();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.dataPanel = new JPanel();
        this.imagesScrollPane = new JScrollPane();
        this.imagesTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("Images Multiple View");
        this.setModal(true);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleImageView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.dataPanel.setLayout(new BorderLayout());
        this.imagesScrollPane.setBorder(BorderFactory.createTitledBorder("Images"));
        this.imagesScrollPane.setMinimumSize(new Dimension(800, 600));
        this.imagesScrollPane.setPreferredSize(new Dimension(800, 600));
        this.imagesScrollPane.setViewportView(this.imagesTable);
        this.dataPanel.add((Component)this.imagesScrollPane, "Center");
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static MultipleImageView getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new MultipleImageView(parent);
        }
        return instance;
    }

    public void display(Viewer gv, ArrayList<Vertex> vertex) {
        this.vertex = vertex;
        this.graph = gv.getGraph();
        int Size = 0;
        if (vertex != null) {
            int i;
            int rowcount = this.imagesModel.getRowCount();
            for (i = rowcount - 1; i >= 0; --i) {
                this.imagesModel.removeRow(i);
            }
            for (i = 0; i < vertex.size(); i += 4) {
                for (int j = 0; j < 4 && i + j < vertex.size(); ++j) {
                    Vertex v = vertex.get(i + j);
                    if (!v.isValid()) continue;
                    ++Size;
                }
            }
            for (i = 0; i < Size; i += 4) {
                Object[] images = new Object[4];
                for (int j = 0; j < 4 && i + j < Size; ++j) {
                    Vertex v = vertex.get(i + j);
                    if (!v.isValid()) continue;
                    try {
                        images[j] = new ImageIcon(this.graph.getImageCollection().getImage(v.getUrl()).getScaledInstance(200, 200, 0));
                        continue;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                this.imagesModel.addRow(images);
            }
        }
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void display(Viewer gv, Vertex vertex) {
        ArrayList<Vertex> neighbors = new ArrayList<Vertex>();
        gv.getGraph().getNeighbors(neighbors, null, gv.getCurrentConnectivity(), vertex, gv.getNeighborhoodDepth());
        if (neighbors.size() > 0) {
            neighbors.set(0, vertex);
        } else {
            neighbors.add(vertex);
        }
        this.display(gv, neighbors);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MultipleImageView(null).setVisible(true);
            }
        });
    }
}

