/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import visualizer.forcelayout.ForceData;
import visualizer.forcelayout.ForceDirectLayout;
import visualizer.graph.Connectivity;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.graph.XMLGraphWriter;
import visualizer.graph.coodination.Coordination;
import visualizer.graph.coodination.Mapping;
import visualizer.graph.listeners.VertexSelectionFactory;
import visualizer.topic.Topic;
import visualizer.util.OpenDialog;
import visualizer.util.SaveDialog;
import visualizer.util.Util;
import visualizer.util.filefilter.LEGFilter;
import visualizer.util.filefilter.XMLFilter;
import visualizer.view.DescriptionView;
import visualizer.view.JExtendedComboBox;
import visualizer.view.MultipleFileView;
import visualizer.view.MultipleImageView;
import visualizer.view.ProjectionExplorerView;
import visualizer.view.ReportView;
import visualizer.view.Viewer;
import visualizer.view.color.ColorScalePanel;
import visualizer.view.color.ColorTable;
import visualizer.view.legend.Legend;
import visualizer.view.legend.LegendView;

public class ProjectionViewer
extends Viewer {
    private Font font = new Font("Verdana", 1, 13);
    private LegendView legendview;
    private int neighborhoodDepth = 1;
    private ViewPanel view;
    private Graph graph;
    private ForceDirectLayout force;
    private boolean start = true;
    private Scalar prevColorScalar;
    private Scalar prevSizeScalar;
    private Mapping prevCoord = Mapping.OFF;
    private Connectivity prevConnectivity;
    private DefaultComboBoxModel scalarComboModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel coordComboModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel edgesComboModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel titlesComboModel = new DefaultComboBoxModel();
    private JPanel buttonPanel;
    private JPanel comboPanel;
    private JComboBox edgesCoordComboBox;
    private JToggleButton edgesCoordToggleButton;
    private JButton legendButton;
    private JSplitPane mapSplitPane;
    private JTabbedPane mapTabbedPane;
    private JPanel projectionPanel;
    private JPanel reportPanel;
    private JScrollPane reportScrollPane;
    private JComboBox scalarCombo;
    private JToggleButton scalarToggleButton;
    private JScrollPane scrollPaneGraph;
    private JButton splitScalars;
    private JComboBox titleComboBox;
    private JPanel titlePanel;
    private JTextField titleTextField;

    public ProjectionViewer(ProjectionExplorerView pexview) {
        super(pexview);
        this.view = new ViewPanel(this.pexview);
        this.coord = new Coordination(pexview.getCoordinator(), this);
        this.initComponents();
    }

    private void initComponents() {
        this.mapSplitPane = new JSplitPane();
        this.mapTabbedPane = new JTabbedPane();
        this.projectionPanel = new JPanel();
        this.scrollPaneGraph = new JScrollPane(this.view);
        this.titlePanel = new JPanel();
        this.titleTextField = new JTextField();
        this.buttonPanel = new JPanel();
        this.titleComboBox = new JExtendedComboBox((ComboBoxModel)this.titlesComboModel);
        this.legendButton = new JButton();
        this.reportScrollPane = new JScrollPane();
        this.reportPanel = new ReportView();
        this.comboPanel = new JPanel();
        this.scalarCombo = new JExtendedComboBox((ComboBoxModel)this.scalarComboModel);
        this.scalarToggleButton = new JToggleButton();
        this.edgesCoordToggleButton = new JToggleButton();
        this.edgesCoordComboBox = new JExtendedComboBox((ComboBoxModel)this.edgesComboModel);
        this.splitScalars = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                ProjectionViewer.this.formInternalFrameActivated(evt);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                ProjectionViewer.this.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.mapSplitPane.setOrientation(0);
        this.mapSplitPane.setOneTouchExpandable(true);
        this.projectionPanel.setLayout(new BorderLayout());
        this.projectionPanel.add((Component)this.scrollPaneGraph, "Center");
        this.titlePanel.setBorder(BorderFactory.createTitledBorder(""));
        this.titlePanel.setLayout(new BorderLayout());
        this.titleTextField.setEditable(false);
        this.titlePanel.add((Component)this.titleTextField, "Center");
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 0));
        this.titleComboBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectionViewer.this.titleComboBoxMouseClicked(evt);
            }
        });
        this.titleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionViewer.this.titleComboBoxActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.titleComboBox);
        this.legendButton.setText("Legend");
        this.legendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionViewer.this.legendButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.legendButton);
        this.titlePanel.add((Component)this.buttonPanel, "East");
        this.projectionPanel.add((Component)this.titlePanel, "First");
        this.mapTabbedPane.addTab("Projection", this.projectionPanel);
        this.reportScrollPane.setViewportView(this.reportPanel);
        this.mapTabbedPane.addTab("Report", this.reportScrollPane);
        this.mapSplitPane.setRightComponent(this.mapTabbedPane);
        this.comboPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.comboPanel.setLayout(new GridBagLayout());
        this.scalarCombo.setMaximumSize(new Dimension(85, 27));
        this.scalarCombo.setMinimumSize(new Dimension(85, 27));
        this.scalarCombo.setPreferredSize(new Dimension(85, 27));
        this.scalarCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionViewer.this.scalarComboActionPerformed(evt);
            }
        });
        this.scalarCombo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectionViewer.this.scalarComboMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 1, 3, 3);
        this.comboPanel.add((Component)this.scalarCombo, gridBagConstraints);
        this.scalarToggleButton.setText("Color");
        this.scalarToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionViewer.this.scalarToggleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 1);
        this.comboPanel.add((Component)this.scalarToggleButton, gridBagConstraints);
        this.edgesCoordToggleButton.setText("Edges");
        this.edgesCoordToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionViewer.this.edgesCoordToggleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 1);
        this.comboPanel.add((Component)this.edgesCoordToggleButton, gridBagConstraints);
        this.edgesCoordComboBox.setMaximumSize(new Dimension(85, 27));
        this.edgesCoordComboBox.setMinimumSize(new Dimension(85, 27));
        this.edgesCoordComboBox.setPreferredSize(new Dimension(85, 27));
        this.edgesCoordComboBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectionViewer.this.edgesCoordComboBoxMouseClicked(evt);
            }
        });
        this.edgesCoordComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionViewer.this.edgesCoordComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 1, 3, 3);
        this.comboPanel.add((Component)this.edgesCoordComboBox, gridBagConstraints);
        this.splitScalars.setText("Split");
        this.splitScalars.setToolTipText("This may take some minutes");
        this.splitScalars.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionViewer.this.splitScalarsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        this.comboPanel.add((Component)this.splitScalars, gridBagConstraints);
        this.mapSplitPane.setLeftComponent(this.comboPanel);
        this.getContentPane().add((Component)this.mapSplitPane, "Center");
        this.pack();
    }

    private void formInternalFrameActivated(InternalFrameEvent evt) {
        this.pexview.setFocusedJInternalFrame(this);
    }

    private void edgesCoordComboBoxActionPerformed(ActionEvent evt) {
        if (this.edgesCoordToggleButton.isSelected()) {
            Mapping mapping = (Mapping)this.edgesCoordComboBox.getSelectedItem();
            if (mapping != null && mapping.getName().equals("topic")) {
                if (OpenDialog.checkCorpus(this.graph, this)) {
                    this.coord.changeMapping(mapping);
                } else {
                    this.edgesCoordComboBox.setSelectedItem(Mapping.OFF);
                }
            } else {
                this.coord.changeMapping(mapping);
            }
        } else {
            this.updateImage();
        }
    }

    private void edgesCoordToggleButtonActionPerformed(ActionEvent evt) {
        if (this.edgesCoordToggleButton.isSelected()) {
            this.prevConnectivity = (Connectivity)this.edgesCoordComboBox.getSelectedItem();
            this.edgesCoordComboBox.setModel(this.coordComboModel);
            this.edgesCoordToggleButton.setText("Coordination");
            this.edgesCoordComboBox.setSelectedItem(this.prevCoord);
        } else {
            this.prevCoord = (Mapping)this.edgesCoordComboBox.getSelectedItem();
            this.edgesCoordComboBox.setModel(this.edgesComboModel);
            this.edgesCoordToggleButton.setText("Edges");
            if (this.prevConnectivity != null) {
                this.edgesCoordComboBox.setSelectedItem(this.prevConnectivity);
            } else {
                this.edgesCoordComboBox.setSelectedIndex(0);
            }
        }
    }

    private void scalarToggleButtonActionPerformed(ActionEvent evt) {
        if (this.scalarToggleButton.isSelected()) {
            this.prevColorScalar = (Scalar)this.scalarCombo.getSelectedItem();
            this.scalarToggleButton.setText("Size");
            if (this.prevSizeScalar != null) {
                this.scalarCombo.setSelectedItem(this.prevSizeScalar);
            } else {
                this.scalarCombo.setSelectedIndex(0);
            }
        } else {
            this.prevSizeScalar = (Scalar)this.scalarCombo.getSelectedItem();
            this.scalarToggleButton.setText("Color");
            if (this.prevColorScalar != null) {
                this.scalarCombo.setSelectedItem(this.prevColorScalar);
            } else {
                this.scalarCombo.setSelectedIndex(0);
            }
        }
        this.scalarComboActionPerformed(null);
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.saveOnClosing();
        this.pexview.getCoordinator().removeCoordination(this);
        this.pexview.setFocusedJInternalFrame(null);
    }

    private void scalarComboActionPerformed(ActionEvent evt) {
        Scalar scalar = (Scalar)this.scalarCombo.getSelectedItem();
        if (scalar != null) {
            if (this.scalarToggleButton.isSelected()) {
                this.view.resizeAs(scalar);
            } else {
                this.view.colorAs(scalar);
            }
        }
    }

    private void scalarComboMouseClicked(MouseEvent evt) {
        Scalar scalar;
        if (evt.getClickCount() == 2 && !(scalar = (Scalar)this.scalarCombo.getSelectedItem()).getName().equals("...")) {
            this.scalarComboModel.removeElement(scalar);
            this.scalarCombo.setSelectedIndex(0);
            this.graph.removeScalar(scalar);
            this.setGraphChanged(true);
        }
    }

    private void edgesCoordComboBoxMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && !this.edgesCoordToggleButton.isSelected()) {
            Connectivity con = (Connectivity)this.edgesCoordComboBox.getSelectedItem();
            if (this.edgesCoordComboBox.getItemCount() > 1) {
                this.edgesComboModel.removeElement(con);
                this.edgesCoordComboBox.setSelectedIndex(0);
                this.graph.removeConnectivity(con);
                this.setGraphChanged(true);
            }
        }
    }

    private void titleComboBoxActionPerformed(ActionEvent evt) {
        String title_aux = (String)((JComboBox)evt.getSource()).getSelectedItem();
        if (this.title != null) {
            if (this.graph != null) {
                this.graph.changeTitle(title_aux);
            }
            this.pexview.refreshLists();
            this.updateImage();
        }
    }

    private void titleComboBoxMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            String title_aux = (String)this.titleComboBox.getSelectedItem();
            if (this.titleComboBox.getItemCount() > 1) {
                this.titlesComboModel.removeElement(title_aux);
                this.titleComboBox.setSelectedIndex(0);
                this.graph.removeTitle(title_aux);
                this.setGraphChanged(true);
            }
        }
    }

    private void legendButtonActionPerformed(ActionEvent evt) {
        int result;
        if (this.legendview == null && (result = OpenDialog.showOpenDialog(new LEGFilter(), this)) == 0) {
            try {
                String filename = OpenDialog.getFilename();
                Legend legend = Util.readLegend(this.view.colorTable, filename);
                this.legendview = new LegendView((Frame)this.pexview, legend);
                this.legendview.setLocationRelativeTo(this);
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionViewer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.legendview.setVisible(true);
    }

    private void splitScalarsActionPerformed(ActionEvent evt) {
        ArrayList<Float> SplittedScalars = new ArrayList<Float>();
        for (Vertex vertex : this.graph.getVertex()) {
            if (SplittedScalars.contains(Float.valueOf(vertex.getScalar(this.graph.getScalarByName(this.scalarCombo.getSelectedItem().toString()))))) continue;
            SplittedScalars.add(Float.valueOf(vertex.getScalar(this.graph.getScalarByName(this.scalarCombo.getSelectedItem().toString()))));
        }
        if (SplittedScalars.size() > 2) {
            for (int i = 0; i < SplittedScalars.size(); ++i) {
                this.graph.addScalar(this.scalarCombo.getSelectedItem().toString() + "_" + i);
                for (Vertex vertex : this.graph.getVertex()) {
                    if (vertex.getScalar(this.graph.getScalarByName(this.scalarCombo.getSelectedItem().toString())) == ((Float)SplittedScalars.get(i)).floatValue()) {
                        vertex.setScalar(this.graph.getScalarByName(this.scalarCombo.getSelectedItem().toString() + "_" + i), 1.0f);
                        continue;
                    }
                    vertex.setScalar(this.graph.getScalarByName(this.scalarCombo.getSelectedItem().toString() + "_" + i), 0.0f);
                }
            }
        }
        this.updateScalars(null);
    }

    @Override
    public void markNeighbors(Vertex vertex) {
        this.view.markNeighbors(vertex);
    }

    @Override
    public int getNeighborhoodDepth() {
        return this.neighborhoodDepth;
    }

    @Override
    public void setNeighborhoodDepth(int depth) {
        this.neighborhoodDepth = depth;
    }

    @Override
    public Scalar getCurrentScalar() {
        return (Scalar)this.scalarCombo.getSelectedItem();
    }

    @Override
    public String getCurrentTitle() {
        return (String)this.titleComboBox.getSelectedItem();
    }

    @Override
    public Connectivity getCurrentConnectivity() {
        if (this.edgesCoordToggleButton.isSelected()) {
            return this.prevConnectivity;
        }
        return (Connectivity)this.edgesCoordComboBox.getSelectedItem();
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void cleanSelection(boolean cleanVertexLabels) {
        if (this.view != null) {
            this.view.cleanMarkedVertices(cleanVertexLabels);
        }
    }

    @Override
    public void selectVertices(ArrayList<Vertex> vertices) {
        if (this.view != null) {
            this.view.markVertices(vertices);
        }
    }

    @Override
    public void addTopic(Topic topic) {
        if (this.view != null) {
            this.view.getTopics().add(topic);
        }
    }

    @Override
    public ColorTable getColorTable() {
        if (this.view != null) {
            return this.view.getColorTable();
        }
        return null;
    }

    @Override
    public void updateImage() {
        if (this.view != null) {
            this.view.cleanImage();
            this.view.repaint();
        }
    }

    @Override
    public void colorAs(Scalar scalar) {
        if (this.view != null) {
            this.view.colorAs(scalar);
        }
    }

    @Override
    public Vertex getSelectedVertex() {
        if (this.view != null) {
            return this.view.getMarkedVertex();
        }
        return null;
    }

    @Override
    public Font getViewerFont() {
        if (this.view != null) {
            return this.view.getFont();
        }
        return null;
    }

    @Override
    public void setViewerFont(Font font) {
        if (this.view != null) {
            this.view.setFont(font);
        }
    }

    @Override
    public void setViewerBackground(Color bg) {
        if (this.view != null) {
            this.view.setBackground(bg);
        }
    }

    @Override
    public void deleteSelectedVertices() {
        if (this.view != null) {
            this.view.deleteSelectedVertex();
        }
    }

    @Override
    public void saveToPngImageFile(String filename) throws IOException {
        if (this.view != null) {
            this.view.saveToPngImageFile(filename);
        }
    }

    @Override
    public void saveToEpsImageFile(String filename) throws IOException {
        if (this.view != null) {
            this.view.saveToEpsImageFile(filename);
        }
    }

    @Override
    public ArrayList<Vertex> getSelectedVertex(Point localSource, Point localTarget) {
        if (this.view != null) {
            return this.view.getSelectedVertex(localSource, localTarget);
        }
        return null;
    }

    @Override
    public void zoomIn() {
        this.zoom(1.1f);
    }

    @Override
    public void zoomOut() {
        this.zoom(0.9091f);
    }

    @Override
    public void cleanTopics() {
        this.view.getTopics().clear();
        this.view.repaint();
    }

    @Override
    public void updateScalars(Scalar scalar) {
        this.scalarComboModel.removeAllElements();
        for (Scalar s : this.graph.getScalars()) {
            this.scalarComboModel.addElement(s);
        }
        if (scalar != null) {
            this.scalarCombo.setSelectedItem(scalar);
        }
        this.setGraphChanged(true);
    }

    @Override
    public void updateConnectivities(Connectivity connectivity) {
        this.edgesComboModel.removeAllElements();
        for (Connectivity con : this.graph.getConnectivities()) {
            this.edgesComboModel.addElement(con);
        }
        if (!this.edgesCoordToggleButton.isSelected() && connectivity != null) {
            this.edgesCoordComboBox.setSelectedItem(connectivity);
            this.prevConnectivity = connectivity;
        }
        this.setGraphChanged(true);
    }

    @Override
    public void updateCoordinations(Mapping mapping) {
        this.coordComboModel.removeAllElements();
        this.coordComboModel.addElement(Mapping.OFF);
        for (Mapping m : this.coord.getMappings()) {
            if (this.coordComboModel.getIndexOf(m) >= 0) continue;
            this.coordComboModel.addElement(m);
        }
        if (this.edgesCoordToggleButton.isSelected() && mapping != null) {
            this.edgesCoordComboBox.setSelectedItem(mapping);
            this.prevCoord = mapping;
        }
    }

    @Override
    public void updateTitles(String name) {
        this.titlesComboModel.removeAllElements();
        for (String t : this.graph.getTitles()) {
            this.titlesComboModel.addElement(t);
        }
        if (name != null) {
            this.titleComboBox.setSelectedItem(name);
        }
        this.setGraphChanged(true);
    }

    public void setGraph(Graph graph) {
        if (graph != null) {
            this.graph = graph;
            this.view.setGraph(graph);
            this.updateScalars(null);
            this.updateConnectivities(null);
            this.updateTitles(null);
            if (this.graph.getDescription().trim().length() > 0) {
                DescriptionView.getInstance(this.getProjectionExplorerView()).display(this.graph.getDescription());
            }
            ((ReportView)this.reportPanel).reset(this.graph.getProjectionData());
        }
    }

    @Override
    public boolean runForce() {
        if (this.graph != null) {
            if (this.start) {
                this.cleanTopics();
                for (Vertex v : this.graph.getVertex()) {
                    if (v.fdata != null) continue;
                    v.fdata = new ForceData();
                }
                this.force = new ForceDirectLayout(this.graph, this);
                this.force.start(this.getCurrentConnectivity());
                this.start = false;
            } else {
                this.force.stop();
                this.start = true;
            }
        }
        this.setGraphChanged(true);
        return this.start;
    }

    @Override
    public void setTitle(String title) {
        if (!title.startsWith("[")) {
            title = "[" + this.id + "]: " + title;
        }
        super.setTitle(title);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int saveOnClosing() {
        if (!this.graphChanged) {
            this.dispose();
            return 1;
        }
        int result1 = JOptionPane.showConfirmDialog(this, "Would like to save the current projection?", "Save", 1);
        if (result1 != 0) {
            if (result1 != 1) return 2;
            this.dispose();
            return 1;
        }
        String filename = this.graph.getProjectionData().getSourceFile();
        int result2 = SaveDialog.showSaveDialog(new XMLFilter(), this, filename);
        if (result2 != 0) return 1;
        filename = SaveDialog.getFilename();
        try {
            XMLGraphWriter.save(this.graph, this.graph.getDescription(), filename);
            this.setTitle(filename);
            this.setGraphChanged(false);
            return 0;
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Problems with the file", 0);
            this.dispose();
            return 1;
        }
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.view.repaint();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    private void zoom(float rate) {
        if (this.graph != null) {
            ArrayList<Vertex> vertex = this.graph.getVertex();
            float maxX = vertex.get(0).getX();
            float minX = vertex.get(0).getX();
            float maxY = vertex.get(0).getY();
            float minY = vertex.get(0).getY();
            for (Vertex v : vertex) {
                if (maxX < v.getX()) {
                    maxX = v.getX();
                } else if (minX > v.getX()) {
                    minX = v.getX();
                }
                if (maxY < v.getY()) {
                    maxY = v.getY();
                    continue;
                }
                if (!(minY > v.getY())) continue;
                minY = v.getY();
            }
            float endX = maxX * rate;
            float endY = maxY * rate;
            for (Vertex v : vertex) {
                if (maxX != minX) {
                    v.setX((v.getX() - minX) / (maxX - minX) * (endX - minX) + minX);
                } else {
                    v.setX(minX);
                }
                if (maxY != minY) {
                    v.setY((v.getY() - minY) / (maxY - minY) * (endY - minY) + minY);
                    continue;
                }
                v.setY(minY);
            }
            this.view.setPreferredSize(new Dimension(this.graph.getSize().width * 2, this.graph.getSize().height * 2));
            this.view.setSize(new Dimension(this.graph.getSize().width * 2, this.graph.getSize().height * 2));
            for (Topic topic : this.view.getTopics()) {
                topic.getRectangle().x = (int)((float)topic.getRectangle().x * rate);
                topic.getRectangle().y = (int)((float)topic.getRectangle().y * rate);
                topic.getRectangle().height = (int)((float)topic.getRectangle().height * rate);
                topic.getRectangle().width = (int)((float)topic.getRectangle().width * rate);
            }
            this.updateImage();
        }
    }

    public class ViewPanel
    extends JPanel {
        private Polygon polygon;
        private Point source = null;
        private Point target = null;
        private Color color = Color.RED;
        private Vertex markedVertex;
        private Vertex selectedVertex;
        private Image toolTipImage;
        private String toolTipLabel;
        private Point toolTipPosition;
        private ArrayList<Topic> topics = new ArrayList();
        private Topic selectedTopic = null;
        private ArrayList<Vertex> selectedVertices;
        private BufferedImage imageBuffer;
        private ProjectionExplorerView pexview;
        private ColorScalePanel csp;
        private ColorTable colorTable;

        public ViewPanel(ProjectionExplorerView pexview) {
            this.pexview = pexview;
            this.colorTable = new ColorTable();
            this.csp = new ColorScalePanel(ProjectionViewer.this);
            this.csp.setColorTable(this.colorTable);
            this.csp.setPreferredSize(new Dimension(200, 12));
            this.add(this.csp);
            this.setBackground(Color.WHITE);
            this.addMouseMotionListener(new MouseMotionListener());
            this.addMouseListener(new MouseClickedListener());
            this.setLayout(new FlowLayout(0));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            if (ProjectionViewer.this.graph != null && this.imageBuffer == null) {
                this.imageBuffer = new BufferedImage(((ProjectionViewer)ProjectionViewer.this).graph.getSize().width + 1, ((ProjectionViewer)ProjectionViewer.this).graph.getSize().height + 1, 1);
                Graphics2D g2Buffer = this.imageBuffer.createGraphics();
                g2Buffer.setColor(this.getBackground());
                g2Buffer.fillRect(0, 0, ((ProjectionViewer)ProjectionViewer.this).graph.getSize().width + 1, ((ProjectionViewer)ProjectionViewer.this).graph.getSize().height + 1);
                if (ProjectionViewer.this.highQualityRender) {
                    g2Buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    g2Buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                ProjectionViewer.this.graph.draw(ProjectionViewer.this.getCurrentConnectivity(), g2Buffer);
                g2Buffer.dispose();
            }
            if (this.imageBuffer != null) {
                g2.drawImage((Image)this.imageBuffer, 0, 0, null);
            }
            for (Topic topic : this.topics) {
                topic.drawTopic(g2, this.getFont(), false);
            }
            if (this.source != null && this.target != null) {
                int x = this.source.x;
                int width = this.target.x - this.source.x;
                int y = this.source.y;
                int height = this.target.y - this.source.y;
                if (this.source.x > this.target.x) {
                    x = this.target.x;
                    width = this.source.x - this.target.x;
                }
                if (this.source.y > this.target.y) {
                    y = this.target.y;
                    height = this.source.y - this.target.y;
                }
                g2.setColor(this.color);
                g2.drawRect(x, y, width, height);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.setPaint(this.color);
                g2.fill(new Rectangle(x, y, width, height));
            } else if (this.selectedTopic != null) {
                this.selectedTopic.drawTopic(g2, this.getFont(), true);
            } else if (ProjectionViewer.this.vertexLabelVisible && this.toolTipLabel != null && this.toolTipPosition != null) {
                if (this.toolTipImage != null) {
                    g2.drawImage(this.toolTipImage, this.toolTipPosition.x, this.toolTipPosition.y, null);
                } else {
                    g2.setFont(this.getFont());
                    FontMetrics metrics = g2.getFontMetrics(g2.getFont());
                    int width = metrics.stringWidth(this.toolTipLabel);
                    int height = metrics.getAscent();
                    g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
                    g2.setPaint(Color.WHITE);
                    g2.fill(new Rectangle(this.toolTipPosition.x - 2, this.toolTipPosition.y - height, width + 4, height + 4));
                    g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    g2.setColor(Color.DARK_GRAY);
                    g2.drawRect(this.toolTipPosition.x - 2, this.toolTipPosition.y - height, width + 4, height + 4);
                    g2.drawString(this.toolTipLabel, this.toolTipPosition.x, this.toolTipPosition.y);
                }
            }
            if (this.polygon != null) {
                g2.setColor(this.color);
                g2.drawPolygon(this.polygon);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.setPaint(this.color);
                g2.fillPolygon(this.polygon);
            }
        }

        public void saveToPngImageFile(String filename) throws IOException {
            try {
                this.paint(this.imageBuffer.getGraphics());
                ImageIO.write((RenderedImage)this.imageBuffer, "png", new File(filename));
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void saveToEpsImageFile(String filename) throws IOException {
            FileOutputStream outputStream = new FileOutputStream(filename);
            EpsGraphics g = new EpsGraphics(filename, (OutputStream)outputStream, 0, 0, ((ProjectionViewer)ProjectionViewer.this).graph.getSize().width + 1, ((ProjectionViewer)ProjectionViewer.this).graph.getSize().height + 1, ColorMode.COLOR_RGB);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            if (ProjectionViewer.this.highQualityRender) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 0, ((ProjectionViewer)ProjectionViewer.this).graph.getSize().width + 1, ((ProjectionViewer)ProjectionViewer.this).graph.getSize().height + 1);
            g.setFont(this.getFont());
            ProjectionViewer.this.graph.draw(ProjectionViewer.this.getCurrentConnectivity(), (Graphics2D)g);
            for (Topic topic : this.topics) {
                topic.drawTopic((Graphics)g, this.getFont(), false);
            }
            g.flush();
            g.close();
        }

        public void setGraph(Graph graph) {
            if (graph != null) {
                this.setPreferredSize(new Dimension(graph.getSize().width * 2, graph.getSize().height * 2));
                this.setSize(new Dimension(graph.getSize().width * 2, graph.getSize().height * 2));
                this.cleanImage();
                this.repaint();
            }
        }

        public Vertex getMarkedVertex() {
            return this.markedVertex;
        }

        public void cleanImage() {
            this.imageBuffer = null;
        }

        public ColorTable getColorTable() {
            return this.colorTable;
        }

        public void colorAs(Scalar scalar) {
            ArrayList<Vertex> vertex = ProjectionViewer.this.graph.getVertex();
            for (Vertex v : vertex) {
                v.setColor(scalar, this.colorTable);
            }
            this.cleanImage();
            this.repaint();
        }

        public void resizeAs(Scalar scalar) {
            ArrayList<Vertex> vertex = ProjectionViewer.this.graph.getVertex();
            for (Vertex v : vertex) {
                v.setRayFactor(scalar);
            }
            this.cleanImage();
            this.repaint();
        }

        public void adjustPanel() {
            float iniX = ProjectionViewer.this.graph.getVertex().get(0).getX();
            float iniY = ProjectionViewer.this.graph.getVertex().get(0).getY();
            float max_x = iniX;
            float max_y = iniX;
            float min_x = iniY;
            float min_y = iniY;
            int zero = ProjectionViewer.this.graph.getVertex().get(0).getRayBase() * 5 + 10;
            for (int i = 1; i < ProjectionViewer.this.graph.getVertex().size(); ++i) {
                float x = ProjectionViewer.this.graph.getVertex().get(i).getX();
                if (max_x < x) {
                    max_x = x;
                } else if (min_x > x) {
                    min_x = x;
                }
                float y = ProjectionViewer.this.graph.getVertex().get(i).getY();
                if (max_y < y) {
                    max_y = y;
                    continue;
                }
                if (!(min_y > y)) continue;
                min_y = y;
            }
            for (Vertex v : ProjectionViewer.this.graph.getVertex()) {
                v.setX(v.getX() + (float)zero - min_x);
                v.setY(v.getY() + (float)zero - min_y);
            }
            Dimension d = this.getSize();
            d.width = (int)max_x + zero;
            d.height = (int)max_y + zero;
            this.setSize(d);
            this.setPreferredSize(d);
        }

        public void markNeighbors(Vertex vertex) {
            if (ProjectionViewer.this.graph != null) {
                this.cleanMarkedVertices(false);
                ArrayList<Vertex> neighborsVertex = new ArrayList<Vertex>();
                ArrayList<Edge> neighborsEdges = new ArrayList<Edge>();
                ProjectionViewer.this.graph.getNeighbors(neighborsVertex, neighborsEdges, ProjectionViewer.this.getCurrentConnectivity(), vertex, ProjectionViewer.this.neighborhoodDepth);
                this.pexview.setNearestNeighborsPoints(neighborsVertex);
                this.pexview.setMarkedPointText(ProjectionViewer.this.graph.getCorpus(), vertex);
                vertex.setSelected(true);
                if (neighborsVertex != null) {
                    for (Vertex v : neighborsVertex) {
                        v.setSelected(true);
                    }
                }
                this.cleanImage();
                this.repaint();
            }
        }

        public void markVertices(ArrayList<Vertex> vertices) {
            if (vertices != null) {
                this.cleanMarkedVertices(false);
                for (Vertex v : vertices) {
                    v.setSelected(true);
                }
                this.cleanImage();
                this.repaint();
            }
        }

        public void cleanMarkedVertices(boolean cleanVertex) {
            if (ProjectionViewer.this.graph != null) {
                this.markedVertex = null;
                for (Vertex vertex : ProjectionViewer.this.graph.getVertex()) {
                    vertex.setSelected(false);
                    if (!cleanVertex) continue;
                    Vertex.setShowLabel(false);
                }
            }
            this.cleanImage();
            this.repaint();
        }

        public void deleteSelectedVertex() {
            if (this.selectedVertices != null && this.selectedVertices.size() > 0) {
                ProjectionViewer.this.graph.removeVertex(this.selectedVertices);
                this.cleanMarkedVertices(true);
                this.selectedVertex = null;
                this.selectedVertices = null;
                this.cleanImage();
                this.repaint();
                this.pexview.recreatingLists(ProjectionViewer.this.graph.getVertex());
                ProjectionViewer.this.setGraphChanged(true);
            }
        }

        public ArrayList<Vertex> getSelectedVertex(Polygon polygon) {
            ArrayList<Vertex> selected = new ArrayList<Vertex>();
            if (ProjectionViewer.this.graph != null) {
                for (Vertex v : ProjectionViewer.this.graph.getVertex()) {
                    if (!polygon.contains(v.getX(), v.getY())) continue;
                    selected.add(v);
                }
            }
            return selected;
        }

        public ArrayList<Vertex> getSelectedVertex(Point localSource, Point localTarget) {
            ArrayList<Vertex> selVertex = new ArrayList<Vertex>();
            if (ProjectionViewer.this.graph != null) {
                int x = localSource.x;
                int width = localTarget.x - localSource.x;
                int y = localSource.y;
                int height = localTarget.y - localSource.y;
                if (localSource.x > localTarget.x) {
                    x = localTarget.x;
                    width = localSource.x - localTarget.x;
                }
                if (localSource.y > localTarget.y) {
                    y = localTarget.y;
                    height = localSource.y - localTarget.y;
                }
                Rectangle rect = new Rectangle(x, y, width, height);
                for (Vertex v : ProjectionViewer.this.graph.getVertex()) {
                    if (!v.isInside(rect)) continue;
                    selVertex.add(v);
                }
            }
            return selVertex;
        }

        public Topic getTopicByPosition(Point point) {
            float dist = Float.MAX_VALUE;
            Topic topic = null;
            for (Topic t : this.topics) {
                float aux = t.weightDistance(point);
                if (aux == -1.0f || !(dist > aux)) continue;
                dist = aux;
                topic = t;
            }
            return topic;
        }

        public Topic getTopicByBoxPosition(Point point) {
            Topic topic = null;
            for (Topic t : this.topics) {
                if (!t.isBoxInside(point)) continue;
                return t;
            }
            return topic;
        }

        @Override
        public void setFont(Font font) {
            ProjectionViewer.this.setFont(font);
        }

        @Override
        public Font getFont() {
            return ProjectionViewer.this.getFont();
        }

        public ArrayList<Topic> getTopics() {
            return this.topics;
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (this.csp != null) {
                this.csp.setBackground(bg);
            }
        }

        class MouseClickedListener
        extends MouseAdapter {
            MouseClickedListener() {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                super.mouseClicked(evt);
                if (ProjectionViewer.this.graph != null) {
                    if (evt.getButton() == 1) {
                        Vertex v;
                        if (!(highlightTopic || evt.isControlDown() || evt.isShiftDown() || (v = ProjectionViewer.this.graph.getVertexByPosition(evt.getX(), evt.getY())) == null)) {
                            if (evt.getClickCount() == 1) {
                                ViewPanel.this.markNeighbors(v);
                                ViewPanel.this.markedVertex = v;
                            } else if (v.getUrl().endsWith("txt")) {
                                if (OpenDialog.checkCorpus(ProjectionViewer.this.graph, ViewPanel.this.pexview)) {
                                    MultipleFileView.getInstance(ViewPanel.this.pexview).display((Viewer)ProjectionViewer.this, v);
                                }
                            } else if (OpenDialog.checkImages(ProjectionViewer.this.graph, ViewPanel.this.pexview)) {
                                MultipleImageView.getInstance(ViewPanel.this.pexview).display((Viewer)ProjectionViewer.this, v);
                            }
                        }
                    } else if (evt.getButton() == 3) {
                        ViewPanel.this.cleanMarkedVertices(true);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                super.mousePressed(evt);
                if (evt.getButton() == 1) {
                    if (ProjectionViewer.this.graph != null) {
                        if (movePoints) {
                            ViewPanel.this.selectedVertex = ProjectionViewer.this.graph.getVertexByPosition(evt.getX(), evt.getY());
                            if (ViewPanel.this.selectedVertex != null) {
                                ViewPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                            }
                        }
                        Scalar s = (Scalar)ProjectionViewer.this.scalarCombo.getSelectedItem();
                        ViewPanel.this.source = evt.getPoint();
                        ViewPanel.this.color = VertexSelectionFactory.getInstance(ProjectionViewer.this, type, s).getColor();
                    }
                } else if (evt.getButton() == 3) {
                    Scalar s = (Scalar)ProjectionViewer.this.scalarCombo.getSelectedItem();
                    ViewPanel.this.polygon = new Polygon();
                    ViewPanel.this.polygon.addPoint(evt.getX(), evt.getY());
                    ViewPanel.this.color = VertexSelectionFactory.getInstance(ProjectionViewer.this, type, s).getColor();
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                super.mouseReleased(evt);
                if (ProjectionViewer.this.graph != null && (ViewPanel.this.source != null && ViewPanel.this.target != null || ViewPanel.this.polygon != null)) {
                    ArrayList<Vertex> vertices = null;
                    vertices = ViewPanel.this.polygon != null ? ViewPanel.this.getSelectedVertex(ViewPanel.this.polygon) : ViewPanel.this.getSelectedVertex(ViewPanel.this.source, ViewPanel.this.target);
                    if (vertices != null) {
                        ViewPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        ViewPanel.this.cleanMarkedVertices(false);
                        Scalar s = (Scalar)ProjectionViewer.this.scalarCombo.getSelectedItem();
                        ViewPanel.this.selectedVertices = VertexSelectionFactory.getInstance(ProjectionViewer.this, type, s).vertexSelected(null, vertices);
                        ViewPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (ViewPanel.this.selectedVertex != null) {
                    ViewPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                ViewPanel.this.polygon = null;
                ViewPanel.this.selectedVertex = null;
                ViewPanel.this.source = null;
                ViewPanel.this.target = null;
                ViewPanel.this.repaint();
            }
        }

        class MouseMotionListener
        extends MouseMotionAdapter {
            MouseMotionListener() {
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                super.mouseMoved(evt);
                if (ProjectionViewer.this.graph != null) {
                    Topic topicByPosition;
                    Vertex vertex = null;
                    if (highlightTopic || evt.isControlDown()) {
                        topicByPosition = ViewPanel.this.getTopicByPosition(evt.getPoint());
                        if (ViewPanel.this.selectedTopic != null) {
                            ViewPanel.this.selectedTopic.setShowThisTopic(false);
                        }
                        if (topicByPosition != null) {
                            ViewPanel.this.selectedTopic = topicByPosition;
                            topicByPosition.setShowThisTopic(true);
                        } else {
                            ViewPanel.this.selectedTopic = null;
                        }
                    } else if (evt.isShiftDown()) {
                        topicByPosition = ViewPanel.this.getTopicByPosition(evt.getPoint());
                        if (topicByPosition != null) {
                            if (ViewPanel.this.selectedTopic != topicByPosition) {
                                ViewPanel.this.selectedTopic = topicByPosition;
                                topicByPosition.setShowThisTopic(!topicByPosition.isShowThisTopic());
                            }
                        } else {
                            ViewPanel.this.selectedTopic = null;
                        }
                    } else {
                        ViewPanel.this.selectedTopic = null;
                        vertex = ProjectionViewer.this.graph.getVertexByPosition(evt.getX(), evt.getY());
                    }
                    if (vertex != null) {
                        if (Vertex.isShowImage()) {
                            try {
                                Image im = ProjectionViewer.this.graph.getImageCollection().getImage(vertex.getUrl());
                                if (im != null) {
                                    ViewPanel.this.toolTipImage = im.getScaledInstance(100, 100, 0);
                                } else {
                                    ViewPanel.this.toolTipImage = null;
                                }
                                ViewPanel.this.toolTipLabel = "";
                                ViewPanel.this.toolTipPosition = evt.getPoint();
                                ViewPanel.this.repaint();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        } else if (Vertex.isShowContent()) {
                            try {
                                ViewPanel.this.toolTipLabel = ProjectionViewer.this.graph.getCorpus().getFullContent(vertex.getUrl());
                            }
                            catch (IOException ex) {
                                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                            }
                            ViewPanel.this.toolTipImage = null;
                        } else if (Vertex.isShowTitle()) {
                            ViewPanel.this.toolTipLabel = vertex.toString();
                            ViewPanel.this.toolTipImage = null;
                        } else {
                            ViewPanel.this.toolTipLabel = null;
                            ViewPanel.this.toolTipImage = null;
                        }
                        if (ViewPanel.this.toolTipLabel != null && ViewPanel.this.toolTipLabel.trim().length() > 0) {
                            if (ViewPanel.this.toolTipLabel.length() > 100) {
                                ViewPanel.this.toolTipLabel = ViewPanel.this.toolTipLabel.substring(0, 96) + "...";
                            }
                            ViewPanel.this.toolTipPosition = evt.getPoint();
                            ViewPanel.this.repaint();
                        }
                        ProjectionViewer.this.titleTextField.setText(ViewPanel.this.toolTipLabel);
                        ProjectionViewer.this.titleTextField.setCaretPosition(0);
                    } else {
                        ProjectionViewer.this.titleTextField.setText("");
                        ViewPanel.this.toolTipLabel = null;
                        ViewPanel.this.toolTipPosition = null;
                        ViewPanel.this.toolTipImage = null;
                        ViewPanel.this.repaint();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                if (movePoints && ViewPanel.this.selectedVertex != null) {
                    if (ViewPanel.this.selectedVertices != null && ViewPanel.this.selectedVertices.size() > 0 && ViewPanel.this.selectedVertices.contains(ViewPanel.this.selectedVertex)) {
                        float x = (float)evt.getX() - ViewPanel.this.selectedVertex.getX();
                        float y = (float)evt.getY() - ViewPanel.this.selectedVertex.getY();
                        for (Vertex v : ViewPanel.this.selectedVertices) {
                            v.setX(x + v.getX());
                            v.setY(y + v.getY());
                        }
                        ProjectionViewer.this.setGraphChanged(true);
                        ViewPanel.this.adjustPanel();
                    } else {
                        ViewPanel.this.selectedVertex.setX(evt.getX());
                        ViewPanel.this.selectedVertex.setY(evt.getY());
                        ProjectionViewer.this.setGraphChanged(true);
                        ViewPanel.this.adjustPanel();
                    }
                    ViewPanel.this.cleanImage();
                } else if (ViewPanel.this.source != null) {
                    ViewPanel.this.target = evt.getPoint();
                }
                if (ViewPanel.this.polygon != null) {
                    ViewPanel.this.polygon.addPoint(evt.getX(), evt.getY());
                }
                ViewPanel.this.repaint();
            }
        }
    }
}

