/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visualizer.dimensionreduction.DimensionalityReductionType;
import visualizer.projection.ProjectionData;
import visualizer.projection.ProjectionType;
import visualizer.projection.SourceType;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.kolmogorov.CompressorType;

public class ReportView
extends JPanel {
    private JLabel clusterFactorLabel;
    private JTextField clusterFactorTextField;
    private JPanel dataPanel;
    private JLabel dimenRedTechniqueLabel;
    private JTextField dimenRedTechniqueTextField;
    private JPanel dimenReductionPanel;
    private JLabel distanceTypeLabel;
    private JTextField distanceTypeTextField;
    private JPanel forcePanel;
    private JLabel fractionDeltaLabel;
    private JTextField fractionDeltaTextField;
    private JLabel luhnLowerCutLabel;
    private JTextField luhnLowerCutTextField;
    private JLabel luhnUpperCutLabel;
    private JTextField luhnUpperCutTextField;
    private JLabel numberCPLabel;
    private JTextField numberCPTextField;
    private JLabel numberDimensionsLabel;
    private JTextField numberDimensionsTextField;
    private JLabel numberGramsLabel;
    private JTextField numberGramsTextField;
    private JLabel numberIterationsLabel;
    private JTextField numberIterationsTextField;
    private JLabel numberNeighborsLabel;
    private JTextField numberNeighborsTextField;
    private JLabel numberObjectsLabel;
    private JTextField numberObjectsTextField;
    private JPanel preprocessingPanel;
    private JLabel projTechniqueLabel;
    private JTextField projTechniqueTextField;
    private JPanel projectionPanel;
    private JLabel projectionTypeLabel;
    private JTextField projectionTypeTextField;
    private JLabel resultingDimenLabel;
    private JTextField resultingDimenLabelTextField;
    private JLabel sourceLabel;
    private JTextField sourceTextField;

    public ReportView() {
        this.initComponents();
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceTextField = new JTextField();
        this.preprocessingPanel = new JPanel();
        this.luhnLowerCutLabel = new JLabel();
        this.luhnLowerCutTextField = new JTextField();
        this.numberGramsLabel = new JLabel();
        this.numberGramsTextField = new JTextField();
        this.luhnUpperCutLabel = new JLabel();
        this.luhnUpperCutTextField = new JTextField();
        this.projectionPanel = new JPanel();
        this.numberCPTextField = new JTextField();
        this.projectionTypeTextField = new JTextField();
        this.numberCPLabel = new JLabel();
        this.distanceTypeTextField = new JTextField();
        this.distanceTypeLabel = new JLabel();
        this.numberNeighborsTextField = new JTextField();
        this.clusterFactorLabel = new JLabel();
        this.numberNeighborsLabel = new JLabel();
        this.projectionTypeLabel = new JLabel();
        this.projTechniqueTextField = new JTextField();
        this.projTechniqueLabel = new JLabel();
        this.clusterFactorTextField = new JTextField();
        this.forcePanel = new JPanel();
        this.fractionDeltaTextField = new JTextField();
        this.numberIterationsTextField = new JTextField();
        this.numberIterationsLabel = new JLabel();
        this.fractionDeltaLabel = new JLabel();
        this.dimenReductionPanel = new JPanel();
        this.dimenRedTechniqueLabel = new JLabel();
        this.dimenRedTechniqueTextField = new JTextField();
        this.resultingDimenLabel = new JLabel();
        this.resultingDimenLabelTextField = new JTextField();
        this.dataPanel = new JPanel();
        this.numberObjectsLabel = new JLabel();
        this.numberObjectsTextField = new JTextField();
        this.numberDimensionsLabel = new JLabel();
        this.numberDimensionsTextField = new JTextField();
        this.setBorder(BorderFactory.createTitledBorder("Projection Parameters"));
        this.setLayout(new GridBagLayout());
        this.sourceLabel.setText("Source");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceTextField.setColumns(40);
        this.sourceTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.sourceTextField, gridBagConstraints);
        this.preprocessingPanel.setBorder(BorderFactory.createTitledBorder("Pre-processing"));
        this.preprocessingPanel.setLayout(new GridBagLayout());
        this.luhnLowerCutLabel.setText("Luhn's lower cut");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preprocessingPanel.add((Component)this.luhnLowerCutLabel, gridBagConstraints);
        this.luhnLowerCutTextField.setColumns(5);
        this.luhnLowerCutTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preprocessingPanel.add((Component)this.luhnLowerCutTextField, gridBagConstraints);
        this.numberGramsLabel.setText("Number of Grams");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preprocessingPanel.add((Component)this.numberGramsLabel, gridBagConstraints);
        this.numberGramsTextField.setColumns(5);
        this.numberGramsTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preprocessingPanel.add((Component)this.numberGramsTextField, gridBagConstraints);
        this.luhnUpperCutLabel.setText("Luhn's upper cut");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preprocessingPanel.add((Component)this.luhnUpperCutLabel, gridBagConstraints);
        this.luhnUpperCutTextField.setColumns(5);
        this.luhnUpperCutTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preprocessingPanel.add((Component)this.luhnUpperCutTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.preprocessingPanel, gridBagConstraints);
        this.projectionPanel.setBorder(BorderFactory.createTitledBorder("Projection"));
        this.projectionPanel.setLayout(new GridBagLayout());
        this.numberCPTextField.setColumns(5);
        this.numberCPTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.numberCPTextField, gridBagConstraints);
        this.projectionTypeTextField.setColumns(10);
        this.projectionTypeTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.projectionTypeTextField, gridBagConstraints);
        this.numberCPLabel.setText("Number Control Points");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.numberCPLabel, gridBagConstraints);
        this.distanceTypeTextField.setColumns(10);
        this.distanceTypeTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.distanceTypeTextField, gridBagConstraints);
        this.distanceTypeLabel.setText("Distance Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.distanceTypeLabel, gridBagConstraints);
        this.numberNeighborsTextField.setColumns(5);
        this.numberNeighborsTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.numberNeighborsTextField, gridBagConstraints);
        this.clusterFactorLabel.setText("Cluster Factor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.clusterFactorLabel, gridBagConstraints);
        this.numberNeighborsLabel.setText("Number Neighbors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.numberNeighborsLabel, gridBagConstraints);
        this.projectionTypeLabel.setText("Projection Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.projectionTypeLabel, gridBagConstraints);
        this.projTechniqueTextField.setColumns(10);
        this.projTechniqueTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.projTechniqueTextField, gridBagConstraints);
        this.projTechniqueLabel.setText("Projection Technique");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.projTechniqueLabel, gridBagConstraints);
        this.clusterFactorTextField.setColumns(5);
        this.clusterFactorTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.clusterFactorTextField, gridBagConstraints);
        this.forcePanel.setBorder(BorderFactory.createTitledBorder("Force Scheme"));
        this.forcePanel.setLayout(new GridBagLayout());
        this.fractionDeltaTextField.setColumns(5);
        this.fractionDeltaTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.forcePanel.add((Component)this.fractionDeltaTextField, gridBagConstraints);
        this.numberIterationsTextField.setColumns(5);
        this.numberIterationsTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.forcePanel.add((Component)this.numberIterationsTextField, gridBagConstraints);
        this.numberIterationsLabel.setText("Number iterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.forcePanel.add((Component)this.numberIterationsLabel, gridBagConstraints);
        this.fractionDeltaLabel.setText("Fraction of delta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.forcePanel.add((Component)this.fractionDeltaLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.forcePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.projectionPanel, gridBagConstraints);
        this.dimenReductionPanel.setBorder(BorderFactory.createTitledBorder("Dimensionality Reduction"));
        this.dimenReductionPanel.setLayout(new GridBagLayout());
        this.dimenRedTechniqueLabel.setText("Technique");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dimenReductionPanel.add((Component)this.dimenRedTechniqueLabel, gridBagConstraints);
        this.dimenRedTechniqueTextField.setColumns(10);
        this.dimenRedTechniqueTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dimenReductionPanel.add((Component)this.dimenRedTechniqueTextField, gridBagConstraints);
        this.resultingDimenLabel.setText("Resulting dimensions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dimenReductionPanel.add((Component)this.resultingDimenLabel, gridBagConstraints);
        this.resultingDimenLabelTextField.setColumns(5);
        this.resultingDimenLabelTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dimenReductionPanel.add((Component)this.resultingDimenLabelTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.dimenReductionPanel, gridBagConstraints);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.numberObjectsLabel.setText("Number Objects");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberObjectsLabel, gridBagConstraints);
        this.numberObjectsTextField.setColumns(5);
        this.numberObjectsTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberObjectsTextField, gridBagConstraints);
        this.numberDimensionsLabel.setText("Number Dimensions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberDimensionsLabel, gridBagConstraints);
        this.numberDimensionsTextField.setColumns(5);
        this.numberDimensionsTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.numberDimensionsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.dataPanel, gridBagConstraints);
    }

    public void reset(ProjectionData pdata) {
        this.clean();
        if (pdata.getSourceFile().trim().length() > 0) {
            this.sourceTextField.setText(pdata.getSourceFile());
            this.numberDimensionsTextField.setText(Integer.toString(pdata.getNumberDimensions()));
            this.numberObjectsTextField.setText(Integer.toString(pdata.getNumberObjects()));
            if (pdata.getSourceType() == SourceType.CORPUS) {
                this.luhnLowerCutTextField.setText(Integer.toString(pdata.getLunhLowerCut()));
                this.numberGramsTextField.setText(Integer.toString(pdata.getNumberGrams()));
                if (pdata.getLunhUpperCut() > -1) {
                    this.luhnUpperCutTextField.setText(Integer.toString(pdata.getLunhUpperCut()));
                }
            }
            this.dimenRedTechniqueTextField.setText(pdata.getDimensionReductionType().toString());
            if (pdata.getDimensionReductionType() != DimensionalityReductionType.NONE) {
                this.resultingDimenLabelTextField.setText(Integer.toString(pdata.getTargetDimension()));
            }
            if (pdata.getProjectionType() != null) {
                this.projTechniqueTextField.setText(pdata.getProjectionType().toString());
                if (pdata.getProjectionType() != ProjectionType.CLASSICAL_SCALING) {
                    if (pdata.getProjectionType() == ProjectionType.IDMAP) {
                        this.projectionTypeTextField.setText(pdata.getProjectorType().toString());
                        this.fractionDeltaTextField.setText(Float.toString(pdata.getFractionDelta()));
                        this.numberIterationsTextField.setText(Integer.toString(pdata.getNumberIterations()));
                    } else if (pdata.getProjectionType() == ProjectionType.ISOMAP) {
                        this.numberNeighborsTextField.setText(Integer.toString(pdata.getNumberNeighborsConnection()));
                    } else if (pdata.getProjectionType() == ProjectionType.LLE) {
                        this.numberNeighborsTextField.setText(Integer.toString(pdata.getNumberNeighborsConnection()));
                    } else if (pdata.getProjectionType() == ProjectionType.LSP) {
                        this.projectionTypeTextField.setText(pdata.getProjectorType().toString());
                        this.fractionDeltaTextField.setText(Float.toString(pdata.getFractionDelta()));
                        this.numberIterationsTextField.setText(Integer.toString(pdata.getNumberIterations()));
                        this.numberCPTextField.setText(Integer.toString(pdata.getNumberControlPoints()));
                        this.numberNeighborsTextField.setText(Integer.toString(pdata.getNumberNeighborsConnection()));
                    } else if (pdata.getProjectionType() != ProjectionType.MST && pdata.getProjectionType() != ProjectionType.NJ && pdata.getProjectionType() != ProjectionType.PCA) {
                        if (pdata.getProjectionType() == ProjectionType.PROJCLUS) {
                            this.projectionTypeTextField.setText(pdata.getProjectorType().toString());
                            this.clusterFactorTextField.setText(Float.toString(pdata.getClusterFactor()));
                            this.fractionDeltaTextField.setText(Float.toString(pdata.getFractionDelta()));
                            this.numberIterationsTextField.setText(Integer.toString(pdata.getNumberIterations()));
                        } else if (pdata.getProjectionType() == ProjectionType.SAMMON) {
                            this.fractionDeltaTextField.setText(Float.toString(pdata.getFractionDelta()));
                            this.numberIterationsTextField.setText(Integer.toString(pdata.getNumberIterations()));
                        }
                    }
                }
                if (pdata.getSourceType() != SourceType.DISTANCE_MATRIX) {
                    if (pdata.getDissimilarityType() != null) {
                        this.distanceTypeTextField.setText(pdata.getDissimilarityType().toString());
                    }
                    if (pdata.getDissimilarityType() == DissimilarityType.KOLMOGOROV) {
                        if (pdata.getCompressorType() == CompressorType.GZIP) {
                            this.distanceTypeTextField.setText("NCD(gzip)");
                        } else if (pdata.getCompressorType() == CompressorType.BZIP2) {
                            this.distanceTypeTextField.setText("NCD(bzip2)");
                        } else {
                            this.distanceTypeTextField.setText("LZO(lzo1)");
                        }
                    }
                }
            }
        }
    }

    private void clean() {
        this.clusterFactorTextField.setText("");
        this.dimenRedTechniqueTextField.setText("");
        this.distanceTypeTextField.setText("");
        this.fractionDeltaTextField.setText("");
        this.luhnLowerCutTextField.setText("");
        this.luhnUpperCutTextField.setText("");
        this.numberCPTextField.setText("");
        this.numberDimensionsTextField.setText("");
        this.numberGramsTextField.setText("");
        this.numberIterationsTextField.setText("");
        this.numberNeighborsTextField.setText("");
        this.numberObjectsTextField.setText("");
        this.projTechniqueTextField.setText("");
        this.projectionTypeTextField.setText("");
        this.resultingDimenLabelTextField.setText("");
        this.sourceTextField.setText("");
    }
}

