/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visualizer.util.SystemPropertiesManager;

public class Splash
extends JFrame {
    private static Splash splash = new Splash();

    private Splash() {
        this.setVisible(false);
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        SplashPanel sp = new SplashPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)sp, "Center");
        this.setSize(sp.getWidth(), sp.getHeight());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        this.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    public static Splash getInstance() {
        return splash;
    }

    public void start() {
        this.setCursor(new Cursor(3));
        this.setVisible(true);
    }

    public void stop() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            Splash.getInstance().start();
            Thread.sleep(2000L);
            Splash.getInstance().stop();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Splash.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class SplashPanel
    extends JPanel {
        private String imgName = "/images/splash.png";
        private Toolkit toolkit;
        private Image image;

        public SplashPanel() {
            MediaTracker media = new MediaTracker(this);
            this.toolkit = Toolkit.getDefaultToolkit();
            this.image = this.toolkit.getImage(SplashPanel.class.getResource(this.imgName));
            if (this.image != null) {
                try {
                    media.addImage(this.image, 0);
                    media.waitForID(0);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Splash.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.setPreferredSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
            this.setSize(this.image.getWidth(this), this.image.getHeight(this));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.image, 0, 0, this.getBackground(), this);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setColor(Color.BLACK);
            String version = SystemPropertiesManager.getInstance().getProperty("TOOL.VERSION");
            if (version == null || version.trim().length() < 1) {
                version = "**.**.**";
            }
            g.setFont(new Font("Verdana", 1, 12));
            g.drawString("Version " + version, 315, 255);
        }
    }
}

