/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visualizer.corpus.Corpus;
import visualizer.corpus.Encoding;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.topic.CovarianceTopicSettings;
import visualizer.topic.TopicData;
import visualizer.topic.TopicRuleTFSettings;
import visualizer.util.OpenDialog;
import visualizer.view.Viewer;

public class ToolConfiguration
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Graph graph;
    private Viewer gv;
    private static ToolConfiguration instance;
    private JPanel adjustsPanel;
    private JButton backGroundButton;
    private JPanel buttonPanel;
    private JRadioButton circlesRadioButton;
    private JButton closeButton;
    private JRadioButton covarianceRadioButton;
    private JRadioButton dotsRadioButton;
    private JPanel drawPanel;
    private ButtonGroup drawbuttonGroup;
    private JPanel encodingPanel;
    private JComboBox encodingsComboBox;
    private JPanel generalPanel;
    private ButtonGroup graphicQualityGroup;
    private JRadioButton highRadioButton;
    private JRadioButton imagesRadioButton;
    private ButtonGroup labelGroup;
    private JPanel labelPanel;
    private JComboBox labelfontSizeComboBox;
    private JLabel labelfontSizeLabel;
    private JComboBox labelsComboBox;
    private JComboBox neighborhoodDepthComboBox;
    private JLabel neighborhoodDepthLabel;
    private JPanel paremetersPanel;
    private JRadioButton poorRadioButton;
    private JPanel qualityPanel;
    private JButton refreshButton;
    private JRadioButton rulesRadioButton;
    private JButton settingsCovarianceButton;
    private JButton settingsRulesButton;
    private JCheckBox showEdgesCheckBox;
    private JCheckBox showEdgesLabelsCheckBox;
    private JCheckBox showVertexLabel;
    private JCheckBox shownonvalidCheckBox;
    private JComboBox titlefontSizeComboBox;
    private JComboBox titlefontSizeComboBox1;
    private JLabel titlefontSizeLabel;
    private JLabel titlefontSizeLabel1;
    private JLabel vertexLabel;
    private JSlider vertexRaySlider;

    private ToolConfiguration(JFrame parent) {
        super(parent);
        this.initComponents();
        this.setModal(true);
        this.encodingsComboBox.removeAllItems();
        for (Encoding e : Encoding.getEncodings()) {
            this.encodingsComboBox.addItem(e);
        }
    }

    private void initComponents() {
        this.graphicQualityGroup = new ButtonGroup();
        this.labelGroup = new ButtonGroup();
        this.drawbuttonGroup = new ButtonGroup();
        this.adjustsPanel = new JPanel();
        this.vertexRaySlider = new JSlider();
        this.labelPanel = new JPanel();
        this.covarianceRadioButton = new JRadioButton();
        this.settingsRulesButton = new JButton();
        this.rulesRadioButton = new JRadioButton();
        this.settingsCovarianceButton = new JButton();
        this.encodingPanel = new JPanel();
        this.encodingsComboBox = new JComboBox();
        this.paremetersPanel = new JPanel();
        this.labelfontSizeLabel = new JLabel();
        this.labelfontSizeComboBox = new JComboBox<String>(new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20"});
        this.backGroundButton = new JButton();
        this.qualityPanel = new JPanel();
        this.highRadioButton = new JRadioButton();
        this.poorRadioButton = new JRadioButton();
        this.drawPanel = new JPanel();
        this.circlesRadioButton = new JRadioButton();
        this.dotsRadioButton = new JRadioButton();
        this.imagesRadioButton = new JRadioButton();
        this.titlefontSizeLabel = new JLabel();
        this.titlefontSizeComboBox = new JComboBox<String>(new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20"});
        this.titlefontSizeLabel1 = new JLabel();
        this.titlefontSizeComboBox1 = new JComboBox<String>(new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20"});
        this.vertexLabel = new JLabel();
        this.labelsComboBox = new JComboBox<String>(new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20"});
        this.generalPanel = new JPanel();
        this.shownonvalidCheckBox = new JCheckBox();
        this.showVertexLabel = new JCheckBox();
        this.showEdgesCheckBox = new JCheckBox();
        this.showEdgesLabelsCheckBox = new JCheckBox();
        this.neighborhoodDepthLabel = new JLabel();
        this.neighborhoodDepthComboBox = new JComboBox();
        this.buttonPanel = new JPanel();
        this.refreshButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Tools Properties");
        this.adjustsPanel.setBorder(BorderFactory.createTitledBorder("Adjustments "));
        this.adjustsPanel.setLayout(new GridBagLayout());
        this.vertexRaySlider.setMajorTickSpacing(10);
        this.vertexRaySlider.setMaximum(30);
        this.vertexRaySlider.setMinorTickSpacing(1);
        this.vertexRaySlider.setPaintLabels(true);
        this.vertexRaySlider.setPaintTicks(true);
        this.vertexRaySlider.setToolTipText("Vertex ray");
        this.vertexRaySlider.setValue(10);
        this.vertexRaySlider.setBorder(BorderFactory.createTitledBorder("Vertex Ray"));
        this.vertexRaySlider.setPreferredSize(new Dimension(200, 65));
        this.vertexRaySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ToolConfiguration.this.vertexRaySliderStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.adjustsPanel.add((Component)this.vertexRaySlider, gridBagConstraints);
        this.labelPanel.setBorder(BorderFactory.createTitledBorder("Labels"));
        this.labelPanel.setLayout(new GridBagLayout());
        this.labelGroup.add(this.covarianceRadioButton);
        this.covarianceRadioButton.setMnemonic('H');
        this.covarianceRadioButton.setText("Covariance");
        this.covarianceRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.covarianceRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.labelPanel.add((Component)this.covarianceRadioButton, gridBagConstraints);
        this.settingsRulesButton.setText("Settings");
        this.settingsRulesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.settingsRulesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.labelPanel.add((Component)this.settingsRulesButton, gridBagConstraints);
        this.labelGroup.add(this.rulesRadioButton);
        this.rulesRadioButton.setMnemonic('P');
        this.rulesRadioButton.setText("Rules");
        this.rulesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.rulesRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.labelPanel.add((Component)this.rulesRadioButton, gridBagConstraints);
        this.settingsCovarianceButton.setText("Settings");
        this.settingsCovarianceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.settingsCovarianceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.labelPanel.add((Component)this.settingsCovarianceButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.adjustsPanel.add((Component)this.labelPanel, gridBagConstraints);
        this.encodingPanel.setBorder(BorderFactory.createTitledBorder("Character Encoding"));
        this.encodingPanel.setLayout(new BorderLayout());
        this.encodingsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.encodingsComboBoxActionPerformed(evt);
            }
        });
        this.encodingPanel.add((Component)this.encodingsComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.adjustsPanel.add((Component)this.encodingPanel, gridBagConstraints);
        this.paremetersPanel.setBorder(BorderFactory.createTitledBorder("Graphics Parameters"));
        this.paremetersPanel.setLayout(new GridBagLayout());
        this.labelfontSizeLabel.setText("Labels's font size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.labelfontSizeLabel, gridBagConstraints);
        this.labelfontSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.labelfontSizeComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.labelfontSizeComboBox, gridBagConstraints);
        this.backGroundButton.setText("BackGround Color");
        this.backGroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.backGroundButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.paremetersPanel.add((Component)this.backGroundButton, gridBagConstraints);
        this.qualityPanel.setBorder(BorderFactory.createTitledBorder("Render Quality"));
        this.qualityPanel.setLayout(new GridBagLayout());
        this.graphicQualityGroup.add(this.highRadioButton);
        this.highRadioButton.setSelected(true);
        this.highRadioButton.setText("High quality (slow)");
        this.highRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.highRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.highRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.highRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.qualityPanel.add((Component)this.highRadioButton, gridBagConstraints);
        this.graphicQualityGroup.add(this.poorRadioButton);
        this.poorRadioButton.setText("Poor quality (fast)");
        this.poorRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.poorRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.poorRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.poorRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.qualityPanel.add((Component)this.poorRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.paremetersPanel.add((Component)this.qualityPanel, gridBagConstraints);
        this.drawPanel.setBorder(BorderFactory.createTitledBorder("Draw"));
        this.drawPanel.setLayout(new GridBagLayout());
        this.drawbuttonGroup.add(this.circlesRadioButton);
        this.circlesRadioButton.setSelected(true);
        this.circlesRadioButton.setText("circles");
        this.circlesRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.circlesRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.circlesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.circlesRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.drawPanel.add((Component)this.circlesRadioButton, gridBagConstraints);
        this.drawbuttonGroup.add(this.dotsRadioButton);
        this.dotsRadioButton.setText("points");
        this.dotsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dotsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.dotsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.dotsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.drawPanel.add((Component)this.dotsRadioButton, gridBagConstraints);
        this.drawbuttonGroup.add(this.imagesRadioButton);
        this.imagesRadioButton.setText("images");
        this.imagesRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.imagesRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.imagesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.imagesRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.drawPanel.add((Component)this.imagesRadioButton, gridBagConstraints);
        this.paremetersPanel.add((Component)this.drawPanel, new GridBagConstraints());
        this.titlefontSizeLabel.setText("Title's font size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.titlefontSizeLabel, gridBagConstraints);
        this.titlefontSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.titlefontSizeComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.titlefontSizeComboBox, gridBagConstraints);
        this.titlefontSizeLabel1.setText("Title's font size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.titlefontSizeLabel1, gridBagConstraints);
        this.titlefontSizeComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.titlefontSizeComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.titlefontSizeComboBox1, gridBagConstraints);
        this.vertexLabel.setText("Vertex Title");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.vertexLabel, gridBagConstraints);
        this.labelsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.labelsComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.labelsComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.adjustsPanel.add((Component)this.paremetersPanel, gridBagConstraints);
        this.generalPanel.setBorder(BorderFactory.createTitledBorder("General"));
        this.generalPanel.setLayout(new GridBagLayout());
        this.shownonvalidCheckBox.setText("Show intermediate vertex");
        this.shownonvalidCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.shownonvalidCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.shownonvalidCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.shownonvalidCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.generalPanel.add((Component)this.shownonvalidCheckBox, gridBagConstraints);
        this.showVertexLabel.setText("Show vertex label");
        this.showVertexLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showVertexLabel.setMargin(new Insets(0, 0, 0, 0));
        this.showVertexLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.showVertexLabelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.generalPanel.add((Component)this.showVertexLabel, gridBagConstraints);
        this.showEdgesCheckBox.setText("Show edges");
        this.showEdgesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showEdgesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.showEdgesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.showEdgesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.generalPanel.add((Component)this.showEdgesCheckBox, gridBagConstraints);
        this.showEdgesLabelsCheckBox.setText("Show edge's label");
        this.showEdgesLabelsCheckBox.setBorder(null);
        this.showEdgesLabelsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.showEdgesLabelsCheckBox.setMaximumSize(new Dimension(141, 15));
        this.showEdgesLabelsCheckBox.setMinimumSize(new Dimension(141, 15));
        this.showEdgesLabelsCheckBox.setPreferredSize(new Dimension(141, 15));
        this.showEdgesLabelsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.showEdgesLabelsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.generalPanel.add((Component)this.showEdgesLabelsCheckBox, gridBagConstraints);
        this.neighborhoodDepthLabel.setText("Neighborhood depth");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.generalPanel.add((Component)this.neighborhoodDepthLabel, gridBagConstraints);
        this.neighborhoodDepthComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.neighborhoodDepthComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.neighborhoodDepthComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.generalPanel.add((Component)this.neighborhoodDepthComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.adjustsPanel.add((Component)this.generalPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.adjustsPanel, "Center");
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.refreshButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.refreshButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void showEdgesCheckBoxActionPerformed(ActionEvent evt) {
        if (this.graph != null) {
            this.graph.setEdgeVisible(this.showEdgesCheckBox.isSelected());
            if (this.gv != null) {
                this.gv.updateImage();
            }
        }
    }

    private void titlefontSizeComboBoxActionPerformed(ActionEvent evt) {
        Vertex.setFont(new Font("Verdana", 1, Integer.parseInt((String)this.titlefontSizeComboBox.getSelectedItem())));
        if (this.gv != null) {
            this.gv.updateImage();
        }
    }

    private void dotsRadioButtonActionPerformed(ActionEvent evt) {
        for (Vertex v : this.graph.getVertex()) {
            if (!v.isValid()) continue;
            v.setDrawAs(1);
        }
        if (this.gv != null) {
            this.gv.updateImage();
        }
    }

    private void circlesRadioButtonActionPerformed(ActionEvent evt) {
        for (Vertex v : this.graph.getVertex()) {
            if (!v.isValid()) continue;
            v.setDrawAs(0);
        }
        if (this.gv != null) {
            this.gv.updateImage();
        }
    }

    private void poorRadioButtonActionPerformed(ActionEvent evt) {
        if (this.gv != null) {
            this.gv.setHighQualityRender(false);
            this.gv.updateImage();
        }
    }

    private void highRadioButtonActionPerformed(ActionEvent evt) {
        if (this.gv != null) {
            this.gv.setHighQualityRender(true);
            this.gv.updateImage();
        }
    }

    private void shownonvalidCheckBoxActionPerformed(ActionEvent evt) {
        Vertex.setShowNonValid(this.shownonvalidCheckBox.isSelected());
        if (this.gv != null) {
            this.gv.updateImage();
        }
    }

    private void settingsRulesButtonActionPerformed(ActionEvent evt) {
        if (this.graph != null) {
            TopicRuleTFSettings.getInstance(this).display(this.graph);
        }
    }

    private void rulesRadioButtonActionPerformed(ActionEvent evt) {
        if (this.graph != null) {
            this.graph.getTopicData().setTopicType(TopicData.TopicType.RULE);
        }
    }

    private void covarianceRadioButtonActionPerformed(ActionEvent evt) {
        if (this.graph != null) {
            this.graph.getTopicData().setTopicType(TopicData.TopicType.COVARIANCE);
        }
    }

    private void showVertexLabelActionPerformed(ActionEvent evt) {
        if (this.gv != null) {
            this.gv.setVertexLabelVisible(this.showVertexLabel.isSelected());
        }
    }

    private void labelfontSizeComboBoxActionPerformed(ActionEvent evt) {
        if (this.gv != null) {
            this.gv.setViewerFont(new Font("Verdana", 1, Integer.parseInt((String)this.labelfontSizeComboBox.getSelectedItem())));
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        if (this.gv != null) {
            this.gv.updateImage();
        }
        this.graph = null;
        this.gv = null;
        this.setVisible(false);
    }

    private void backGroundButtonActionPerformed(ActionEvent evt) {
        if (this.gv != null) {
            Color color = JColorChooser.showDialog(this, "Choose the Backgroud Color", Color.BLACK);
            this.gv.setViewerBackground(color);
            this.gv.updateImage();
        }
    }

    private void vertexRaySliderStateChanged(ChangeEvent evt) {
        JSlider slider = (JSlider)evt.getSource();
        for (Vertex v : this.graph.getVertex()) {
            if (!v.isValid()) continue;
            v.setRayBase(slider.getValue());
        }
        if (this.graph.getVertex().get(0).getDrawAs() == 2) {
            this.imagesRadioButtonActionPerformed(null);
        }
    }

    private void showEdgesLabelsCheckBoxActionPerformed(ActionEvent evt) {
        Edge.setShowLength(this.showEdgesLabelsCheckBox.isSelected());
        if (this.gv != null) {
            this.gv.updateImage();
        }
    }

    private void encodingsComboBoxActionPerformed(ActionEvent evt) {
        Encoding encoding = (Encoding)this.encodingsComboBox.getSelectedItem();
        if (encoding != null) {
            Corpus.setEncoding(encoding);
        }
    }

    private void neighborhoodDepthComboBoxActionPerformed(ActionEvent evt) {
        if (this.gv != null) {
            this.gv.setNeighborhoodDepth(this.neighborhoodDepthComboBox.getSelectedIndex() + 1);
        }
    }

    private void settingsCovarianceButtonActionPerformed(ActionEvent evt) {
        if (this.graph != null) {
            CovarianceTopicSettings.getInstance(this).display(this.graph);
        }
    }

    private void imagesRadioButtonActionPerformed(ActionEvent evt) {
        if (OpenDialog.checkImages(this.graph, this)) {
            for (Vertex v : this.graph.getVertex()) {
                if (!v.isValid()) continue;
                try {
                    Image im = this.graph.getImageCollection().getImage(v.getUrl());
                    v.setImage(im.getScaledInstance(v.getRay() * 5, v.getRay() * 5, 0));
                    v.setDrawAs(2);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        if (this.gv != null) {
            this.gv.updateImage();
        }
    }

    private void titlefontSizeComboBox1ActionPerformed(ActionEvent evt) {
    }

    private void labelsComboBoxActionPerformed(ActionEvent evt) {
        String label = (String)((JComboBox)evt.getSource()).getSelectedItem();
        if (label != null && this.gv != null) {
            this.gv.setShowVertexTitle(false);
            this.gv.setShowImages(false);
            this.gv.setShowVertexContent(false);
            if (label.equals("file name")) {
                this.gv.setShowVertexTitle(true);
            } else if (label.equals("content")) {
                if (OpenDialog.checkCorpus(this.graph, this)) {
                    this.gv.setShowVertexContent(true);
                }
            } else if (label.equals("images")) {
                if (OpenDialog.checkImages(this.gv.getGraph(), this)) {
                    this.gv.setShowImages(true);
                }
            } else {
                this.gv.setShowVertexTitle(false);
                this.gv.setShowImages(false);
                this.gv.setShowVertexContent(false);
            }
        }
    }

    public static ToolConfiguration getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new ToolConfiguration(parent);
        }
        return instance;
    }

    public void display(Viewer gv) {
        if (gv != null) {
            this.gv = gv;
            this.graph = gv.getGraph();
            this.labelfontSizeComboBox.setSelectedItem(Integer.toString(gv.getFont().getSize()));
            this.showVertexLabel.setSelected(gv.isVertexLabelVisible());
            if (gv.isHighQualityRender()) {
                this.highRadioButton.setSelected(true);
                this.poorRadioButton.setSelected(false);
            } else {
                this.highRadioButton.setSelected(false);
                this.poorRadioButton.setSelected(true);
            }
            this.covarianceRadioButton.setSelected(false);
            this.rulesRadioButton.setSelected(false);
            if (this.graph != null && this.graph.getTopicData().getTopicType() == TopicData.TopicType.RULE) {
                this.rulesRadioButton.setSelected(true);
            } else {
                this.covarianceRadioButton.setSelected(true);
            }
            if (this.graph != null) {
                this.showEdgesCheckBox.setSelected(this.graph.isEdgeVisible());
            }
            this.vertexRaySlider.setValue(this.graph.getVertex().get(0).getRayBase());
            this.neighborhoodDepthComboBox.setSelectedIndex(gv.getNeighborhoodDepth() - 1);
        } else {
            this.gv = null;
            this.graph = null;
        }
        this.titlefontSizeComboBox.setSelectedItem(Integer.toString(Vertex.getFont().getSize()));
        this.shownonvalidCheckBox.setSelected(Vertex.isShowNonValid());
        this.showEdgesLabelsCheckBox.setSelected(Edge.isShowLength());
        if (this.graph != null && this.graph.isCorpus()) {
            String selecItem = (String)this.labelsComboBox.getSelectedItem();
            this.labelsComboBox.removeAllItems();
            this.labelsComboBox.addItem("none");
            this.labelsComboBox.addItem("file name");
            this.labelsComboBox.addItem("content");
            this.labelsComboBox.setSelectedItem(selecItem);
            this.imagesRadioButton.setEnabled(false);
            this.covarianceRadioButton.setEnabled(true);
            this.rulesRadioButton.setEnabled(true);
            this.settingsCovarianceButton.setEnabled(true);
            this.settingsRulesButton.setEnabled(true);
            this.labelfontSizeLabel.setEnabled(true);
            this.labelfontSizeComboBox.setEnabled(true);
        } else {
            if (this.labelsComboBox.getSelectedItem() == "file name") {
                this.labelsComboBox.setSelectedItem("file name");
            } else if (this.labelsComboBox.getSelectedItem() == "images") {
                this.labelsComboBox.setSelectedItem("images");
            } else {
                this.labelsComboBox.removeAllItems();
                this.labelsComboBox.addItem("none");
                this.labelsComboBox.addItem("file name");
                this.labelsComboBox.addItem("images");
            }
            this.imagesRadioButton.setEnabled(true);
            this.covarianceRadioButton.setEnabled(false);
            this.rulesRadioButton.setEnabled(false);
            this.settingsCovarianceButton.setEnabled(false);
            this.settingsRulesButton.setEnabled(false);
            this.labelfontSizeLabel.setEnabled(false);
            this.labelfontSizeComboBox.setEnabled(false);
        }
        switch (this.graph.getVertex().get(0).getDrawAs()) {
            case 1: {
                this.circlesRadioButton.setSelected(false);
                this.dotsRadioButton.setSelected(true);
                this.imagesRadioButton.setSelected(false);
                break;
            }
            case 2: {
                this.circlesRadioButton.setSelected(false);
                this.dotsRadioButton.setSelected(false);
                this.imagesRadioButton.setSelected(true);
                break;
            }
            default: {
                this.circlesRadioButton.setSelected(true);
                this.dotsRadioButton.setSelected(false);
                this.imagesRadioButton.setSelected(false);
            }
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ToolConfiguration(null).setVisible(true);
            }
        });
    }
}

