/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import visualizer.util.OpenDialog;
import visualizer.util.SaveDialog;
import visualizer.util.TextFromPDF;
import visualizer.util.filefilter.DIRFilter;
import visualizer.util.filefilter.ZIPFilter;

public class CreatePDFCorpora
extends JDialog {
    private static CreatePDFCorpora instance;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton corporaButton;
    private JLabel corporaLabel;
    private JTextField corporaTextField;
    private JButton createButton;
    private JPanel dataPanel;
    private JButton directoryButton;
    private JLabel directoryLabel;
    private JTextField directoryTextField;
    private JLabel jLabel1;
    private JScrollPane statusScrollPane;
    private JTextArea statusTextArea;

    private CreatePDFCorpora(JFrame parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dataPanel = new JPanel();
        this.statusScrollPane = new JScrollPane();
        this.statusTextArea = new JTextArea();
        this.corporaLabel = new JLabel();
        this.directoryLabel = new JLabel();
        this.directoryTextField = new JTextField();
        this.corporaTextField = new JTextField();
        this.directoryButton = new JButton();
        this.corporaButton = new JButton();
        this.buttonPanel = new JPanel();
        this.createButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.setTitle("Create Corpus From PDF Files");
        this.setModal(true);
        this.setResizable(false);
        this.dataPanel.setLayout(new GridBagLayout());
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data for Creation"));
        this.statusScrollPane.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusTextArea.setColumns(20);
        this.statusTextArea.setEditable(false);
        this.statusTextArea.setRows(5);
        this.statusScrollPane.setViewportView(this.statusTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dataPanel.add((Component)this.statusScrollPane, gridBagConstraints);
        this.corporaLabel.setText("Corpus");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.corporaLabel, gridBagConstraints);
        this.directoryLabel.setText("Directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.directoryLabel, gridBagConstraints);
        this.directoryTextField.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.directoryTextField, gridBagConstraints);
        this.corporaTextField.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.corporaTextField, gridBagConstraints);
        this.directoryButton.setText("Search...");
        this.directoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreatePDFCorpora.this.directoryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.directoryButton, gridBagConstraints);
        this.corporaButton.setText("Search...");
        this.corporaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreatePDFCorpora.this.corporaButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.corporaButton, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.createButton.setText("Create");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreatePDFCorpora.this.createButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.createButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreatePDFCorpora.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        if (this.corporaTextField.getText().trim().length() > 0 && this.directoryTextField.getText().trim().length() > 0) {
            try {
                this.cancelButton.setEnabled(false);
                TextFromPDF extractor = new TextFromPDF();
                extractor.extract(this.statusTextArea, this.directoryTextField.getText(), this.corporaTextField.getText());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 2);
            }
            this.cancelButton.setEnabled(true);
        } else {
            JOptionPane.showMessageDialog(this, "The corpus and directory fields must be filled!", "Error", 2);
        }
    }

    private void corporaButtonActionPerformed(ActionEvent evt) {
        int result;
        String filename = "corpus.zip";
        if (this.directoryTextField.getText().trim().length() > 0) {
            filename = this.directoryTextField.getText();
            filename = filename.substring(filename.lastIndexOf("\\") + 1, filename.length()) + ".zip";
        }
        if ((result = SaveDialog.showSaveDialog(new ZIPFilter(), this, filename)) == 0) {
            filename = SaveDialog.getFilename();
            this.corporaTextField.setText(filename);
        }
    }

    private void directoryButtonActionPerformed(ActionEvent evt) {
        OpenDialog.getJFileChooser().setFileSelectionMode(1);
        int result = OpenDialog.showOpenDialog(new DIRFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.directoryTextField.setText(filename);
        }
        OpenDialog.getJFileChooser().setFileSelectionMode(0);
    }

    public static CreatePDFCorpora getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new CreatePDFCorpora(parent);
        }
        return instance;
    }

    public void display() {
        this.corporaTextField.setText("");
        this.directoryTextField.setText("");
        this.statusTextArea.setText("");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CreatePDFCorpora(null).setVisible(true);
            }
        });
    }
}

