/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.view.Viewer;

public class JoinScalars
extends JDialog {
    private Viewer view;
    private Graph graph;
    private ArrayList<Scalar> tojoin = new ArrayList();
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel framePanel;
    private JButton joinButton;

    private JoinScalars(Frame parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
    }

    private void initComponents() {
        this.framePanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.joinButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create Mappings");
        this.framePanel.setBorder(BorderFactory.createTitledBorder("Select Scalars"));
        this.framePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.framePanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.joinButton.setText("Join");
        this.joinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoinScalars.this.joinButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.joinButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoinScalars.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void joinButtonActionPerformed(ActionEvent evt) {
        Scalar scalar = this.graph.addScalar("joined");
        for (Vertex v : this.graph.getVertex()) {
            float max = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < this.tojoin.size(); ++i) {
                max = Math.max(max, v.getScalar(this.tojoin.get(i)));
            }
            v.setScalar(scalar, max);
        }
        this.view.updateScalars(scalar);
        this.view.updateImage();
        this.view.getProjectionExplorerView().repaint();
        this.setVisible(false);
    }

    public static JoinScalars getInstance(JFrame parent) {
        return new JoinScalars(parent);
    }

    public void display(Viewer view) {
        this.view = view;
        this.graph = view.getGraph();
        this.setScalars(this.graph);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void setScalars(Graph graph) {
        ArrayList<Scalar> scalars = graph.getScalars();
        for (int i = 0; i < scalars.size(); ++i) {
            if (scalars.get(i).getName().equals("topics") || scalars.get(i).getName().equals("cdata") || scalars.get(i).getName().equals("...") || scalars.get(i).getName().equals("joined") || scalars.get(i).getName().equals("pivots")) continue;
            JCheckBox check = new JCheckBox(scalars.get(i).toString());
            check.addActionListener(new CheckBoxListener(scalars.get(i)));
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 17;
            cons.gridx = 0;
            cons.gridy = i;
            this.framePanel.add((Component)check, cons);
        }
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JoinScalars((Frame)new JFrame()).setVisible(true);
            }
        });
    }

    class CheckBoxListener
    implements ActionListener {
        private Scalar scalar;

        public CheckBoxListener(Scalar scalar) {
            this.scalar = scalar;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JCheckBox) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    JoinScalars.this.tojoin.add(this.scalar);
                } else {
                    JoinScalars.this.tojoin.remove(this.scalar);
                }
            }
        }
    }
}

