/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.graph.Connectivity;
import visualizer.graph.Graph;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.MSTEdges;
import visualizer.util.OpenDialog;
import visualizer.util.Pair;
import visualizer.util.filefilter.DATAFilter;
import visualizer.util.filefilter.DMATFilter;

public class MSTConnectivity
extends JDialog {
    private static MSTConnectivity instance;
    private Connectivity connectivity;
    private Graph graph;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel chooseDistanceTypePanel2;
    private JPanel dataPanel;
    private JComboBox distanceComboBox;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    private JButton okButton;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private ButtonGroup sourceButtonGroup;
    private JPanel sourcePanel;

    private MSTConnectivity(JFrame parent) {
        super(parent);
        this.initComponents();
        for (DissimilarityType disstype : DissimilarityType.getTypes()) {
            if (disstype == DissimilarityType.KOLMOGOROV || disstype == DissimilarityType.NONE) continue;
            this.distanceComboBox.addItem(disstype);
        }
    }

    private void initComponents() {
        this.sourceButtonGroup = new ButtonGroup();
        this.dataPanel = new JPanel();
        this.sourcePanel = new JPanel();
        this.pointsRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.chooseDistanceTypePanel2 = new JPanel();
        this.distanceComboBox = new JComboBox();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Miminum Spanning Tree (MST)");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.sourceButtonGroup.add(this.pointsRadioButton);
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSTConnectivity.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.distanceMatrixRadioButton);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSTConnectivity.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        this.distanceMatrixTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSTConnectivity.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSTConnectivity.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.sourcePanel, gridBagConstraints);
        this.chooseDistanceTypePanel2.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel2.add((Component)this.distanceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.dataPanel.add((Component)this.chooseDistanceTypePanel2, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSTConnectivity.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MSTConnectivity.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.pointsRadioButton.isSelected()) {
                if (this.pointsTextField.getText().trim().length() > 0) {
                    Matrix matrix = MatrixFactory.getInstance(this.pointsTextField.getText());
                    ArrayList<String> names = matrix.getIds();
                    DissimilarityType mtype = (DissimilarityType)this.distanceComboBox.getSelectedItem();
                    Dissimilarity diss = DissimilarityFactory.getInstance(mtype);
                    this.connectivity = new Connectivity("MST (prim)");
                    MSTEdges mst = new MSTEdges(this.graph.getVertex(), names);
                    Pair[][] neighborhood = mst.execute(matrix, diss);
                    this.connectivity.create(this.graph.getVertex(), neighborhood);
                    this.graph.addConnectivity(this.connectivity);
                } else {
                    JOptionPane.showMessageDialog(this, "The points file must be provided!", "WARNING", 2);
                }
            } else if (this.distanceMatrixRadioButton.isSelected()) {
                if (this.distanceMatrixTextField.getText().trim().length() > 0) {
                    DistanceMatrix dmat = new DistanceMatrix(this.distanceMatrixTextField.getText());
                    ArrayList<String> names = dmat.getIds();
                    this.connectivity = new Connectivity("MST (prim)");
                    MSTEdges mst = new MSTEdges(this.graph.getVertex(), names);
                    Pair[][] neighborhood = mst.execute(dmat);
                    this.connectivity.create(this.graph.getVertex(), neighborhood);
                    this.graph.addConnectivity(this.connectivity);
                } else {
                    JOptionPane.showMessageDialog(this, "The distance matrix file must be provided!", "WARNING", 2);
                }
            }
            this.setVisible(false);
        }
        catch (IOException ex) {
            Logger.getLogger(MSTConnectivity.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.distanceMatrixTextField.setText("");
        this.distanceComboBox.setEnabled(true);
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.distanceComboBox.setEnabled(false);
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.pointsTextField.setText(filename);
        }
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DMATFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.distanceMatrixTextField.setText(filename);
        }
    }

    public static MSTConnectivity getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new MSTConnectivity(parent);
        }
        return instance;
    }

    public Connectivity display(Graph graph) {
        this.graph = graph;
        this.connectivity = null;
        this.distanceMatrixTextField.setText("");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.connectivity;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MSTConnectivity dialog = new MSTConnectivity(new JFrame());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

