/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;

public class RuleCoverOptions
extends JDialog {
    private static RuleCoverOptions instance;
    private JRadioButton clusterRadioButton;
    private JSpinner incSpinner;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel mainPanel;
    private JSpinner maxSpinner;
    private JSpinner minSpinner;
    private JRadioButton moveRadioButton;
    private JSpinner moveSliceSpinner;
    private JButton okButton;
    private JRadioButton resizeRadioButton;
    private JSpinner sliceMaxSpinner;
    private JSpinner sliceMinSpinner;
    private JSpinner subSlicesSpinner;
    private JRadioButton topicRadioButton;

    public RuleCoverOptions(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.resizeRadioButton = new JRadioButton();
        this.moveRadioButton = new JRadioButton();
        this.clusterRadioButton = new JRadioButton();
        this.topicRadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.minSpinner = new JSpinner();
        this.maxSpinner = new JSpinner();
        this.incSpinner = new JSpinner();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.sliceMinSpinner = new JSpinner();
        this.sliceMaxSpinner = new JSpinner();
        this.jPanel4 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.moveSliceSpinner = new JSpinner();
        this.subSlicesSpinner = new JSpinner();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.mainPanel.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Cover Strategy"));
        this.resizeRadioButton.setText("Resize");
        this.resizeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.resizeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel1.add(this.resizeRadioButton);
        this.moveRadioButton.setText("Move");
        this.moveRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.moveRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleCoverOptions.this.moveRadioButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.moveRadioButton);
        this.clusterRadioButton.setText("Cluster");
        this.clusterRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clusterRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel1.add(this.clusterRadioButton);
        this.topicRadioButton.setText("Class (\"TOPIC\" scalar)");
        this.topicRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.topicRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel1.add(this.topicRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 12;
        this.mainPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Cluster Options"));
        this.jPanel2.setLayout(new GridLayout(2, 0));
        this.jLabel1.setText("Minimum");
        this.jPanel2.add(this.jLabel1);
        this.jLabel2.setText("Maximum");
        this.jPanel2.add(this.jLabel2);
        this.jLabel3.setText("Increment");
        this.jPanel2.add(this.jLabel3);
        this.minSpinner.setToolTipText("Minimum");
        this.jPanel2.add(this.minSpinner);
        this.maxSpinner.setToolTipText("Maximun");
        this.jPanel2.add(this.maxSpinner);
        this.incSpinner.setToolTipText("Increment");
        this.jPanel2.add(this.incSpinner);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Resize Options"));
        this.jPanel3.setLayout(new GridLayout(2, 0));
        this.jLabel4.setText("Minimum");
        this.jPanel3.add(this.jLabel4);
        this.jLabel5.setText("Maximum");
        this.jPanel3.add(this.jLabel5);
        this.sliceMinSpinner.setToolTipText("Initial");
        this.jPanel3.add(this.sliceMinSpinner);
        this.sliceMaxSpinner.setToolTipText("Final");
        this.jPanel3.add(this.sliceMaxSpinner);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Move Options"));
        this.jPanel4.setLayout(new GridLayout(2, 0));
        this.jLabel6.setText("Slices");
        this.jPanel4.add(this.jLabel6);
        this.jLabel7.setText("Move Slices");
        this.jPanel4.add(this.jLabel7);
        this.moveSliceSpinner.setToolTipText("Slices");
        this.jPanel4.add(this.moveSliceSpinner);
        this.subSlicesSpinner.setToolTipText("SubSlices");
        this.jPanel4.add(this.subSlicesSpinner);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)this.jPanel4, gridBagConstraints);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleCoverOptions.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.okButton, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void moveRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static RuleCoverOptions getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new RuleCoverOptions((Frame)parent, true);
        }
        return instance;
    }

    public RuleCoverOptions display() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this;
    }

    public StrategyType getStrategy() {
        if (this.resizeRadioButton.isSelected()) {
            return StrategyType.RESIZE_ST;
        }
        if (this.moveRadioButton.isSelected()) {
            return StrategyType.MOVE_ST;
        }
        if (this.topicRadioButton.isSelected()) {
            return StrategyType.TOPIC_ST;
        }
        return StrategyType.CLUSTER_ST;
    }

    private int spinInt(JSpinner spin) {
        return new Double(((JSpinner.DefaultEditor)spin.getEditor()).getTextField().getText()).intValue();
    }

    public int getMin() {
        if (this.resizeRadioButton.isSelected()) {
            return this.spinInt(this.sliceMinSpinner);
        }
        return this.spinInt(this.minSpinner);
    }

    public int getMax() {
        if (this.resizeRadioButton.isSelected()) {
            return this.spinInt(this.sliceMaxSpinner);
        }
        return this.spinInt(this.maxSpinner);
    }

    public int getInc() {
        return this.spinInt(this.incSpinner);
    }

    public int getSlices() {
        return this.spinInt(this.moveSliceSpinner);
    }

    public int getSubSlices() {
        return this.spinInt(this.subSlicesSpinner);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RuleCoverOptions dialog = new RuleCoverOptions((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public static enum StrategyType {
        CLUSTER_ST,
        RESIZE_ST,
        MOVE_ST,
        TOPIC_ST;

    }
}

