/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.graph.Connectivity;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.OpenDialog;
import visualizer.util.Pair;
import visualizer.util.ScalarNeighbors;
import visualizer.util.filefilter.DATAFilter;
import visualizer.util.filefilter.DMATFilter;

public class ScalarConnectivity
extends JDialog {
    private static ScalarConnectivity instance;
    private Connectivity connectivity;
    private Graph graph;
    private Scalar currentScalar;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel chooseDistanceTypePanel2;
    private JPanel dataPanel;
    private JComboBox distanceComboBox;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    private JLabel inuseLabel;
    private JCheckBox knnCheckBox;
    private JComboBox knnConnectivityComboBox;
    private JLabel knnConnectivityLabel;
    private JPanel knnPanel;
    private JComboBox nameComboBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel numberNeighborsPanel;
    private JButton okButton;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private ButtonGroup sourceButtonGroup;
    private JPanel sourcePanel;

    private ScalarConnectivity(JFrame parent) {
        super(parent);
        this.initComponents();
        for (DissimilarityType disstype : DissimilarityType.getTypes()) {
            if (disstype == DissimilarityType.KOLMOGOROV || disstype == DissimilarityType.NONE) continue;
            this.distanceComboBox.addItem(disstype);
        }
    }

    private void initComponents() {
        this.sourceButtonGroup = new ButtonGroup();
        this.dataPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.nameComboBox = new JComboBox();
        this.inuseLabel = new JLabel();
        this.knnCheckBox = new JCheckBox();
        this.knnPanel = new JPanel();
        this.sourcePanel = new JPanel();
        this.pointsRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.chooseDistanceTypePanel2 = new JPanel();
        this.distanceComboBox = new JComboBox();
        this.numberNeighborsPanel = new JPanel();
        this.knnConnectivityLabel = new JLabel();
        this.knnConnectivityComboBox = new JComboBox();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create Scalar Connectivity");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Scalar Connectivity Parameters"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.nameLabel.setText("Connectivity Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.dataPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.dataPanel.add((Component)this.nameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.dataPanel.add((Component)this.nameComboBox, gridBagConstraints);
        this.inuseLabel.setText("In use");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.dataPanel.add((Component)this.inuseLabel, gridBagConstraints);
        this.knnCheckBox.setText("Use KNN Connectivity");
        this.knnCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScalarConnectivity.this.knnCheckBoxActionPerformed(evt);
            }
        });
        this.dataPanel.add((Component)this.knnCheckBox, new GridBagConstraints());
        this.knnPanel.setBorder(BorderFactory.createTitledBorder("KNN Options"));
        this.knnPanel.setEnabled(false);
        this.knnPanel.setLayout(new GridBagLayout());
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel.setEnabled(false);
        this.sourcePanel.setLayout(new GridBagLayout());
        this.sourceButtonGroup.add(this.pointsRadioButton);
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.setEnabled(false);
        this.pointsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScalarConnectivity.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.distanceMatrixRadioButton);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.setEnabled(false);
        this.distanceMatrixRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScalarConnectivity.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        this.distanceMatrixTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        this.pointsTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.setEnabled(false);
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScalarConnectivity.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScalarConnectivity.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.knnPanel.add((Component)this.sourcePanel, gridBagConstraints);
        this.chooseDistanceTypePanel2.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel2.setEnabled(false);
        this.chooseDistanceTypePanel2.setLayout(new GridBagLayout());
        this.distanceComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel2.add((Component)this.distanceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.knnPanel.add((Component)this.chooseDistanceTypePanel2, gridBagConstraints);
        this.numberNeighborsPanel.setLayout(new GridBagLayout());
        this.knnConnectivityLabel.setText("Number Neighbors");
        this.knnConnectivityLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.numberNeighborsPanel.add((Component)this.knnConnectivityLabel, gridBagConstraints);
        this.knnConnectivityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}));
        this.knnConnectivityComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.numberNeighborsPanel.add((Component)this.knnConnectivityComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 4, 0);
        this.knnPanel.add((Component)this.numberNeighborsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.dataPanel.add((Component)this.knnPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("Create");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScalarConnectivity.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScalarConnectivity.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.knnCheckBox.isSelected()) {
            if (this.pointsRadioButton.isSelected()) {
                if (this.pointsTextField.getText().trim().length() > 0) {
                    try {
                        Matrix matrix = MatrixFactory.getInstance(this.pointsTextField.getText());
                        DissimilarityType mtype = (DissimilarityType)this.distanceComboBox.getSelectedItem();
                        Dissimilarity diss = DissimilarityFactory.getInstance(mtype);
                        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
                        int numberNeighbors = this.knnConnectivityComboBox.getSelectedIndex() + 1;
                        String conname = this.nameTextField.getText();
                        this.connectivity = new Connectivity(conname);
                        ScalarNeighbors sn = new ScalarNeighbors(this.graph.getVertex(), this.currentScalar, numberNeighbors);
                        Pair[][] neighborhood = sn.execute(dmat);
                        this.connectivity.create(this.graph.getVertex(), neighborhood);
                        this.graph.addConnectivity(this.connectivity);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ScalarConnectivity.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The DISTANCE MATRIX file must be provided!", "WARNING", 2);
                }
            } else if (this.distanceMatrixTextField.getText().trim().length() > 0) {
                try {
                    DistanceMatrix dmat = new DistanceMatrix(this.distanceMatrixTextField.getText());
                    int numberNeighbors = this.knnConnectivityComboBox.getSelectedIndex() + 1;
                    String conname = this.nameTextField.getText();
                    this.connectivity = new Connectivity(conname);
                    ScalarNeighbors sn = new ScalarNeighbors(this.graph.getVertex(), this.currentScalar, numberNeighbors);
                    Pair[][] neighborhood = sn.execute(dmat);
                    this.connectivity.create(this.graph.getVertex(), neighborhood);
                    this.graph.addConnectivity(this.connectivity);
                }
                catch (IOException ex) {
                    Logger.getLogger(ScalarConnectivity.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                JOptionPane.showMessageDialog(this, "The DISTANCE MATRIX file must be provided!", "WARNING", 2);
            }
        } else {
            try {
                String conname = this.nameTextField.getText();
                this.connectivity = new Connectivity(conname);
                ScalarNeighbors sn = new ScalarNeighbors(this.graph.getVertex(), this.currentScalar, 0);
                Pair[][] neighborhood = sn.execute();
                this.connectivity.create(this.graph.getVertex(), neighborhood);
                this.graph.addConnectivity(this.connectivity);
            }
            catch (IOException ex) {
                Logger.getLogger(ScalarConnectivity.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void knnCheckBoxActionPerformed(ActionEvent evt) {
        if (this.knnCheckBox.isSelected()) {
            this.knnConnectivityLabel.setEnabled(true);
            this.knnConnectivityComboBox.setEnabled(true);
            if (this.pointsRadioButton.isSelected()) {
                this.pointsRadioButton.setEnabled(true);
                this.pointsTextField.setEnabled(true);
                this.pointsButton.setEnabled(true);
                this.distanceMatrixRadioButton.setEnabled(true);
                this.distanceMatrixTextField.setEnabled(false);
                this.distanceMatrixButton.setEnabled(false);
                this.distanceComboBox.setEnabled(true);
            } else {
                this.pointsRadioButton.setEnabled(true);
                this.pointsTextField.setEnabled(false);
                this.pointsButton.setEnabled(false);
                this.distanceMatrixRadioButton.setEnabled(true);
                this.distanceMatrixTextField.setEnabled(true);
                this.distanceMatrixButton.setEnabled(true);
                this.distanceComboBox.setEnabled(false);
            }
        } else {
            this.pointsRadioButton.setEnabled(false);
            this.pointsTextField.setEnabled(false);
            this.pointsButton.setEnabled(false);
            this.distanceMatrixRadioButton.setEnabled(false);
            this.distanceMatrixTextField.setEnabled(false);
            this.distanceMatrixButton.setEnabled(false);
            this.distanceComboBox.setEnabled(false);
            this.knnConnectivityLabel.setEnabled(false);
            this.knnConnectivityComboBox.setEnabled(false);
        }
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.distanceMatrixTextField.setText("");
        this.distanceComboBox.setEnabled(true);
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.distanceComboBox.setEnabled(false);
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.pointsTextField.setText(filename);
        }
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DMATFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.distanceMatrixTextField.setText(filename);
        }
    }

    public static ScalarConnectivity getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new ScalarConnectivity(parent);
        }
        return instance;
    }

    public Connectivity display(Graph graph, Scalar currentScalar) {
        this.graph = graph;
        this.currentScalar = currentScalar;
        this.connectivity = null;
        this.knnCheckBox.setSelected(false);
        this.pointsRadioButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsButton.setEnabled(false);
        this.distanceMatrixRadioButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.distanceMatrixButton.setEnabled(false);
        this.distanceComboBox.setEnabled(false);
        this.knnConnectivityLabel.setEnabled(false);
        this.knnConnectivityComboBox.setEnabled(false);
        this.knnConnectivityComboBox.setSelectedIndex(0);
        String dmatFileName = this.graph.getProjectionData().getSourceFile().substring(0, this.graph.getProjectionData().getSourceFile().length() - 4) + ".dmat";
        if (new File(dmatFileName).exists()) {
            this.distanceMatrixTextField.setText(dmatFileName);
        } else {
            this.distanceMatrixTextField.setText("");
        }
        this.nameComboBox.removeAllItems();
        for (Connectivity con : this.graph.getConnectivities()) {
            this.nameComboBox.addItem(con.getName());
        }
        String conname = "Scalars: " + currentScalar.getName();
        this.nameTextField.setText(conname);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.connectivity;
    }
}

