/*
 * Decompiled with CFR 0.152.
 */
package visualizer.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.google.GoogleSearchManager;
import visualizer.google.GoogleView;
import visualizer.projection.ProjectionData;
import visualizer.projection.SourceType;
import visualizer.util.OpenDialog;
import visualizer.util.filefilter.DATAFilter;
import visualizer.util.filefilter.DMATFilter;
import visualizer.util.filefilter.TITLEFilter;
import visualizer.util.filefilter.ZIPFilter;
import visualizer.view.JExtendedComboBox;
import visualizer.wizard.ProjectionWizardView;
import visualizer.wizard.WizardPanel;

public class DataSourceChoice
extends WizardPanel {
    private ProjectionData projectionData;
    private JButton corporaButton;
    private JRadioButton corporaRadioButton;
    private JTextField corporaTextField;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    private JButton googleButton;
    private JComboBox googleComboBox;
    private JRadioButton googleRadioButton;
    private JButton imagesButton;
    private JRadioButton imagesRadioButton;
    private JTextField imagesTextField;
    private JButton pointsButton;
    private ButtonGroup pointsLabelButtonGroup;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private ButtonGroup sourceButtonGroup;
    private JButton titlesButton;
    private JLabel titlesLabel;
    private JTextField titlesTextField;

    public DataSourceChoice(ProjectionData projectionData) {
        this.projectionData = projectionData;
        this.initComponents();
        this.imagesRadioButtonActionPerformed(null);
    }

    private void initComponents() {
        this.sourceButtonGroup = new ButtonGroup();
        this.pointsLabelButtonGroup = new ButtonGroup();
        this.corporaRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.pointsRadioButton = new JRadioButton();
        this.corporaTextField = new JTextField();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.corporaButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.pointsButton = new JButton();
        this.titlesLabel = new JLabel();
        this.titlesTextField = new JTextField();
        this.titlesButton = new JButton();
        this.googleRadioButton = new JRadioButton();
        this.googleButton = new JButton();
        this.googleComboBox = new JExtendedComboBox();
        this.imagesTextField = new JTextField();
        this.imagesButton = new JButton();
        this.imagesRadioButton = new JRadioButton();
        this.setBorder(BorderFactory.createTitledBorder("Choose the Data Source"));
        this.setLayout(new GridBagLayout());
        this.sourceButtonGroup.add(this.corporaRadioButton);
        this.corporaRadioButton.setText("Documents");
        this.corporaRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.corporaRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.corporaRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.corporaRadioButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.corporaRadioButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.distanceMatrixRadioButton);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.pointsRadioButton);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.corporaTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.corporaTextField, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pointsTextField, gridBagConstraints);
        this.corporaButton.setText("Search...");
        this.corporaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.corporaButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.corporaButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.distanceMatrixButton, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pointsButton, gridBagConstraints);
        this.titlesLabel.setText("Titles File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.add((Component)this.titlesLabel, gridBagConstraints);
        this.titlesTextField.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.add((Component)this.titlesTextField, gridBagConstraints);
        this.titlesButton.setText("Search...");
        this.titlesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.titlesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.add((Component)this.titlesButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.googleRadioButton);
        this.googleRadioButton.setText("Google");
        this.googleRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.googleRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.googleRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.googleRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.googleRadioButton, gridBagConstraints);
        this.googleButton.setText("New Query");
        this.googleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.googleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.googleButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.googleComboBox, gridBagConstraints);
        this.imagesTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.imagesTextField, gridBagConstraints);
        this.imagesButton.setText("Search...");
        this.imagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.imagesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.imagesButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.imagesRadioButton);
        this.imagesRadioButton.setSelected(true);
        this.imagesRadioButton.setText("Images");
        this.imagesRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.imagesRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.imagesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceChoice.this.imagesRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.imagesRadioButton, gridBagConstraints);
    }

    private void googleRadioButtonActionPerformed(ActionEvent evt) {
        this.corporaButton.setEnabled(false);
        this.corporaTextField.setEnabled(false);
        this.imagesButton.setEnabled(false);
        this.imagesTextField.setEnabled(false);
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.titlesButton.setEnabled(false);
        this.titlesTextField.setEnabled(false);
        this.corporaTextField.setText("");
        this.pointsTextField.setText("");
        this.distanceMatrixTextField.setText("");
        this.titlesTextField.setText("");
        this.imagesTextField.setText("");
        this.googleButton.setEnabled(true);
        this.googleComboBox.setEnabled(true);
        this.googleComboBox.setSelectedIndex(0);
    }

    private void googleButtonActionPerformed(ActionEvent evt) {
        ProjectionWizardView view = (ProjectionWizardView)this.getTopLevelAncestor();
        GoogleView.getInstance(view).display(this);
    }

    private void titlesButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new TITLEFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.titlesTextField.setText(filename);
        }
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.pointsTextField.setText(filename);
            this.autoFill(OpenDialog.getJFileChooser());
        }
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DMATFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.distanceMatrixTextField.setText(filename);
            this.autoFill(OpenDialog.getJFileChooser());
        }
    }

    private void corporaButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new ZIPFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.corporaTextField.setText(filename);
        }
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.corporaButton.setEnabled(false);
        this.corporaTextField.setEnabled(false);
        this.imagesButton.setEnabled(false);
        this.imagesTextField.setEnabled(false);
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.titlesButton.setEnabled(true);
        this.titlesTextField.setEnabled(true);
        this.googleButton.setEnabled(false);
        this.googleComboBox.setEnabled(false);
        this.corporaTextField.setText("");
        this.distanceMatrixTextField.setText("");
        this.titlesTextField.setText("");
        this.imagesTextField.setText("");
        this.projectionData.setSourceType(SourceType.POINTS);
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.corporaButton.setEnabled(false);
        this.corporaTextField.setEnabled(false);
        this.imagesButton.setEnabled(false);
        this.imagesTextField.setEnabled(false);
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.titlesButton.setEnabled(true);
        this.titlesTextField.setEnabled(true);
        this.googleButton.setEnabled(false);
        this.googleComboBox.setEnabled(false);
        this.corporaTextField.setText("");
        this.pointsTextField.setText("");
        this.titlesTextField.setText("");
        this.imagesTextField.setText("");
        this.projectionData.setSourceType(SourceType.DISTANCE_MATRIX);
    }

    private void corporaRadioButtonActionPerformed(ActionEvent evt) {
        this.corporaButton.setEnabled(true);
        this.corporaTextField.setEnabled(true);
        this.imagesButton.setEnabled(false);
        this.imagesTextField.setEnabled(false);
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.titlesButton.setEnabled(false);
        this.titlesTextField.setEnabled(false);
        this.googleButton.setEnabled(false);
        this.googleComboBox.setEnabled(false);
        this.pointsTextField.setText("");
        this.distanceMatrixTextField.setText("");
        this.titlesTextField.setText("");
        this.imagesTextField.setText("");
        this.projectionData.setSourceType(SourceType.CORPUS);
    }

    private void imagesButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new ZIPFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.imagesTextField.setText(filename);
        }
    }

    private void imagesRadioButtonActionPerformed(ActionEvent evt) {
        this.corporaButton.setEnabled(false);
        this.corporaTextField.setEnabled(false);
        this.imagesButton.setEnabled(true);
        this.imagesTextField.setEnabled(true);
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.titlesButton.setEnabled(false);
        this.titlesTextField.setEnabled(false);
        this.googleButton.setEnabled(false);
        this.googleComboBox.setEnabled(false);
        this.pointsTextField.setText("");
        this.distanceMatrixTextField.setText("");
        this.titlesTextField.setText("");
        this.imagesTextField.setText("");
        this.projectionData.setSourceType(SourceType.IMAGES);
    }

    public DataSourceChoice reset() {
        GoogleSearchManager manager = GoogleSearchManager.getInstance();
        Object[] queries = manager.getQueries();
        Arrays.sort(queries);
        this.googleComboBox.removeAllItems();
        for (Object query : queries) {
            this.googleComboBox.addItem(query);
        }
        return this;
    }

    @Override
    public void refreshData() {
        if (this.corporaRadioButton.isSelected()) {
            this.projectionData.setSourceFile(this.corporaTextField.getText());
        } else if (this.imagesRadioButton.isSelected()) {
            this.projectionData.setSourceFile(this.imagesTextField.getText());
        } else if (this.pointsRadioButton.isSelected()) {
            this.projectionData.setSourceFile(this.pointsTextField.getText());
            this.projectionData.setTitlesFile(this.titlesTextField.getText());
        } else if (this.distanceMatrixRadioButton.isSelected()) {
            this.projectionData.setSourceFile(this.distanceMatrixTextField.getText());
            this.projectionData.setTitlesFile(this.titlesTextField.getText());
        } else if (this.googleRadioButton.isSelected()) {
            GoogleSearchManager manager = GoogleSearchManager.getInstance();
            String query = (String)this.googleComboBox.getSelectedItem();
            if (query != null) {
                this.projectionData.setSourceFile(manager.getCorpus(query));
            }
            this.projectionData.setNumberLines(1);
        }
    }

    private void autoFill(JFileChooser file) {
        File[] files;
        String filename = file.getSelectedFile().getName();
        String titlefile = filename.substring(0, filename.lastIndexOf(46)) + ".titles";
        String namesfileName = filename.substring(0, filename.lastIndexOf(46)) + ".names";
        for (File f : files = file.getCurrentDirectory().listFiles()) {
            if (titlefile.equals(f.getName())) {
                this.titlesTextField.setText(f.getAbsolutePath());
                continue;
            }
            if (!namesfileName.equals(f.getName())) continue;
        }
    }
}

