/*
 * Decompiled with CFR 0.152.
 */
package visualizer.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visualizer.dimensionreduction.DimensionalityReductionType;
import visualizer.matrix.normalization.NormalizationType;
import visualizer.projection.ProjectionData;
import visualizer.util.SaveDialog;
import visualizer.util.filefilter.DATAFilter;
import visualizer.wizard.WizardPanel;

public class DimensionReduction
extends WizardPanel {
    private ProjectionData pdata;
    private JComboBox dimensionalityReductionComboBox;
    private JLabel dimensionsLabel;
    private JTextField dimensionsTextField;
    private JPanel normalPanel;
    private JComboBox normalizationComboBox;
    private JPanel parametersPanel;
    private JCheckBox saveDocumetsTermsMatrixCheckBox;

    public DimensionReduction(ProjectionData projectionData) {
        this.pdata = projectionData;
        this.initComponents();
        for (NormalizationType nt : NormalizationType.getTypes()) {
            this.normalizationComboBox.addItem(nt);
        }
        for (DimensionalityReductionType drt : DimensionalityReductionType.getTypes()) {
            this.dimensionalityReductionComboBox.addItem(drt);
        }
    }

    private void initComponents() {
        this.parametersPanel = new JPanel();
        this.dimensionsTextField = new JTextField();
        this.dimensionsLabel = new JLabel();
        this.dimensionalityReductionComboBox = new JComboBox();
        this.normalPanel = new JPanel();
        this.normalizationComboBox = new JComboBox();
        this.saveDocumetsTermsMatrixCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Dimensionality Reduction"));
        this.setLayout(new GridBagLayout());
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("Dimensionality reduction technique"));
        this.parametersPanel.setLayout(new GridBagLayout());
        this.dimensionsTextField.setColumns(5);
        this.dimensionsTextField.setText("15");
        this.dimensionsTextField.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.dimensionsTextField, gridBagConstraints);
        this.dimensionsLabel.setText("dimensions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.dimensionsLabel, gridBagConstraints);
        this.dimensionalityReductionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionReduction.this.dimensionalityReductionComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.dimensionalityReductionComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.parametersPanel, gridBagConstraints);
        this.normalPanel.setBorder(BorderFactory.createTitledBorder("Normalization"));
        this.normalPanel.add(this.normalizationComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.normalPanel, gridBagConstraints);
        this.saveDocumetsTermsMatrixCheckBox.setText("Save documents x terms matrix");
        this.saveDocumetsTermsMatrixCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveDocumetsTermsMatrixCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.saveDocumetsTermsMatrixCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionReduction.this.saveDocumetsTermsMatrixCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.saveDocumetsTermsMatrixCheckBox, gridBagConstraints);
    }

    private void dimensionalityReductionComboBoxActionPerformed(ActionEvent evt) {
        DimensionalityReductionType drt = (DimensionalityReductionType)this.dimensionalityReductionComboBox.getSelectedItem();
        if (drt != DimensionalityReductionType.NONE) {
            this.dimensionsTextField.setEnabled(true);
        } else {
            this.dimensionsTextField.setEnabled(false);
        }
    }

    private void saveDocumetsTermsMatrixCheckBoxActionPerformed(ActionEvent evt) {
        if (this.saveDocumetsTermsMatrixCheckBox.isSelected()) {
            String filename = this.pdata.getSourceFile();
            int result = SaveDialog.showSaveDialog(new DATAFilter(), this, filename);
            if (result == 0) {
                filename = SaveDialog.getFilename();
                this.pdata.setDocsTermsFilename(filename);
            } else {
                this.saveDocumetsTermsMatrixCheckBox.setSelected(false);
            }
        } else {
            this.pdata.setDocsTermsFilename("");
        }
    }

    public DimensionReduction reset() {
        this.dimensionalityReductionComboBox.setSelectedItem(DimensionalityReductionType.NONE);
        this.dimensionsTextField.setEnabled(false);
        this.normalizationComboBox.setSelectedItem(NormalizationType.NONE);
        return this;
    }

    @Override
    public void refreshData() {
        DimensionalityReductionType drt = (DimensionalityReductionType)this.dimensionalityReductionComboBox.getSelectedItem();
        this.pdata.setDimensionReductionType(drt);
        if (drt != DimensionalityReductionType.NONE) {
            this.pdata.setTargetDimension(Integer.parseInt(this.dimensionsTextField.getText()));
        } else {
            this.pdata.setTargetDimension(0);
        }
        this.pdata.setNormalization((NormalizationType)this.normalizationComboBox.getSelectedItem());
    }
}

