/*
 * Decompiled with CFR 0.152.
 */
package visualizer.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import visualizer.datamining.clustering.HierarchicalClusteringType;
import visualizer.projection.ProjectionData;
import visualizer.projection.SourceType;
import visualizer.wizard.WizardPanel;

public class GeneralParameters
extends WizardPanel {
    private ProjectionData pdata;
    private JRadioButton alinkRadioButton;
    private JRadioButton clinkRadioButton;
    private JCheckBox delaunayCheckBox;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private ButtonGroup hcTypeButtonGroup;
    private JCheckBox hierarchicalClusteringCheckBox;
    private JPanel hierarchicalClusteringPanel;
    private JComboBox knnConnectivityComboBox;
    private JLabel knnConnectivityLabel;
    private JPanel knnConnectivityPanel;
    private JLabel linesFileLabel;
    private JComboBox numberLinesComboBox;
    private JPanel pointsLabelPanel;
    private JRadioButton slinkRadioButton;
    private JPanel triangulationPanel;

    public GeneralParameters(ProjectionData projectionData) {
        this.pdata = projectionData;
        this.initComponents();
    }

    private void initComponents() {
        this.hcTypeButtonGroup = new ButtonGroup();
        this.knnConnectivityPanel = new JPanel();
        this.knnConnectivityLabel = new JLabel();
        this.knnConnectivityComboBox = new JComboBox();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.hierarchicalClusteringPanel = new JPanel();
        this.slinkRadioButton = new JRadioButton();
        this.alinkRadioButton = new JRadioButton();
        this.hierarchicalClusteringCheckBox = new JCheckBox();
        this.clinkRadioButton = new JRadioButton();
        this.pointsLabelPanel = new JPanel();
        this.numberLinesComboBox = new JComboBox();
        this.linesFileLabel = new JLabel();
        this.triangulationPanel = new JPanel();
        this.delaunayCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("General Parameters"));
        this.setLayout(new GridBagLayout());
        this.knnConnectivityPanel.setBorder(BorderFactory.createTitledBorder("KNN Connectivity"));
        this.knnConnectivityPanel.setLayout(new GridBagLayout());
        this.knnConnectivityLabel.setText("Number Neighbors");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.knnConnectivityPanel.add((Component)this.knnConnectivityLabel, gridBagConstraints);
        this.knnConnectivityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.knnConnectivityPanel.add((Component)this.knnConnectivityComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.knnConnectivityPanel, gridBagConstraints);
        this.descriptionPanel.setBorder(BorderFactory.createTitledBorder("Projection Description"));
        this.descriptionPanel.setMinimumSize(new Dimension(200, 150));
        this.descriptionPanel.setLayout(new BorderLayout());
        this.descriptionScrollPane.setMinimumSize(new Dimension(150, 150));
        this.descriptionTextArea.setColumns(40);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setRows(10);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        this.descriptionPanel.add((Component)this.descriptionScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.descriptionPanel, gridBagConstraints);
        this.hierarchicalClusteringPanel.setBorder(BorderFactory.createTitledBorder("Hierarchical Clustering"));
        this.hierarchicalClusteringPanel.setLayout(new GridBagLayout());
        this.hcTypeButtonGroup.add(this.slinkRadioButton);
        this.slinkRadioButton.setText("SLINK");
        this.slinkRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.slinkRadioButton.setEnabled(false);
        this.slinkRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 25, 3, 3);
        this.hierarchicalClusteringPanel.add((Component)this.slinkRadioButton, gridBagConstraints);
        this.hcTypeButtonGroup.add(this.alinkRadioButton);
        this.alinkRadioButton.setText("ALINK");
        this.alinkRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.alinkRadioButton.setEnabled(false);
        this.alinkRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 25, 3, 3);
        this.hierarchicalClusteringPanel.add((Component)this.alinkRadioButton, gridBagConstraints);
        this.hierarchicalClusteringCheckBox.setText("Create the Hierarchical Clustering scalar");
        this.hierarchicalClusteringCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.hierarchicalClusteringCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.hierarchicalClusteringCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralParameters.this.hierarchicalClusteringCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.hierarchicalClusteringPanel.add((Component)this.hierarchicalClusteringCheckBox, gridBagConstraints);
        this.hcTypeButtonGroup.add(this.clinkRadioButton);
        this.clinkRadioButton.setSelected(true);
        this.clinkRadioButton.setText("CLINK");
        this.clinkRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clinkRadioButton.setEnabled(false);
        this.clinkRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 25, 3, 3);
        this.hierarchicalClusteringPanel.add((Component)this.clinkRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.hierarchicalClusteringPanel, gridBagConstraints);
        this.pointsLabelPanel.setBorder(BorderFactory.createTitledBorder("Documents Label"));
        this.pointsLabelPanel.setLayout(new GridBagLayout());
        this.numberLinesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pointsLabelPanel.add((Component)this.numberLinesComboBox, gridBagConstraints);
        this.linesFileLabel.setText("Lines of file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pointsLabelPanel.add((Component)this.linesFileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.pointsLabelPanel, gridBagConstraints);
        this.triangulationPanel.setBorder(BorderFactory.createTitledBorder("Triangulation"));
        this.delaunayCheckBox.setText("Create Delaunay Triangulation");
        this.triangulationPanel.add(this.delaunayCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.triangulationPanel, gridBagConstraints);
    }

    private void hierarchicalClusteringCheckBoxActionPerformed(ActionEvent evt) {
        if (this.hierarchicalClusteringCheckBox.isSelected()) {
            this.alinkRadioButton.setEnabled(true);
            this.clinkRadioButton.setEnabled(true);
            this.slinkRadioButton.setEnabled(true);
        } else {
            this.alinkRadioButton.setEnabled(false);
            this.clinkRadioButton.setEnabled(false);
            this.slinkRadioButton.setEnabled(false);
        }
    }

    public GeneralParameters reset() {
        if (this.pdata.getSourceType() == SourceType.CORPUS) {
            this.numberLinesComboBox.setEnabled(true);
        } else {
            this.numberLinesComboBox.setEnabled(false);
        }
        this.knnConnectivityComboBox.setSelectedIndex(this.pdata.getKnnNumberNeighbors());
        this.delaunayCheckBox.setSelected(this.pdata.isCreateDelaunay());
        return this;
    }

    @Override
    public void refreshData() {
        this.pdata.setKnnNumberNeighbors(this.knnConnectivityComboBox.getSelectedIndex());
        this.pdata.setNumberLines(this.numberLinesComboBox.getSelectedIndex() + 1);
        this.pdata.setDescription(this.descriptionTextArea.getText());
        this.pdata.setCreateDelaunay(this.delaunayCheckBox.isSelected());
        if (this.hierarchicalClusteringCheckBox.isSelected()) {
            if (this.alinkRadioButton.isSelected()) {
                this.pdata.setHierarchicalClusteringType(HierarchicalClusteringType.ALINK);
            } else if (this.clinkRadioButton.isSelected()) {
                this.pdata.setHierarchicalClusteringType(HierarchicalClusteringType.CLINK);
            } else {
                this.pdata.setHierarchicalClusteringType(HierarchicalClusteringType.SLINK);
            }
        } else {
            this.pdata.setHierarchicalClusteringType(HierarchicalClusteringType.NONE);
        }
    }
}

