/*
 * Decompiled with CFR 0.152.
 */
package visualizer.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import visualizer.projection.ProjectionData;
import visualizer.projection.ProjectionType;
import visualizer.projection.SourceType;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.kolmogorov.CompressorType;
import visualizer.util.SaveDialog;
import visualizer.util.filefilter.DMATFilter;
import visualizer.wizard.WizardPanel;

public class ProjectionDistanceChoice
extends WizardPanel {
    private ProjectionData pdata;
    private JRadioButton bzip2RadioButton;
    private JPanel chooseDistanceTypePanel;
    private JPanel chooseProjectionTechniquePanel;
    private ButtonGroup compressTypeButtonGroup;
    private ButtonGroup distanceButtonGroup;
    private JComboBox distanceComboBox;
    private JRadioButton distanceRadioButton;
    private JRadioButton gzipRadioButton;
    private JRadioButton lzo1RadioButton;
    private JRadioButton ncdRadioButton;
    private JComboBox projComboBox;
    private JCheckBox saveDistanceMatrixCheckBox;
    private JLabel spaceLabel1;
    private JLabel spaceLabel2;

    public ProjectionDistanceChoice(ProjectionData pdata) {
        this.pdata = pdata;
        this.initComponents();
        for (DissimilarityType disstype : DissimilarityType.getTypes()) {
            if (disstype == DissimilarityType.KOLMOGOROV || disstype == DissimilarityType.NONE) continue;
            this.distanceComboBox.addItem(disstype);
        }
        for (ProjectionType pt : ProjectionType.getTypes()) {
            if (pt == ProjectionType.NONE) continue;
            this.projComboBox.addItem(pt);
        }
    }

    private void initComponents() {
        this.distanceButtonGroup = new ButtonGroup();
        this.compressTypeButtonGroup = new ButtonGroup();
        this.chooseProjectionTechniquePanel = new JPanel();
        this.projComboBox = new JComboBox();
        this.chooseDistanceTypePanel = new JPanel();
        this.gzipRadioButton = new JRadioButton();
        this.bzip2RadioButton = new JRadioButton();
        this.spaceLabel1 = new JLabel();
        this.spaceLabel2 = new JLabel();
        this.distanceRadioButton = new JRadioButton();
        this.distanceComboBox = new JComboBox();
        this.ncdRadioButton = new JRadioButton();
        this.lzo1RadioButton = new JRadioButton();
        this.saveDistanceMatrixCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setLayout(new GridBagLayout());
        this.chooseProjectionTechniquePanel.setBorder(BorderFactory.createTitledBorder("Choose the Projection Technique"));
        this.chooseProjectionTechniquePanel.setLayout(new GridBagLayout());
        this.projComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionDistanceChoice.this.projComboBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.chooseProjectionTechniquePanel.add((Component)this.projComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chooseProjectionTechniquePanel, gridBagConstraints);
        this.chooseDistanceTypePanel.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel.setLayout(new GridBagLayout());
        this.compressTypeButtonGroup.add(this.gzipRadioButton);
        this.gzipRadioButton.setSelected(true);
        this.gzipRadioButton.setText("gzip");
        this.gzipRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.gzipRadioButton.setEnabled(false);
        this.gzipRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.chooseDistanceTypePanel.add((Component)this.gzipRadioButton, gridBagConstraints);
        this.compressTypeButtonGroup.add(this.bzip2RadioButton);
        this.bzip2RadioButton.setText("bzip2");
        this.bzip2RadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.bzip2RadioButton.setEnabled(false);
        this.bzip2RadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.bzip2RadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionDistanceChoice.this.bzip2RadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.chooseDistanceTypePanel.add((Component)this.bzip2RadioButton, gridBagConstraints);
        this.spaceLabel1.setText("          ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.chooseDistanceTypePanel.add((Component)this.spaceLabel1, gridBagConstraints);
        this.spaceLabel2.setText("          ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.chooseDistanceTypePanel.add((Component)this.spaceLabel2, gridBagConstraints);
        this.distanceButtonGroup.add(this.distanceRadioButton);
        this.distanceRadioButton.setSelected(true);
        this.distanceRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionDistanceChoice.this.distanceRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.chooseDistanceTypePanel.add((Component)this.distanceRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel.add((Component)this.distanceComboBox, gridBagConstraints);
        this.distanceButtonGroup.add(this.ncdRadioButton);
        this.ncdRadioButton.setText("  Normal Compress Distance (NCD)");
        this.ncdRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionDistanceChoice.this.ncdRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.chooseDistanceTypePanel.add((Component)this.ncdRadioButton, gridBagConstraints);
        this.compressTypeButtonGroup.add(this.lzo1RadioButton);
        this.lzo1RadioButton.setText("lzo1");
        this.lzo1RadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lzo1RadioButton.setEnabled(false);
        this.lzo1RadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.lzo1RadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionDistanceChoice.this.lzo1RadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.chooseDistanceTypePanel.add((Component)this.lzo1RadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.chooseDistanceTypePanel, gridBagConstraints);
        this.saveDistanceMatrixCheckBox.setText("Save the distance matrix");
        this.saveDistanceMatrixCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveDistanceMatrixCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.saveDistanceMatrixCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionDistanceChoice.this.saveDistanceMatrixCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.saveDistanceMatrixCheckBox, gridBagConstraints);
    }

    private void saveDistanceMatrixCheckBoxActionPerformed(ActionEvent evt) {
        if (this.saveDistanceMatrixCheckBox.isSelected()) {
            String filename = this.pdata.getSourceFile();
            int result = SaveDialog.showSaveDialog(new DMATFilter(), this, filename);
            if (result == 0) {
                filename = SaveDialog.getFilename();
                this.pdata.setDistanceMatrixFilename(filename);
            } else {
                this.saveDistanceMatrixCheckBox.setSelected(false);
            }
        } else {
            this.pdata.setDistanceMatrixFilename("");
        }
    }

    private void distanceRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceComboBox.setEnabled(true);
        this.gzipRadioButton.setEnabled(false);
        this.bzip2RadioButton.setEnabled(false);
        this.lzo1RadioButton.setEnabled(false);
    }

    private void ncdRadioButtonActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "The NCD distances calculation is a very expensive \n projectionData. It will take several minutes!", "WARNING", 2);
        this.distanceComboBox.setEnabled(false);
        this.gzipRadioButton.setEnabled(true);
        this.bzip2RadioButton.setEnabled(true);
        this.lzo1RadioButton.setEnabled(true);
    }

    private void projComboBoxActionPerformed(ActionEvent evt) {
        this.reset();
    }

    private void lzo1RadioButtonActionPerformed(ActionEvent evt) {
    }

    private void bzip2RadioButtonActionPerformed(ActionEvent evt) {
    }

    public ProjectionDistanceChoice reset() {
        ProjectionType type = (ProjectionType)this.projComboBox.getSelectedItem();
        if (type.isDistanceBased()) {
            this.distanceRadioButton.setEnabled(true);
            this.distanceComboBox.setEnabled(true);
            if (type.isAttributesNeeded()) {
                this.distanceRadioButton.setSelected(true);
                this.ncdRadioButton.setEnabled(false);
                this.gzipRadioButton.setEnabled(false);
                this.bzip2RadioButton.setEnabled(false);
                this.lzo1RadioButton.setEnabled(false);
            } else if (this.pdata.getSourceType() == SourceType.CORPUS) {
                this.ncdRadioButton.setEnabled(true);
                if (this.ncdRadioButton.isSelected()) {
                    this.gzipRadioButton.setEnabled(true);
                    this.bzip2RadioButton.setEnabled(true);
                    this.lzo1RadioButton.setEnabled(true);
                } else {
                    this.gzipRadioButton.setEnabled(false);
                    this.bzip2RadioButton.setEnabled(false);
                    this.lzo1RadioButton.setEnabled(false);
                }
            } else {
                this.distanceRadioButton.setSelected(true);
                this.ncdRadioButton.setEnabled(false);
                this.gzipRadioButton.setEnabled(false);
                this.bzip2RadioButton.setEnabled(false);
                this.lzo1RadioButton.setEnabled(false);
            }
            if (this.pdata.getSourceType() == SourceType.DISTANCE_MATRIX) {
                this.distanceComboBox.setEnabled(false);
                this.distanceRadioButton.setEnabled(false);
                this.ncdRadioButton.setEnabled(false);
                this.gzipRadioButton.setEnabled(false);
                this.bzip2RadioButton.setEnabled(false);
                this.lzo1RadioButton.setEnabled(false);
            }
        } else {
            this.distanceComboBox.setEnabled(false);
            this.distanceRadioButton.setEnabled(false);
            this.ncdRadioButton.setEnabled(false);
            this.gzipRadioButton.setEnabled(false);
            this.bzip2RadioButton.setEnabled(false);
            this.lzo1RadioButton.setEnabled(false);
        }
        if (type.isGenerateDistanceMatrix() && (this.pdata.getSourceType() == SourceType.POINTS || this.pdata.getSourceType() == SourceType.CORPUS)) {
            this.saveDistanceMatrixCheckBox.setEnabled(true);
        } else {
            this.saveDistanceMatrixCheckBox.setEnabled(false);
        }
        return this;
    }

    @Override
    public void refreshData() {
        ProjectionType projtype = (ProjectionType)this.projComboBox.getSelectedItem();
        this.pdata.setProjectionType(projtype);
        if (this.ncdRadioButton.isSelected()) {
            this.pdata.setDissimilarityType(DissimilarityType.KOLMOGOROV);
            if (this.gzipRadioButton.isSelected()) {
                this.pdata.setCompressorType(CompressorType.GZIP);
            } else if (this.bzip2RadioButton.isSelected()) {
                this.pdata.setCompressorType(CompressorType.BZIP2);
            } else {
                this.pdata.setCompressorType(CompressorType.LZO1);
            }
        } else {
            DissimilarityType metrictype = (DissimilarityType)this.distanceComboBox.getSelectedItem();
            this.pdata.setDissimilarityType(metrictype);
        }
    }
}

