/*
 * Decompiled with CFR 0.152.
 */
package visualizer.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visualizer.graph.Graph;
import visualizer.view.ReportView;
import visualizer.wizard.DataSourceChoice;
import visualizer.wizard.ProjectionView;
import visualizer.wizard.ProjectionWizardCore;
import visualizer.wizard.WizardPanel;

public class ProjectionWizardView
extends JDialog {
    public static final int PROJECTION_CANCELED = 0;
    public static final int PROJECTION_GENERATED = 1;
    private Graph graph;
    private ProjectionWizardCore process;
    private int exit = 1;
    private static ProjectionWizardView instance;
    private WizardPanel dataPanel;
    private JPanel buttonPanel;
    private JButton nextButton;
    private JButton previousButton;
    private JPanel processPanel;
    private JPanel reportPanel;
    private JTabbedPane wizardTabbedPane;

    private ProjectionWizardView(JFrame parent) {
        super(parent);
        this.initComponents();
        this.setPreferredSize(new Dimension(700, 600));
        this.setSize(700, 600);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.wizardTabbedPane = new JTabbedPane();
        this.processPanel = new JPanel();
        this.reportPanel = new ReportView();
        this.setDefaultCloseOperation(2);
        this.setTitle("Projection Wizard");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProjectionWizardView.this.formWindowClosing(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.previousButton.setText("<< Back");
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionWizardView.this.previousButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.previousButton);
        this.nextButton.setText("Next >>");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionWizardView.this.nextButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.nextButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.wizardTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ProjectionWizardView.this.wizardTabbedPaneStateChanged(evt);
            }
        });
        this.processPanel.setLayout(new BorderLayout());
        this.wizardTabbedPane.addTab("Process", this.processPanel);
        this.wizardTabbedPane.addTab("Report", this.reportPanel);
        this.getContentPane().add((Component)this.wizardTabbedPane, "Center");
        this.pack();
    }

    private void wizardTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.graph != null) {
            this.dataPanel.refreshData();
            ((ReportView)this.reportPanel).reset(this.graph.getProjectionData());
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exit = 0;
        this.process.stopProcess();
        this.setVisible(false);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.dataPanel.refreshData();
        if (this.dataPanel instanceof DataSourceChoice) {
            if (this.graph.getProjectionData().getSourceFile().trim().length() > 0) {
                this.definePanel(0);
            } else {
                JOptionPane.showMessageDialog(this, "A corpus or points file or distance file must be provided!", "Problems", 0);
            }
        } else {
            this.definePanel(0);
        }
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        this.definePanel(1);
    }

    public static ProjectionWizardView getInstance(JFrame parent) {
        if (instance == null) {
            instance = new ProjectionWizardView(parent);
        }
        return instance;
    }

    public int display(Graph graph) {
        this.exit = 1;
        this.graph = graph;
        this.process = new ProjectionWizardCore(graph);
        this.definePanel(0);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.exit;
    }

    private void definePanel(int direction) {
        WizardPanel newPanel = this.process.getNextPanel(direction);
        if (newPanel != null) {
            if (newPanel instanceof ProjectionView) {
                this.nextButton.setText("Finish");
            } else {
                this.nextButton.setText("Next >>");
            }
            this.nextButton.setEnabled(true);
            if (newPanel instanceof DataSourceChoice) {
                this.previousButton.setEnabled(false);
            } else {
                this.previousButton.setEnabled(true);
            }
            this.processPanel.removeAll();
            this.dataPanel = newPanel;
            this.processPanel.add(this.dataPanel);
            this.setLocationRelativeTo(this.getParent());
            this.dataPanel.repaint();
            this.validate();
        } else {
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        }
    }

    public ProjectionWizardCore getProcess() {
        return this.process;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ProjectionWizardView(null).setVisible(true);
            }
        });
    }
}

