/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ColorChooser;
import ij.gui.GenericDialog;
import ij.measure.SplineFitter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;

class ColorPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    static final int entryWidth = 12;
    static final int entryHeight = 12;
    int rows = 16;
    int columns = 16;
    Color[] c = new Color[256];
    Color b;
    ColorProcessor cp;
    IndexColorModel origin;
    private ImagePlus imp;
    private int[] xSize = new int[256];
    private int[] redY;
    private int[] greenY;
    private int[] blueY;
    private int mapSize;
    private int x;
    private int y;
    private int initialC = -1;
    private int finalC = -1;
    private byte[] reds;
    private byte[] greens;
    private byte[] blues;
    private boolean updateLut;
    private static String[] choices = new String[]{"Replication", "Interpolation", "Spline Fitting"};
    private static String scaleMethod = choices[1];

    ColorPanel(ImagePlus imp) {
        this.setup(imp);
    }

    public void setup(ImagePlus imp) {
        IndexColorModel cm;
        if (imp == null) {
            IJ.noImage();
            return;
        }
        this.imp = imp;
        ImageProcessor ip = imp.getChannelProcessor();
        this.origin = cm = (IndexColorModel)ip.getColorModel();
        this.mapSize = cm.getMapSize();
        this.reds = new byte[256];
        this.greens = new byte[256];
        this.blues = new byte[256];
        cm.getReds(this.reds);
        cm.getGreens(this.greens);
        cm.getBlues(this.blues);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        for (int index = 0; index < this.mapSize; ++index) {
            this.c[index] = new Color(this.reds[index] & 0xFF, this.greens[index] & 0xFF, this.blues[index] & 0xFF);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.columns * 12, this.rows * 12);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.columns * 12, this.rows * 12);
    }

    int getMouseZone(int x, int y) {
        int horizontal = x / 12;
        int vertical = y / 12;
        int index = this.columns * vertical + horizontal;
        return index;
    }

    public void colorRamp() {
        int index;
        if (this.initialC > this.finalC) {
            int tmp = this.initialC;
            this.initialC = this.finalC;
            this.finalC = tmp;
        }
        float difference = this.finalC - this.initialC + 1;
        int start = (byte)this.c[this.initialC].getRed() & 0xFF;
        int end = (byte)this.c[this.finalC].getRed() & 0xFF;
        float rstep = (float)(end - start) / difference;
        for (int index2 = this.initialC; index2 <= this.finalC; ++index2) {
            this.reds[index2] = (byte)((float)start + (float)(index2 - this.initialC) * rstep);
        }
        start = (byte)this.c[this.initialC].getGreen() & 0xFF;
        end = (byte)this.c[this.finalC].getGreen() & 0xFF;
        float gstep = (float)(end - start) / difference;
        for (int index3 = this.initialC; index3 <= this.finalC; ++index3) {
            this.greens[index3] = (byte)((float)start + (float)(index3 - this.initialC) * gstep);
        }
        start = (byte)this.c[this.initialC].getBlue() & 0xFF;
        end = (byte)this.c[this.finalC].getBlue() & 0xFF;
        float bstep = (float)(end - start) / difference;
        for (index = this.initialC; index <= this.finalC; ++index) {
            this.blues[index] = (byte)((float)start + (float)(index - this.initialC) * bstep);
        }
        for (index = this.initialC; index <= this.finalC; ++index) {
            this.c[index] = new Color(this.reds[index] & 0xFF, this.greens[index] & 0xFF, this.blues[index] & 0xFF);
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        this.initialC = this.getMouseZone(this.x, this.y);
    }

    public void mouseReleased(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        this.finalC = this.getMouseZone(this.x, this.y);
        if (this.initialC >= this.mapSize && this.finalC >= this.mapSize) {
            this.finalC = -1;
            this.initialC = -1;
            return;
        }
        if (this.initialC >= this.mapSize) {
            this.initialC = this.mapSize - 1;
        }
        if (this.finalC >= this.mapSize) {
            this.finalC = this.mapSize - 1;
        }
        if (this.finalC < 0) {
            this.finalC = 0;
        }
        if (this.initialC == this.finalC) {
            this.b = this.c[this.finalC];
            ColorChooser cc = new ColorChooser("Color at Entry " + this.finalC, this.c[this.finalC], false);
            this.c[this.finalC] = cc.getColor();
            if (this.c[this.finalC] == null) {
                this.c[this.finalC] = this.b;
            }
            this.colorRamp();
        } else {
            this.b = this.c[this.initialC];
            ColorChooser icc = new ColorChooser("Initial Entry (" + this.initialC + ")", this.c[this.initialC], false);
            this.c[this.initialC] = icc.getColor();
            if (this.c[this.initialC] == null) {
                this.c[this.initialC] = this.b;
                this.finalC = -1;
                this.initialC = -1;
                return;
            }
            this.b = this.c[this.finalC];
            ColorChooser fcc = new ColorChooser("Final Entry (" + this.finalC + ")", this.c[this.finalC], false);
            this.c[this.finalC] = fcc.getColor();
            if (this.c[this.finalC] == null) {
                this.c[this.finalC] = this.b;
                this.finalC = -1;
                this.initialC = -1;
                return;
            }
            this.colorRamp();
        }
        this.finalC = -1;
        this.initialC = -1;
        this.applyLUT();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        this.finalC = this.getMouseZone(this.x, this.y);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        int entry = this.getMouseZone(this.x, this.y);
        if (entry < this.mapSize) {
            int red = this.reds[entry] & 0xFF;
            int green = this.greens[entry] & 0xFF;
            int blue = this.blues[entry] & 0xFF;
            IJ.showStatus("index=" + entry + ", color=" + red + "," + green + "," + blue);
        } else {
            IJ.showStatus("");
        }
    }

    void open() {
        try {
            IJ.run("LUT... ");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.updateLut = true;
        this.repaint();
    }

    void updateLut() {
        IndexColorModel cm = (IndexColorModel)this.imp.getChannelProcessor().getColorModel();
        if (this.mapSize == 0) {
            return;
        }
        cm.getReds(this.reds);
        cm.getGreens(this.greens);
        cm.getBlues(this.blues);
        for (int i = 0; i < this.mapSize; ++i) {
            this.c[i] = new Color(this.reds[i] & 0xFF, this.greens[i] & 0xFF, this.blues[i] & 0xFF);
        }
    }

    void invert() {
        int i;
        byte[] reds2 = new byte[this.mapSize];
        byte[] greens2 = new byte[this.mapSize];
        byte[] blues2 = new byte[this.mapSize];
        for (i = 0; i < this.mapSize; ++i) {
            reds2[i] = (byte)(this.reds[this.mapSize - i - 1] & 0xFF);
            greens2[i] = (byte)(this.greens[this.mapSize - i - 1] & 0xFF);
            blues2[i] = (byte)(this.blues[this.mapSize - i - 1] & 0xFF);
        }
        this.reds = reds2;
        this.greens = greens2;
        this.blues = blues2;
        for (i = 0; i < this.mapSize; ++i) {
            this.c[i] = new Color(this.reds[i] & 0xFF, this.greens[i] & 0xFF, this.blues[i] & 0xFF);
        }
        this.applyLUT();
        this.repaint();
    }

    void resize() {
        GenericDialog sgd = new GenericDialog("LUT Editor");
        sgd.addNumericField("Number of Colors:", this.mapSize, 0);
        sgd.addChoice("Scale Using:", choices, scaleMethod);
        sgd.showDialog();
        if (sgd.wasCanceled()) {
            this.cancelLUT();
            return;
        }
        int newSize = (int)sgd.getNextNumber();
        if (newSize < 2) {
            newSize = 2;
        }
        if (newSize > 256) {
            newSize = 256;
        }
        scaleMethod = sgd.getNextChoice();
        this.scale(this.reds, this.greens, this.blues, newSize);
        this.mapSize = newSize;
        for (int i = 0; i < this.mapSize; ++i) {
            this.c[i] = new Color(this.reds[i] & 0xFF, this.greens[i] & 0xFF, this.blues[i] & 0xFF);
        }
        this.applyLUT();
        this.repaint();
    }

    void scale(byte[] reds, byte[] greens, byte[] blues, int newSize) {
        if (newSize == this.mapSize) {
            return;
        }
        if (newSize < this.mapSize || scaleMethod.equals(choices[0])) {
            this.scaleUsingReplication(reds, greens, blues, newSize);
        } else if (scaleMethod.equals(choices[1])) {
            this.scaleUsingInterpolation(reds, greens, blues, newSize);
        } else {
            this.scaleUsingSplineFitting(reds, greens, blues, newSize);
        }
    }

    void scaleUsingReplication(byte[] reds, byte[] greens, byte[] blues, int newSize) {
        int i;
        byte[] reds2 = new byte[256];
        byte[] greens2 = new byte[256];
        byte[] blues2 = new byte[256];
        for (i = 0; i < this.mapSize; ++i) {
            reds2[i] = reds[i];
            greens2[i] = greens[i];
            blues2[i] = blues[i];
        }
        for (i = 0; i < newSize; ++i) {
            int index = (int)((double)i * ((double)this.mapSize / (double)newSize));
            reds[i] = reds2[index];
            greens[i] = greens2[index];
            blues[i] = blues2[index];
        }
    }

    void scaleUsingInterpolation(byte[] reds, byte[] greens, byte[] blues, int newSize) {
        int[] r = new int[this.mapSize];
        int[] g = new int[this.mapSize];
        int[] b = new int[this.mapSize];
        for (int i = 0; i < this.mapSize; ++i) {
            r[i] = reds[i] & 0xFF;
            g[i] = greens[i] & 0xFF;
            b[i] = blues[i] & 0xFF;
        }
        double scale = (double)(this.mapSize - 1) / (double)(newSize - 1);
        for (int i = 0; i < newSize; ++i) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == this.mapSize) {
                i2 = this.mapSize - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)r[i1] + fraction * (double)r[i2]);
            greens[i] = (byte)((1.0 - fraction) * (double)g[i1] + fraction * (double)g[i2]);
            blues[i] = (byte)((1.0 - fraction) * (double)b[i1] + fraction * (double)b[i2]);
        }
    }

    void scaleUsingSplineFitting(byte[] reds, byte[] greens, byte[] blues, int newSize) {
        int[] reds2 = new int[this.mapSize];
        int[] greens2 = new int[this.mapSize];
        int[] blues2 = new int[this.mapSize];
        for (int i = 0; i < this.mapSize; ++i) {
            reds2[i] = reds[i] & 0xFF;
            greens2[i] = greens[i] & 0xFF;
            blues2[i] = blues[i] & 0xFF;
        }
        int[] xValues = new int[this.mapSize];
        for (int i = 0; i < this.mapSize; ++i) {
            xValues[i] = (int)((double)i * (double)newSize / (double)(this.mapSize - 1));
        }
        SplineFitter sfReds = new SplineFitter(xValues, reds2, this.mapSize);
        SplineFitter sfGreens = new SplineFitter(xValues, greens2, this.mapSize);
        SplineFitter sfBlues = new SplineFitter(xValues, blues2, this.mapSize);
        for (int i = 0; i < newSize; ++i) {
            double v = Math.round(sfReds.evalSpline(xValues, reds2, this.mapSize, i));
            if (v < 0.0) {
                v = 0.0;
            }
            if (v > 255.0) {
                v = 255.0;
            }
            reds[i] = (byte)v;
            v = Math.round(sfGreens.evalSpline(xValues, greens2, this.mapSize, i));
            if (v < 0.0) {
                v = 0.0;
            }
            if (v > 255.0) {
                v = 255.0;
            }
            greens[i] = (byte)v;
            v = Math.round(sfBlues.evalSpline(xValues, blues2, this.mapSize, i));
            if (v < 0.0) {
                v = 0.0;
            }
            if (v > 255.0) {
                v = 255.0;
            }
            blues[i] = (byte)v;
        }
    }

    public void cancelLUT() {
        if (this.mapSize == 0) {
            return;
        }
        this.origin.getReds(this.reds);
        this.origin.getGreens(this.greens);
        this.origin.getBlues(this.blues);
        this.mapSize = 256;
        this.applyLUT();
    }

    public void applyLUT() {
        byte[] reds2 = this.reds;
        byte[] greens2 = this.greens;
        byte[] blues2 = this.blues;
        if (this.mapSize < 256) {
            reds2 = new byte[256];
            greens2 = new byte[256];
            blues2 = new byte[256];
            for (int i = 0; i < this.mapSize; ++i) {
                reds2[i] = this.reds[i];
                greens2[i] = this.greens[i];
                blues2[i] = this.blues[i];
            }
            this.scale(reds2, greens2, blues2, 256);
        }
        IndexColorModel cm = new IndexColorModel(8, 256, reds2, greens2, blues2);
        ImageProcessor ip = this.imp.getChannelProcessor();
        ip.setColorModel(cm);
        if (this.imp.isComposite()) {
            ((CompositeImage)this.imp).setChannelColorModel(cm);
        }
        if (this.imp.getStackSize() > 1 && !this.imp.isComposite()) {
            this.imp.getStack().setColorModel(cm);
        }
        this.imp.updateAndDraw();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.updateLut) {
            this.updateLut();
            this.updateLut = false;
        }
        int index = 0;
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.columns; ++x) {
                if (index >= this.mapSize) {
                    g.setColor(Color.lightGray);
                    g.fillRect(x * 12, y * 12, 12, 12);
                } else if (index <= this.finalC && index >= this.initialC || index >= this.finalC && index <= this.initialC) {
                    g.setColor(this.c[index].brighter());
                    g.fillRect(x * 12, y * 12, 12, 12);
                    g.setColor(Color.white);
                    g.drawRect(x * 12, y * 12, 12, 12);
                    g.setColor(Color.black);
                    g.drawLine(x * 12 + 12 - 1, y * 12, x * 12 + 12 - 1, y * 12 + 12);
                    g.drawLine(x * 12, y * 12 + 12 - 1, x * 12 + 12 - 1, y * 12 + 12 - 1);
                    g.setColor(Color.white);
                } else {
                    g.setColor(this.c[index]);
                    g.fillRect(x * 12, y * 12, 12, 12);
                    g.setColor(Color.white);
                    g.drawRect(x * 12, y * 12, 11, 11);
                    g.setColor(Color.black);
                    g.drawLine(x * 12, y * 12, x * 12 + 12 - 1, y * 12);
                    g.drawLine(x * 12, y * 12, x * 12, y * 12 + 12 - 1);
                }
                ++index;
            }
        }
    }

    int getMapSize() {
        return this.mapSize;
    }
}

