/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.EllipseFitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Frame;
import java.awt.Rectangle;

public class Selection
implements PlugIn,
Measurements {
    ImagePlus imp;
    float[] kernel = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    float[] kernel3 = new float[]{1.0f, 1.0f, 1.0f};
    static String angle = "15";
    static String enlarge = "15";
    static String bandSize = "15";

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (arg.equals("add")) {
            this.addToRoiManager(this.imp);
            return;
        }
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("all")) {
            this.imp.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else if (arg.equals("none")) {
            this.imp.killRoi();
        } else if (arg.equals("restore")) {
            this.imp.restoreRoi();
        } else if (arg.equals("spline")) {
            this.fitSpline();
        } else if (arg.equals("ellipse")) {
            this.drawEllipse(this.imp);
        } else if (arg.equals("hull")) {
            this.convexHull(this.imp);
        } else if (arg.equals("mask")) {
            this.createMask(this.imp);
        } else if (arg.equals("from")) {
            this.createSelectionFromMask(this.imp);
        } else if (arg.equals("inverse")) {
            this.invert(this.imp);
        } else {
            this.runMacro(arg);
        }
    }

    void runMacro(String arg) {
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            IJ.error("Selection required");
            return;
        }
        roi = (Roi)roi.clone();
        if (arg.equals("rotate")) {
            String value = IJ.runMacroFile("ij.jar:RotateSelection", angle);
            if (value != null) {
                angle = value;
            }
        } else if (arg.equals("enlarge")) {
            String value = IJ.runMacroFile("ij.jar:EnlargeSelection", enlarge);
            if (value != null) {
                enlarge = value;
            }
            Roi.previousRoi = roi;
        } else if (arg.equals("band")) {
            String value = IJ.runMacroFile("ij.jar:MakeSelectionBand", bandSize);
            if (value != null) {
                bandSize = value;
            }
            Roi.previousRoi = roi;
        }
    }

    void fitSpline() {
        double mag;
        boolean segmentedSelection;
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            IJ.error("Spline", "Selection required");
            return;
        }
        int type = roi.getType();
        boolean bl = segmentedSelection = type == 2 || type == 6;
        if (!segmentedSelection && type != 3 && type != 4 && type != 7) {
            IJ.error("Spline", "Polygon or polyline selection required");
            return;
        }
        PolygonRoi p = (PolygonRoi)roi;
        double length = this.getLength(p);
        if (!segmentedSelection) {
            p = this.trimPolygon(p, length);
        }
        int evaluationPoints = (int)(length / 2.0);
        ImageCanvas ic = this.imp.getCanvas();
        if (ic != null && (mag = ic.getMagnification()) < 1.0) {
            evaluationPoints = (int)((double)evaluationPoints * mag);
        }
        if (evaluationPoints < 100) {
            evaluationPoints = 100;
        }
        p.fitSpline(evaluationPoints);
        this.imp.draw();
    }

    double getLength(PolygonRoi roi) {
        Calibration cal = this.imp.getCalibration();
        double spw = cal.pixelWidth;
        double sph = cal.pixelHeight;
        cal.pixelWidth = 1.0;
        cal.pixelHeight = 1.0;
        double length = roi.getLength();
        cal.pixelWidth = spw;
        cal.pixelHeight = sph;
        return length;
    }

    PolygonRoi trimPolygon(PolygonRoi roi, double length) {
        int type;
        int[] x = roi.getXCoordinates();
        int[] y = roi.getYCoordinates();
        int n = roi.getNCoordinates();
        float[] curvature = this.getCurvature(x, y, n);
        Rectangle r = roi.getBounds();
        double threshold = this.rodbard(length);
        double distance = Math.sqrt((x[1] - x[0]) * (x[1] - x[0]) + (y[1] - y[0]) * (y[1] - y[0]));
        x[0] = x[0] + r.x;
        y[0] = y[0] + r.y;
        int i2 = 1;
        int x2 = 0;
        int y2 = 0;
        for (int i = 1; i < n - 1; ++i) {
            int x1 = x[i];
            int y1 = y[i];
            x2 = x[i + 1];
            y2 = y[i + 1];
            distance += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) + 1.0;
            if (!((distance += (double)(curvature[i] * 2.0f)) >= threshold)) continue;
            x[i2] = x2 + r.x;
            y[i2] = y2 + r.y;
            ++i2;
            distance = 0.0;
        }
        int n2 = type = roi.getType() == 7 ? 6 : 2;
        if (type == 6 && distance > 0.0) {
            x[i2] = x2 + r.x;
            y[i2] = y2 + r.y;
            ++i2;
        }
        PolygonRoi p = new PolygonRoi(x, y, i2, type);
        this.imp.setRoi(p);
        return p;
    }

    double rodbard(double x) {
        double ex = x == 0.0 ? 5.0 : Math.exp(Math.log(x / 700.0) * 0.88);
        double y = -40.1;
        return (y /= 1.0 + ex) + 44.0;
    }

    float[] getCurvature(int[] x, int[] y, int n) {
        float[] x2 = new float[n];
        float[] y2 = new float[n];
        for (int i = 0; i < n; ++i) {
            x2[i] = x[i];
            y2[i] = y[i];
        }
        FloatProcessor ipx = new FloatProcessor(n, 1, x2, null);
        FloatProcessor ipy = new FloatProcessor(n, 1, y2, null);
        ((ImageProcessor)ipx).convolve(this.kernel, this.kernel.length, 1);
        ((ImageProcessor)ipy).convolve(this.kernel, this.kernel.length, 1);
        float[] indexes = new float[n];
        float[] curvature = new float[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = i;
            curvature[i] = (float)Math.sqrt((x2[i] - (float)x[i]) * (x2[i] - (float)x[i]) + (y2[i] - (float)y[i]) * (y2[i] - (float)y[i]));
        }
        return curvature;
    }

    void drawEllipse(ImagePlus imp) {
        ImageStatistics stats;
        IJ.showStatus("Fitting ellipse");
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error("Fit Ellipse", "Selection required");
            return;
        }
        if (roi.isLine()) {
            IJ.error("Fit Ellipse", "\"Fit Ellipse\" does not work with line selections");
            return;
        }
        ImageProcessor ip = imp.getProcessor();
        if (roi.getType() == 9) {
            stats = imp.getStatistics();
        } else {
            ip.setRoi(roi.getPolygon());
            stats = ImageStatistics.getStatistics(ip, 27, null);
        }
        EllipseFitter ef = new EllipseFitter();
        ef.fit(ip, stats);
        ef.makeRoi(ip);
        imp.setRoi(new PolygonRoi(ef.xCoordinates, ef.yCoordinates, ef.nCoordinates, 3));
        IJ.showStatus("");
    }

    void convexHull(ImagePlus imp) {
        int type;
        Roi roi = imp.getRoi();
        int n = type = roi != null ? roi.getType() : -1;
        if (type != 3 && type != 4 && type != 2 && type != 10) {
            IJ.error("Convex Hull", "Polygonal or point selection required");
            return;
        }
        imp.setRoi(this.makeConvexHull(imp, (PolygonRoi)roi));
    }

    Roi makeConvexHull(ImagePlus imp, PolygonRoi roi) {
        int p2;
        int p1;
        int n = roi.getNCoordinates();
        int[] xCoordinates = roi.getXCoordinates();
        int[] yCoordinates = roi.getYCoordinates();
        Rectangle r = roi.getBounds();
        int xbase = r.x;
        int ybase = r.y;
        int[] xx = new int[n];
        int[] yy = new int[n];
        int n2 = 0;
        int pstart = p1 = this.findFirstPoint(xCoordinates, yCoordinates, n, imp);
        do {
            int x1 = xCoordinates[p1];
            int y1 = yCoordinates[p1];
            p2 = p1 + 1;
            if (p2 == n) {
                p2 = 0;
            }
            int x2 = xCoordinates[p2];
            int y2 = yCoordinates[p2];
            int p3 = p2 + 1;
            if (p3 == n) {
                p3 = 0;
            }
            do {
                int x3;
                int y3;
                int determinate;
                if ((determinate = x1 * (y2 - (y3 = yCoordinates[p3])) - y1 * (x2 - (x3 = xCoordinates[p3])) + (y3 * x2 - y2 * x3)) > 0) {
                    x2 = x3;
                    y2 = y3;
                    p2 = p3;
                }
                if (++p3 != n) continue;
                p3 = 0;
            } while (p3 != p1);
            if (n2 >= n) continue;
            xx[n2] = xbase + x1;
            yy[n2] = ybase + y1;
            ++n2;
        } while ((p1 = p2) != pstart);
        return new PolygonRoi(xx, yy, n2, 2);
    }

    int findFirstPoint(int[] xCoordinates, int[] yCoordinates, int n, ImagePlus imp) {
        int y;
        int smallestY = imp.getHeight();
        for (int i = 0; i < n; ++i) {
            y = yCoordinates[i];
            if (y >= smallestY) continue;
            smallestY = y;
        }
        int smallestX = imp.getWidth();
        int p1 = 0;
        for (int i = 0; i < n; ++i) {
            int x = xCoordinates[i];
            y = yCoordinates[i];
            if (y != smallestY || x >= smallestX) continue;
            smallestX = x;
            p1 = i;
        }
        return p1;
    }

    void createMask(ImagePlus imp) {
        ImageProcessor ip;
        Roi roi = imp.getRoi();
        boolean useInvertingLut = Prefs.useInvertingLut;
        Prefs.useInvertingLut = false;
        if (roi == null || !roi.isArea() && roi.getType() != 10) {
            this.createMaskFromThreshold(imp);
            Prefs.useInvertingLut = useInvertingLut;
            return;
        }
        ImagePlus maskImp = null;
        Frame frame = WindowManager.getFrame("Mask");
        if (frame != null && frame instanceof ImageWindow) {
            maskImp = ((ImageWindow)frame).getImagePlus();
        }
        if (maskImp == null) {
            ip = new ByteProcessor(imp.getWidth(), imp.getHeight());
            if (!Prefs.blackBackground) {
                ip.invertLut();
            }
            maskImp = new ImagePlus("Mask", ip);
            maskImp.show();
        }
        ip = maskImp.getProcessor();
        ip.setRoi(roi);
        ip.setValue(255.0);
        ip.fill(ip.getMask());
        maskImp.updateAndDraw();
        Prefs.useInvertingLut = useInvertingLut;
    }

    void createMaskFromThreshold(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (ip.getMinThreshold() == -808080.0) {
            IJ.error("Create Mask", "Area selection or thresholded image required");
            return;
        }
        double t1 = ip.getMinThreshold();
        double t2 = ip.getMaxThreshold();
        IJ.run("Duplicate...", "title=mask");
        ImagePlus imp2 = WindowManager.getCurrentImage();
        ImageProcessor ip2 = imp2.getProcessor();
        ip2.setThreshold(t1, t2, 2);
        IJ.run("Convert to Mask");
    }

    void createSelectionFromMask(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (ip.getMinThreshold() != -808080.0) {
            IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
            return;
        }
        ImageStatistics stats = null;
        if (imp.getBitDepth() == 8) {
            stats = imp.getStatistics();
        }
        if (stats == null || stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error("Create Selection", "This command creates a composite selection from\na mask (8-bit binary image with white background)\nor from an image that has been thresholded using\nthe Image>Adjust>Threshold tool. The current\nimage is not a mask and has not been thresholded.");
            return;
        }
        int threshold = ip.isInvertedLut() ? 255 : 0;
        ip.setThreshold(threshold, threshold, 2);
        IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
    }

    void invert(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null || !roi.isArea()) {
            IJ.error("Inverse", "Area selection required");
            return;
        }
        ShapeRoi s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
        ShapeRoi s2 = new ShapeRoi(new Roi(0, 0, imp.getWidth(), imp.getHeight()));
        imp.setRoi(s1.xor(s2));
    }

    void addToRoiManager(ImagePlus imp) {
        Frame frame = WindowManager.getFrame("ROI Manager");
        if (frame == null) {
            IJ.run("ROI Manager...");
        }
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            return;
        }
        frame = WindowManager.getFrame("ROI Manager");
        if (frame == null || !(frame instanceof RoiManager)) {
            IJ.error("ROI Manager not found");
        }
        RoiManager rm = (RoiManager)frame;
        boolean altDown = IJ.altKeyDown();
        IJ.setKeyUp(50);
        if (altDown) {
            IJ.setKeyDown(16);
        }
        rm.runCommand("add");
        IJ.setKeyUp(50);
    }
}

