/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.io.FileInfo;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;

public class StackEditor
implements PlugIn {
    ImagePlus imp;
    int nSlices;
    int width;
    int height;

    public void run(String arg) {
        this.imp = IJ.getImage();
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (arg.equals("tostack")) {
            this.convertImagesToStack();
        } else if (arg.equals("add")) {
            this.addSlice();
        } else if (arg.equals("delete")) {
            this.deleteSlice();
        } else if (arg.equals("toimages")) {
            this.convertStackToImages(this.imp);
        }
    }

    void addSlice() {
        if (this.imp.isHyperStack()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        int id = 0;
        ImageStack stack = this.imp.getStack();
        if (stack.getSize() == 1) {
            Object obj;
            String label = stack.getSliceLabel(1);
            if (label != null && label.indexOf("\n") != -1) {
                stack.setSliceLabel(null, 1);
            }
            if ((obj = this.imp.getProperty("Label")) != null && obj instanceof String) {
                stack.setSliceLabel((String)obj, 1);
            }
            id = this.imp.getID();
        }
        ImageProcessor ip = this.imp.getProcessor();
        int n = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n;
        }
        stack.addSlice(null, ip.createProcessor(this.width, this.height), n);
        this.imp.setStack(null, stack);
        this.imp.setSlice(n + 1);
        this.imp.unlock();
        if (id != 0) {
            IJ.selectWindow(id);
        }
    }

    void deleteSlice() {
        String label;
        if (this.imp.isHyperStack()) {
            return;
        }
        if (this.nSlices < 2) {
            IJ.error("\"Delete Slice\" requires a stack");
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        stack.deleteSlice(n);
        if (stack.getSize() == 1 && (label = stack.getSliceLabel(1)) != null) {
            this.imp.setProperty("Label", label);
        }
        this.imp.setStack(null, stack);
        if (n-- < 1) {
            n = 1;
        }
        this.imp.setSlice(n);
        this.imp.unlock();
    }

    public void convertImagesToStack() {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error("No images are open.");
            return;
        }
        int count = 0;
        ImagePlus[] image = new ImagePlus[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp.getStackSize() != 1) continue;
            image[count++] = imp;
        }
        if (count < 2) {
            IJ.error("There must be at least two open images.");
            return;
        }
        Calibration cal2 = image[0].getCalibration();
        for (int i = 0; i < count - 1; ++i) {
            if (image[i].getType() != image[i + 1].getType()) {
                IJ.error("All open images must be the same type.");
                return;
            }
            if (image[i].getWidth() != image[i + 1].getWidth() || image[i].getHeight() != image[i + 1].getHeight()) {
                IJ.error("All open images must be the same size.");
                return;
            }
            Calibration cal = image[i].getCalibration();
            if (image[i].getCalibration().equals(cal2)) continue;
            cal2 = null;
        }
        int width = image[0].getWidth();
        int height = image[0].getHeight();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        ImageStack stack = new ImageStack(width, height);
        FileInfo fi = image[0].getOriginalFileInfo();
        if (fi != null && fi.directory == null) {
            fi = null;
        }
        for (int i = 0; i < count; ++i) {
            FileInfo fi2;
            ImageProcessor ip = image[i].getProcessor();
            if (ip.getMin() < min) {
                min = ip.getMin();
            }
            if (ip.getMax() > max) {
                max = ip.getMax();
            }
            String label = image[i].getTitle();
            String info = (String)image[i].getProperty("Info");
            if (info != null) {
                label = label + "\n" + info;
            }
            if (fi != null && (fi2 = image[i].getOriginalFileInfo()) != null && !fi.directory.equals(fi2.directory)) {
                fi = null;
            }
            stack.addSlice(label, ip);
            image[i].changes = false;
            image[i].close();
        }
        ImagePlus imp = new ImagePlus("Stack", stack);
        if (imp.getType() == 1 || imp.getType() == 2) {
            imp.getProcessor().setMinAndMax(min, max);
        }
        if (cal2 != null) {
            imp.setCalibration(cal2);
        }
        if (fi != null) {
            fi.fileName = "";
            fi.nImages = imp.getStackSize();
            imp.setFileInfo(fi);
        }
        imp.show();
    }

    public void convertStackToImages(ImagePlus imp) {
        CompositeImage cimg;
        boolean ok;
        if (this.nSlices < 2) {
            IJ.error("\"Convert Stack to Images\" requires a stack");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (size > 30 && !IJ.isMacro() && !(ok = IJ.showMessageWithCancel("Convert to Images?", "Are you sure you want to convert this\nstack to " + size + " separate windows?"))) {
            imp.unlock();
            return;
        }
        Calibration cal = imp.getCalibration();
        CompositeImage compositeImage = cimg = imp.isComposite() ? (CompositeImage)imp : null;
        if (imp.getNChannels() != imp.getStackSize()) {
            cimg = null;
        }
        for (int i = 1; i <= size; ++i) {
            LUT lut;
            String label = stack.getShortSliceLabel(i);
            String title = label != null && !label.equals("") ? label : this.getTitle(imp, i);
            ImageProcessor ip = stack.getProcessor(i);
            if (cimg != null && (lut = cimg.getChannelLut(i)) != null) {
                ip.setColorModel(lut);
                ip.setMinAndMax(lut.min, lut.max);
            }
            ImagePlus imp2 = new ImagePlus(title, ip);
            imp2.setCalibration(cal);
            imp2.show();
        }
        imp.changes = false;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.close();
        } else if (Interpreter.isBatchMode()) {
            Interpreter.removeBatchModeImage(imp);
        }
        imp.unlock();
    }

    String getTitle(ImagePlus imp, int n) {
        String digits = "00000000" + n;
        return imp.getShortTitle() + "-" + digits.substring(digits.length() - 4, digits.length());
    }
}

