/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

class BlockCrcInfo
implements Writable {
    public static final int STATUS_DATA_BLOCK = 0;
    public static final int STATUS_CRC_BLOCK = 1;
    public static final int STATUS_NO_CRC_DATA = 2;
    public static final int STATUS_UNKNOWN_BLOCK = 3;
    public static final int STATUS_ERROR = 4;
    int status = 4;
    String fileName = "";
    long fileSize;
    long startOffset;
    long blockLen;
    LocatedBlock[] crcBlocks;
    int crcReplication;
    boolean blockLocationsIncluded;
    LocatedBlock blockLocations = new LocatedBlock();

    BlockCrcInfo() {
    }

    private void writeBlockLocations(LocatedBlock[] locArr, DataOutput out) throws IOException {
        int len = locArr == null ? 0 : locArr.length;
        out.writeInt(len);
        if (len > 0) {
            for (LocatedBlock loc : locArr) {
                loc.write(out);
            }
        }
    }

    private LocatedBlock[] readBlockLocations(DataInput in) throws IOException {
        int len = in.readInt();
        LocatedBlock[] locArr = len > 0 ? new LocatedBlock[len] : null;
        for (int i = 0; i < len; ++i) {
            locArr[i] = new LocatedBlock();
            locArr[i].readFields(in);
        }
        return locArr;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.status);
        Text.writeString(out, this.fileName);
        out.writeLong(this.fileSize);
        out.writeLong(this.startOffset);
        out.writeLong(this.blockLen);
        this.writeBlockLocations(this.crcBlocks, out);
        out.writeInt(this.crcReplication);
        out.writeBoolean(this.blockLocationsIncluded);
        this.blockLocations.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.status = in.readInt();
        this.fileName = Text.readString(in);
        this.fileSize = in.readLong();
        this.startOffset = in.readLong();
        this.blockLen = in.readLong();
        this.crcBlocks = this.readBlockLocations(in);
        this.crcReplication = in.readInt();
        this.blockLocationsIncluded = in.readBoolean();
        this.blockLocations.readFields(in);
    }
}

