/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dfs.BlockCrcInfo;
import org.apache.hadoop.dfs.BlockCrcUpgradeUtils;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.dfs.INodeDirectory;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.LocatedBlocks;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeObjectNamenode;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;

class BlockCrcUpgradeObjectNamenode
extends UpgradeObjectNamenode {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.BlockCrcUpgradeNamenode");
    static final long inactivityExtension = 10000L;
    long lastNodeCompletionTime = 0L;
    UpgradeStatus upgradeStatus = UpgradeStatus.INITIALIZED;
    HashMap<DatanodeID, DnInfo> dnMap = new HashMap();
    HashMap<DatanodeID, DnInfo> unfinishedDnMap = new HashMap();
    HashMap<INodeMapEntry, INodeMapEntry> iNodeParentMap = null;
    Daemon monitorThread;
    double avgDatanodeCompletionPct = 0.0;
    boolean forceDnCompletion = false;
    private BlockLevelStats latestBlockLevelStats = new BlockLevelStats();

    public int getVersion() {
        return -6;
    }

    public UpgradeCommand completeUpgrade() throws IOException {
        return null;
    }

    public String getDescription() {
        return "Block CRC Upgrade at Namenode";
    }

    public synchronized short getUpgradeStatus() {
        if (this.upgradeStatus == UpgradeStatus.COMPLETED) {
            return 100;
        }
        if (this.upgradeStatus == UpgradeStatus.DATANODES_DONE) {
            return 90;
        }
        return (short)Math.floor(this.avgDatanodeCompletionPct * 0.9);
    }

    public UpgradeCommand startUpgrade() throws IOException {
        assert (this.monitorThread == null);
        this.buildINodeToParentMap();
        this.lastNodeCompletionTime = System.currentTimeMillis();
        this.monitorThread = new Daemon(new UpgradeMonitor());
        this.monitorThread.start();
        return super.startUpgrade();
    }

    public synchronized void forceProceed() throws IOException {
        if (this.isUpgradeDone() || this.upgradeStatus == UpgradeStatus.DATANODES_DONE) {
            LOG.info((Object)"forceProceed is a no op now since the stage waiting waiting for Datanode to completed is finished. Upgrade should soon complete");
            return;
        }
        if (this.forceDnCompletion) {
            LOG.warn((Object)"forceProceed is already set for this upgrade. It can take a short while to take affect. Please wait.");
            return;
        }
        LOG.info((Object)"got forceProceed request for this upgrade. Datanodes upgrade will be considered done. It can take a few seconds to take effect.");
        this.forceDnCompletion = true;
    }

    UpgradeCommand processUpgradeCommand(UpgradeCommand command) throws IOException {
        switch (command.getAction()) {
            case 201: {
                return this.handleCrcInfoCmd(command);
            }
            case 200: {
                return this.handleStatsCmd(command);
            }
        }
        throw new IOException("Unknown Command for BlockCrcUpgrade : " + command.getAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeStatusReport getUpgradeStatusReport(boolean details) throws IOException {
        String replyString = "";
        short status = 0;
        BlockCrcUpgradeObjectNamenode blockCrcUpgradeObjectNamenode = this;
        synchronized (blockCrcUpgradeObjectNamenode) {
            status = this.getUpgradeStatus();
            replyString = String.format((this.monitorThread == null ? "\tUpgrade has not been started yet.\n" : "") + (this.forceDnCompletion ? "\tForce Proceed is ON\n" : "") + "\tLast Block Level Stats updated at : %tc\n" + "\tLast Block Level Stats : %s\n" + "\tBrief Datanode Status  : %s\n" + "%s", this.latestBlockLevelStats.updatedAt, this.latestBlockLevelStats.statusString("\n\t                         "), this.printStatus("\n\t                         "), status < 100 && this.upgradeStatus == UpgradeStatus.DATANODES_DONE ? "\tNOTE: Upgrade at the Datanodes has finished. Deleteing \".crc\" files\n\tcan take longer than status implies.\n" : "");
            if (details) {
                StringBuilder str = null;
                Iterator<DatanodeID> keys = this.dnMap.keySet().iterator();
                Iterator<DnInfo> values = this.dnMap.values().iterator();
                while (keys.hasNext() && values.hasNext()) {
                    DatanodeID dn = keys.next();
                    DnInfo info = values.next();
                    String dnStr = "\t\t" + dn.getName() + "\t : " + info.percentCompleted + " % \t" + info.blocksUpgraded + " u \t" + info.blocksRemaining + " r \t" + info.errors + " e\n";
                    if (str == null) {
                        str = new StringBuilder(dnStr.length() * (this.dnMap.size() + (this.dnMap.size() + 7) / 8));
                    }
                    str.append(dnStr);
                }
                replyString = replyString + "\n\tDatanode Stats (total: " + this.dnMap.size() + "): " + "pct Completion(%) blocks upgraded (u) " + "blocks remaining (r) errors (e)\n\n" + (str == null ? "\t\tThere are no known Datanodes\n" : str);
            }
        }
        return new BlockCrcUpgradeUtils.BlockCrcUpgradeStatusReport(-6, status, replyString);
    }

    private UpgradeCommand handleCrcInfoCmd(UpgradeCommand cmd) {
        BlockCrcUpgradeUtils.CrcInfoCommand crcCmd = (BlockCrcUpgradeUtils.CrcInfoCommand)cmd;
        BlockCrcInfo crcInfo = this.getFSNamesystem().blockCrcInfo(crcCmd.block, this, false);
        return new BlockCrcUpgradeUtils.CrcInfoCommandReply(crcInfo);
    }

    private synchronized UpgradeCommand handleStatsCmd(UpgradeCommand cmd) {
        boolean alreadyCompleted;
        BlockCrcUpgradeUtils.DatanodeStatsCommand stats = (BlockCrcUpgradeUtils.DatanodeStatsCommand)cmd;
        DatanodeID dn = stats.datanodeId;
        DnInfo dnInfo = this.dnMap.get(dn);
        boolean bl = alreadyCompleted = dnInfo != null && dnInfo.isDone();
        if (dnInfo == null) {
            dnInfo = new DnInfo();
            this.dnMap.put(dn, dnInfo);
            LOG.info((Object)("Upgrade started/resumed at datanode " + dn.getName()));
        }
        dnInfo.setStats(stats);
        if (!dnInfo.isDone()) {
            this.unfinishedDnMap.put(dn, dnInfo);
        }
        if (dnInfo.isDone() && !alreadyCompleted) {
            LOG.info((Object)("upgrade completed on datanode " + dn.getName()));
            this.unfinishedDnMap.remove(dn);
            if (this.unfinishedDnMap.size() == 0) {
                this.lastNodeCompletionTime = System.currentTimeMillis();
            }
        }
        return new UpgradeCommand();
    }

    private INodeMapEntry addINodeParentEntry(INode inode, INodeMapEntry parent) {
        INodeMapEntry entry = new INodeMapEntry(inode, parent);
        this.iNodeParentMap.put(entry, entry);
        return entry;
    }

    private long addToINodeParentMap(INodeMapEntry parent) {
        long count = 0L;
        INodeDirectory dir = (INodeDirectory)parent.iNode;
        for (INode inode : dir.getChildren()) {
            if (inode.isDirectory()) {
                count += 1L + this.addToINodeParentMap(this.addINodeParentEntry(inode, parent));
                continue;
            }
            if (dir.getChild("." + inode.getLocalName() + ".crc") == null) continue;
            this.addINodeParentEntry(inode, parent);
            ++count;
        }
        return count;
    }

    INodeMapEntry getINodeMapEntry(INode iNode) {
        return this.iNodeParentMap.get(new INodeMapEntry(iNode, null));
    }

    private void buildINodeToParentMap() {
        this.iNodeParentMap = new HashMap(262144);
        LOG.info((Object)"Building INode to parent map.");
        INodeDirectory dir = this.getFSNamesystem().dir.rootDir;
        long numAdded = 1L + this.addToINodeParentMap(this.addINodeParentEntry(dir, null));
        LOG.info((Object)("Added " + numAdded + " entries to INode to parent map."));
    }

    synchronized boolean isUpgradeDone() {
        return this.upgradeStatus == UpgradeStatus.COMPLETED;
    }

    synchronized String printStatus(String spacing) {
        long errors = 0L;
        long totalCompletion = 0L;
        for (DnInfo dnInfo : this.dnMap.values()) {
            totalCompletion += (long)dnInfo.percentCompleted;
            errors += dnInfo.errors;
        }
        this.avgDatanodeCompletionPct = (double)totalCompletion / ((double)this.dnMap.size() + 1.0E-20);
        String msg = "Avg completion of all Datanodes: " + String.format("%.2f%%", this.avgDatanodeCompletionPct) + " with " + errors + " errors. " + (this.unfinishedDnMap.size() > 0 ? spacing + this.unfinishedDnMap.size() + " out of " + this.dnMap.size() + " nodes are not done." : "");
        LOG.info((Object)("Block CRC Upgrade is " + (this.isUpgradeDone() ? "complete. " : "still running. ") + spacing + msg));
        return msg;
    }

    private synchronized void setStatus(UpgradeStatus status) {
        this.upgradeStatus = status;
    }

    private synchronized UpgradeStatus checkOverallCompletion() {
        if (this.upgradeStatus == UpgradeStatus.COMPLETED || this.upgradeStatus == UpgradeStatus.DATANODES_DONE) {
            return this.upgradeStatus;
        }
        if (this.upgradeStatus != UpgradeStatus.DATANODES_DONE) {
            boolean datanodesDone;
            boolean bl = datanodesDone = this.dnMap.size() > 0 && this.unfinishedDnMap.size() == 0 && System.currentTimeMillis() - this.lastNodeCompletionTime > 10000L || this.forceDnCompletion;
            if (datanodesDone) {
                LOG.info((Object)("Upgrade of DataNode blocks is complete. " + (this.forceDnCompletion ? "(ForceDnCompletion is on.)" : "")));
                this.upgradeStatus = UpgradeStatus.DATANODES_DONE;
            }
        }
        if (this.upgradeStatus != UpgradeStatus.DATANODES_DONE && this.latestBlockLevelStats.updatedAt > 0L && this.latestBlockLevelStats.minimallyReplicatedBlocks == 0L && this.latestBlockLevelStats.underReplicatedBlocks == 0L) {
            LOG.info((Object)("Marking datanode upgrade complete since all the blocks are upgraded (even though some datanodes may not have reported completion. Block level stats :\n\t" + this.latestBlockLevelStats.statusString("\n\t")));
            this.upgradeStatus = UpgradeStatus.DATANODES_DONE;
        }
        return this.upgradeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBlockLevelStats(String path, BlockLevelStats stats) {
        DFSFileInfo[] fileArr;
        for (DFSFileInfo file : fileArr = this.getFSNamesystem().dir.getListing(path)) {
            if (file.isDir()) {
                this.updateBlockLevelStats(file.getPath().toString(), stats);
                continue;
            }
            LocatedBlocks blockLoc = null;
            try {
                blockLoc = this.getFSNamesystem().getBlockLocations(file.getPath().toString(), 0L, file.getLen());
                int numBlocks = blockLoc.locatedBlockCount();
                for (int i = 0; i < numBlocks; ++i) {
                    LocatedBlock loc = blockLoc.get(i);
                    DatanodeInfo[] dnArr = loc.getLocations();
                    int numUpgraded = 0;
                    BlockCrcUpgradeObjectNamenode blockCrcUpgradeObjectNamenode = this;
                    synchronized (blockCrcUpgradeObjectNamenode) {
                        for (DatanodeInfo dn : dnArr) {
                            DnInfo dnInfo = this.dnMap.get(dn);
                            if (dnInfo == null || !dnInfo.isDone()) continue;
                            ++numUpgraded;
                        }
                    }
                    if (numUpgraded >= file.getReplication()) {
                        ++stats.fullyReplicatedBlocks;
                    } else if (numUpgraded >= this.getFSNamesystem().getMinReplication()) {
                        ++stats.minimallyReplicatedBlocks;
                    } else {
                        ++stats.underReplicatedBlocks;
                    }
                    if (numUpgraded != 0) continue;
                    ++stats.unReplicatedBlocks;
                }
            }
            catch (IOException e) {
                LOG.error((Object)("BlockCrcUpgrade: could not get block locations for " + file.getPath().toString() + " : " + StringUtils.stringifyException(e)));
                ++stats.errors;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBlockLevelStats() {
        LOG.info((Object)"Starting update of block level stats. This could take a few minutes");
        BlockLevelStats stats = new BlockLevelStats();
        this.updateBlockLevelStats("/", stats);
        stats.updatedAt = System.currentTimeMillis();
        LOG.info((Object)("Block level stats:\n\t" + stats.statusString("\n\t")));
        BlockCrcUpgradeObjectNamenode blockCrcUpgradeObjectNamenode = this;
        synchronized (blockCrcUpgradeObjectNamenode) {
            this.latestBlockLevelStats = stats;
        }
    }

    private int deleteCrcFiles(String path) {
        String name;
        DFSFileInfo[] fileArr = this.getFSNamesystem().dir.getListing(path);
        int numFilesDeleted = 0;
        HashSet<String> fileSet = new HashSet<String>();
        for (DFSFileInfo file : fileArr) {
            name = file.getName();
            if (file.isDir() || name.startsWith(".") && name.endsWith(".crc")) continue;
            fileSet.add(name);
        }
        for (DFSFileInfo file : fileArr) {
            String dataFile;
            if (file.isDir()) continue;
            name = file.getName();
            int extraLen = ".".length() + ".crc".length();
            if (!name.startsWith(".") || !name.endsWith(".crc") || name.length() <= extraLen || !fileSet.contains(dataFile = name.substring(1, name.length() - extraLen + 1))) continue;
            String filepath = path + (path.endsWith("/") ? "" : "/") + name;
            try {
                LOG.debug((Object)("Deleting " + filepath));
                if (!this.getFSNamesystem().deleteInSafeMode(filepath)) continue;
                ++numFilesDeleted;
            }
            catch (IOException e) {
                LOG.error((Object)("Exception while deleting " + filepath + " : " + StringUtils.stringifyException(e)));
            }
        }
        fileSet = null;
        for (DFSFileInfo file : fileArr) {
            if (!file.isDir()) continue;
            numFilesDeleted += this.deleteCrcFiles(file.getPath().toString());
        }
        return numFilesDeleted;
    }

    int deleteCrcFiles() {
        LOG.info((Object)"Deleting \".crc\" files. This may take a few minutes ... ");
        int numFilesDeleted = this.deleteCrcFiles("/");
        LOG.info((Object)("Deleted " + numFilesDeleted + " \".crc\" files"));
        return 0;
    }

    private static class BlockLevelStats {
        long fullyReplicatedBlocks = 0L;
        long minimallyReplicatedBlocks = 0L;
        long underReplicatedBlocks = 0L;
        long unReplicatedBlocks = 0L;
        long errors;
        long updatedAt;

        private BlockLevelStats() {
        }

        String statusString(String spacing) {
            long totalBlocks = this.fullyReplicatedBlocks + this.minimallyReplicatedBlocks + this.underReplicatedBlocks;
            double multiplier = 100.0 / ((double)totalBlocks + 1.0E-20);
            if (spacing.equals("")) {
                spacing = ", ";
            }
            return String.format("Total Blocks : %d%sFully Upgragraded : %.2f%%%sMinimally Upgraded : %.2f%%%sUnder Upgraded : %.2f%% (includes Un-upgraded blocks)%sUn-upgraded : %.2f%%%sErrors : %d", totalBlocks, spacing, (double)this.fullyReplicatedBlocks * multiplier, spacing, (double)this.minimallyReplicatedBlocks * multiplier, spacing, (double)this.underReplicatedBlocks * multiplier, spacing, (double)this.unReplicatedBlocks * multiplier, spacing, this.errors);
        }
    }

    class UpgradeMonitor
    implements Runnable {
        static final long statusReportIntervalMillis = 60000L;
        static final long blockReportIntervalMillis = 300000L;
        static final int sleepTimeSec = 1;

        UpgradeMonitor() {
        }

        public void run() {
            long lastReportTime;
            long lastBlockReportTime = lastReportTime = System.currentTimeMillis();
            while (!BlockCrcUpgradeObjectNamenode.this.isUpgradeDone()) {
                long now;
                UpgradeStatus status = BlockCrcUpgradeObjectNamenode.this.checkOverallCompletion();
                if (status == UpgradeStatus.DATANODES_DONE) {
                    BlockCrcUpgradeObjectNamenode.this.deleteCrcFiles();
                    BlockCrcUpgradeObjectNamenode.this.setStatus(UpgradeStatus.COMPLETED);
                }
                if ((now = System.currentTimeMillis()) - lastBlockReportTime >= 300000L) {
                    BlockCrcUpgradeObjectNamenode.this.updateBlockLevelStats();
                    lastBlockReportTime = now;
                }
                if (now - lastReportTime >= 60000L || BlockCrcUpgradeObjectNamenode.this.isUpgradeDone()) {
                    BlockCrcUpgradeObjectNamenode.this.printStatus("\n\t");
                    lastReportTime = now;
                }
                BlockCrcUpgradeUtils.sleep(1, null);
            }
            LOG.info((Object)"Leaving the monitor thread");
        }
    }

    static class INodeMapEntry {
        INode iNode;
        INodeMapEntry parent;

        INodeMapEntry(INode iNode, INodeMapEntry parent) {
            this.iNode = iNode;
            this.parent = parent;
        }

        public int hashCode() {
            return System.identityHashCode(this.iNode);
        }

        public boolean equals(Object entry) {
            return entry instanceof INodeMapEntry && ((INodeMapEntry)entry).iNode == this.iNode;
        }

        private StringBuilder getName() {
            StringBuilder str = this.parent.parent == null ? new StringBuilder() : this.parent.getName();
            str.append("/");
            return str.append(this.iNode.getLocalName());
        }

        String getAbsoluteName() {
            return this.parent == null ? "/" : this.getName().toString();
        }

        INodeDirectory getParentINode() {
            return this.parent == null ? null : (INodeDirectory)this.parent.iNode;
        }
    }

    class DnInfo {
        short percentCompleted = 0;
        long blocksUpgraded = 0L;
        long blocksRemaining = 0L;
        long errors = 0L;

        DnInfo(short pcCompleted) {
            this.percentCompleted = BlockCrcUpgradeObjectNamenode.this.status;
        }

        DnInfo() {
        }

        void setStats(BlockCrcUpgradeUtils.DatanodeStatsCommand cmd) {
            this.percentCompleted = cmd.getCurrentStatus();
            this.blocksUpgraded = cmd.blocksUpgraded;
            this.blocksRemaining = cmd.blocksRemaining;
            this.errors = cmd.errors;
        }

        boolean isDone() {
            return this.percentCompleted >= 100;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UpgradeStatus {
        INITIALIZED,
        STARTED,
        DATANODES_DONE,
        COMPLETED;

    }
}

