/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import org.apache.hadoop.dfs.Block;

class BlockListAsLongs {
    private static final int LONGS_PER_BLOCK = 2;
    private long[] blockList;

    private static int index2BlockId(int index) {
        return index * 2;
    }

    private static int index2BlockLen(int index) {
        return index * 2 + 1;
    }

    static long[] convertToArrayLongs(Block[] blockArray) {
        long[] blocksAsLongs = new long[blockArray.length * 2];
        BlockListAsLongs bl = new BlockListAsLongs(blocksAsLongs);
        assert (bl.getNumberOfBlocks() == blockArray.length);
        for (int i = 0; i < blockArray.length; ++i) {
            bl.setBlock(i, blockArray[i]);
        }
        return blocksAsLongs;
    }

    BlockListAsLongs(long[] iBlockList) {
        if (iBlockList == null) {
            this.blockList = new long[0];
        } else {
            if (iBlockList.length % 2 != 0) {
                throw new IllegalArgumentException();
            }
            this.blockList = iBlockList;
        }
    }

    int getNumberOfBlocks() {
        return this.blockList.length / 2;
    }

    long getBlockId(int index) {
        return this.blockList[BlockListAsLongs.index2BlockId(index)];
    }

    long getBlockLen(int index) {
        return this.blockList[BlockListAsLongs.index2BlockLen(index)];
    }

    void setBlock(int index, Block b) {
        this.blockList[BlockListAsLongs.index2BlockId((int)index)] = b.getBlockId();
        this.blockList[BlockListAsLongs.index2BlockLen((int)index)] = b.getNumBytes();
    }
}

