/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlockListAsLongs;
import org.apache.hadoop.dfs.BlocksMap;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatanodeDescriptor
extends DatanodeInfo {
    private volatile BlocksMap.BlockInfo blockList = null;
    protected boolean isAlive = false;
    List<Block> replicateBlocks;
    List<DatanodeDescriptor[]> replicateTargetSets;
    Set<Block> invalidateBlocks;
    boolean processedBlockReport = false;
    private int currApproxBlocksScheduled = 0;
    private int prevApproxBlocksScheduled = 0;
    private long lastBlocksScheduledRollTime = 0L;
    private static final int BLOCKS_SCHEDULED_ROLL_INTERVAL = 300000;

    public DatanodeDescriptor() {
        this.initWorkLists();
    }

    public DatanodeDescriptor(DatanodeID nodeID) {
        this(nodeID, 0L, 0L, 0L, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation) {
        this(nodeID, networkLocation, null);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation, String hostName) {
        this(nodeID, networkLocation, hostName, 0L, 0L, 0L, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, long capacity, long dfsUsed, long remaining, int xceiverCount) {
        super(nodeID);
        this.updateHeartbeat(capacity, dfsUsed, remaining, xceiverCount);
        this.initWorkLists();
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation, String hostName, long capacity, long dfsUsed, long remaining, int xceiverCount) {
        super(nodeID, networkLocation, hostName);
        this.updateHeartbeat(capacity, dfsUsed, remaining, xceiverCount);
        this.initWorkLists();
    }

    private void initWorkLists() {
        this.replicateBlocks = new ArrayList<Block>();
        this.replicateTargetSets = new ArrayList<DatanodeDescriptor[]>();
        this.invalidateBlocks = new TreeSet<Block>();
    }

    boolean addBlock(BlocksMap.BlockInfo b) {
        if (!b.addNode(this)) {
            return false;
        }
        this.blockList = b.listInsert(this.blockList, this);
        return true;
    }

    boolean removeBlock(BlocksMap.BlockInfo b) {
        this.blockList = b.listRemove(this.blockList, this);
        return b.removeNode(this);
    }

    void moveBlockToHead(BlocksMap.BlockInfo b) {
        this.blockList = b.listRemove(this.blockList, this);
        this.blockList = b.listInsert(this.blockList, this);
    }

    void resetBlocks() {
        this.capacity = 0L;
        this.remaining = 0L;
        this.xceiverCount = 0;
        this.blockList = null;
    }

    int numBlocks() {
        return this.blockList == null ? 0 : this.blockList.listCount(this);
    }

    void updateHeartbeat(long capacity, long dfsUsed, long remaining, int xceiverCount) {
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
        this.lastUpdate = System.currentTimeMillis();
        this.xceiverCount = xceiverCount;
        this.rollBlocksScheduled(this.lastUpdate);
    }

    Iterator<Block> getBlockIterator() {
        return new BlockIterator(this.blockList, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlockToBeReplicated(Block block, DatanodeDescriptor[] targets) {
        assert (block != null && targets != null && targets.length > 0);
        List<Block> list = this.replicateBlocks;
        synchronized (list) {
            this.replicateBlocks.add(block);
            this.replicateTargetSets.add(targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlocksToBeInvalidated(List<Block> blocklist) {
        assert (blocklist != null && blocklist.size() > 0);
        Set<Block> set = this.invalidateBlocks;
        synchronized (set) {
            for (Block blk : blocklist) {
                this.invalidateBlocks.add(blk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfBlocksToBeReplicated() {
        List<Block> list = this.replicateBlocks;
        synchronized (list) {
            return this.replicateBlocks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfBlocksToBeInvalidated() {
        Set<Block> set = this.invalidateBlocks;
        synchronized (set) {
            return this.invalidateBlocks.size();
        }
    }

    void setBlockReportProcessed(boolean val) {
        this.processedBlockReport = val;
    }

    boolean getBlockReportProcessed() {
        return this.processedBlockReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getReplicationSets(int maxNumTransfers, Object[] xferResults) {
        assert (xferResults.length == 2);
        assert (xferResults[0] == null && xferResults[1] == null);
        List<Block> list = this.replicateBlocks;
        synchronized (list) {
            int i;
            assert (this.replicateBlocks.size() == this.replicateTargetSets.size());
            if (maxNumTransfers <= 0 || this.replicateBlocks.size() == 0) {
                return;
            }
            int numTransfers = 0;
            int numBlocks = 0;
            for (i = 0; i < this.replicateTargetSets.size() && numTransfers < maxNumTransfers; numTransfers += this.replicateTargetSets.get(i).length, ++i) {
            }
            numBlocks = i;
            Block[] blocklist = new Block[numBlocks];
            DatanodeDescriptor[][] targets = new DatanodeDescriptor[numBlocks][];
            for (i = 0; i < numBlocks; ++i) {
                blocklist[i] = this.replicateBlocks.get(0);
                targets[i] = this.replicateTargetSets.get(0);
                this.replicateBlocks.remove(0);
                this.replicateTargetSets.remove(0);
            }
            xferResults[0] = blocklist;
            xferResults[1] = targets;
            assert (blocklist.length > 0 && targets.length > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getInvalidateBlocks(int maxblocks, Object[] xferResults) {
        assert (xferResults[0] == null);
        Set<Block> set = this.invalidateBlocks;
        synchronized (set) {
            if (maxblocks <= 0 || this.invalidateBlocks.size() == 0) {
                return;
            }
            int outnum = Math.min(maxblocks, this.invalidateBlocks.size());
            Block[] blocklist = new Block[outnum];
            Iterator<Block> iter = this.invalidateBlocks.iterator();
            for (int i = 0; i < outnum; ++i) {
                blocklist[i] = iter.next();
                iter.remove();
            }
            assert (blocklist.length > 0);
            xferResults[0] = blocklist;
        }
    }

    void reportDiff(BlocksMap blocksMap, BlockListAsLongs newReport, Collection<Block> toAdd, Collection<Block> toRemove, Collection<Block> toInvalidate) {
        BlocksMap.BlockInfo delimiter = new BlocksMap.BlockInfo(new Block(), 1);
        boolean added = this.addBlock(delimiter);
        assert (added) : "Delimiting block cannot be present in the node";
        if (newReport == null) {
            newReport = new BlockListAsLongs(new long[0]);
        }
        Block iblk = new Block();
        for (int i = 0; i < newReport.getNumberOfBlocks(); ++i) {
            iblk.set(newReport.getBlockId(i), newReport.getBlockLen(i));
            BlocksMap.BlockInfo storedBlock = blocksMap.getStoredBlock(iblk);
            if (storedBlock == null) {
                toInvalidate.add(new Block(iblk));
                continue;
            }
            if (storedBlock.findDatanode(this) < 0) {
                toAdd.add(storedBlock);
                continue;
            }
            this.moveBlockToHead(storedBlock);
        }
        BlockIterator it = new BlockIterator(delimiter.getNext(0), this);
        while (it.hasNext()) {
            toRemove.add((Block)it.next());
        }
        this.removeBlock(delimiter);
    }

    int getBlocksScheduled() {
        return this.currApproxBlocksScheduled + this.prevApproxBlocksScheduled;
    }

    void incBlocksScheduled() {
        ++this.currApproxBlocksScheduled;
    }

    void decBlocksScheduled() {
        if (this.prevApproxBlocksScheduled > 0) {
            --this.prevApproxBlocksScheduled;
        } else if (this.currApproxBlocksScheduled > 0) {
            --this.currApproxBlocksScheduled;
        }
    }

    private void rollBlocksScheduled(long now) {
        if (now - this.lastBlocksScheduledRollTime > 300000L) {
            this.prevApproxBlocksScheduled = this.currApproxBlocksScheduled;
            this.currApproxBlocksScheduled = 0;
            this.lastBlocksScheduledRollTime = now;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockIterator
    implements Iterator<Block> {
        private BlocksMap.BlockInfo current;
        private DatanodeDescriptor node;

        BlockIterator(BlocksMap.BlockInfo head, DatanodeDescriptor dn) {
            this.current = head;
            this.node = dn;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public BlocksMap.BlockInfo next() {
            BlocksMap.BlockInfo res = this.current;
            this.current = this.current.getNext(this.current.findDatanode(this.node));
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }
}

