/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DfsPath;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class DistributedFileSystem
extends FileSystem {
    private Path workingDir;
    private URI uri;
    DFSClient dfs;
    private boolean verifyChecksum = true;

    public DistributedFileSystem() {
    }

    public DistributedFileSystem(InetSocketAddress namenode, Configuration conf) throws IOException {
        this.initialize(URI.create("hdfs://" + namenode.getHostName() + ":" + namenode.getPort()), conf);
    }

    public String getName() {
        return this.uri.getAuthority();
    }

    public URI getUri() {
        return this.uri;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        this.setConf(conf);
        String host = uri.getHost();
        int port = uri.getPort();
        if (host == null || port == -1) {
            throw new IOException("Incomplete HDFS URI, no host/port: " + uri);
        }
        this.dfs = new DFSClient(new InetSocketAddress(host, port), conf, this.statistics);
        this.uri = URI.create("hdfs://" + host + ":" + port);
        this.workingDir = this.getHomeDirectory();
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public long getDefaultBlockSize() {
        return this.dfs.getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return this.dfs.getDefaultReplication();
    }

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    public void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!FSNamesystem.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    public Path getHomeDirectory() {
        return new Path("/user/" + this.dfs.ugi.getUserName()).makeQualified(this);
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = this.makeAbsolute(file).toUri().getPath();
        if (!FSNamesystem.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
        }
        return result;
    }

    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException {
        return this.dfs.getBlockLocations(this.getPathName(f), start, len);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return new DFSClient.DFSDataInputStream(this.dfs.open(this.getPathName(f), bufferSize, this.verifyChecksum, this.statistics));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new FSDataOutputStream(this.dfs.create(this.getPathName(f), permission, overwrite, replication, blockSize, progress, bufferSize), this.statistics);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.dfs.setReplication(this.getPathName(src), replication);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.dfs.rename(this.getPathName(src), this.getPathName(dst));
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.dfs.delete(this.getPathName(f));
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.dfs.delete(this.getPathName(f), recursive);
    }

    @Deprecated
    public long getContentLength(Path f) throws IOException {
        DfsPath dfspath;
        if (f instanceof DfsPath && !(dfspath = (DfsPath)f).isDirectory()) {
            return dfspath.getContentsLength();
        }
        return this.getContentSummary(f).getLength();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.dfs.getContentSummary(this.getPathName(f));
    }

    public FileStatus[] listStatus(Path p) throws IOException {
        DFSFileInfo[] infos = this.dfs.listPaths(this.getPathName(p));
        if (infos == null) {
            return null;
        }
        FileStatus[] stats = new FileStatus[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            DFSFileInfo f = infos[i];
            stats[i] = new FileStatus(f.getLen(), f.isDir(), f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getPermission(), f.getOwner(), f.getGroup(), new DfsPath(f, this));
        }
        return stats;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.dfs.mkdirs(this.getPathName(f), permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.dfs.close();
        }
        finally {
            super.close();
        }
    }

    public String toString() {
        return "DFS[" + this.dfs + "]";
    }

    DFSClient getClient() {
        return this.dfs;
    }

    public DiskStatus getDiskStatus() throws IOException {
        return this.dfs.getDiskStatus();
    }

    public long getRawCapacity() throws IOException {
        return this.dfs.totalRawCapacity();
    }

    public long getRawUsed() throws IOException {
        return this.dfs.totalRawUsed();
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        return this.dfs.datanodeReport(FSConstants.DatanodeReportType.ALL);
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.dfs.setSafeMode(action);
    }

    public void refreshNodes() throws IOException {
        this.dfs.refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        this.dfs.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.dfs.distributedUpgradeProgress(action);
    }

    public void metaSave(String pathname) throws IOException {
        this.dfs.metaSave(pathname);
    }

    public boolean reportChecksumFailure(Path f, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        LocatedBlock[] lblocks = new LocatedBlock[2];
        DFSClient.DFSDataInputStream dfsIn = (DFSClient.DFSDataInputStream)in;
        Block dataBlock = dfsIn.getCurrentBlock();
        if (dataBlock == null) {
            LOG.error((Object)"Error: Current block in data stream is null! ");
            return false;
        }
        DatanodeInfo[] dataNode = new DatanodeInfo[]{dfsIn.getCurrentDatanode()};
        lblocks[0] = new LocatedBlock(dataBlock, dataNode);
        LOG.info((Object)("Found checksum error in data stream at block=" + dataBlock.getBlockName() + " on datanode=" + dataNode[0].getName()));
        DFSClient.DFSDataInputStream dfsSums = (DFSClient.DFSDataInputStream)sums;
        Block sumsBlock = dfsSums.getCurrentBlock();
        if (sumsBlock == null) {
            LOG.error((Object)"Error: Current block in checksum stream is null! ");
            return false;
        }
        DatanodeInfo[] sumsNode = new DatanodeInfo[]{dfsSums.getCurrentDatanode()};
        lblocks[1] = new LocatedBlock(sumsBlock, sumsNode);
        LOG.info((Object)("Found checksum error in checksum stream at block=" + sumsBlock.getBlockName() + " on datanode=" + sumsNode[0].getName()));
        this.dfs.reportChecksumFailure(f.toString(), lblocks);
        return true;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        if (f instanceof DfsPath) {
            DfsPath p = (DfsPath)f;
            return p.info;
        }
        DFSFileInfo fs = this.dfs.getFileInfo(this.getPathName(f));
        if (fs != null) {
            return fs;
        }
        throw new FileNotFoundException("File does not exist: " + f);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.dfs.setPermission(this.getPathName(p), permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        this.dfs.setOwner(this.getPathName(p), username, groupname);
    }

    public static class DiskStatus {
        private long capacity;
        private long dfsUsed;
        private long remaining;

        public DiskStatus(long capacity, long dfsUsed, long remaining) {
            this.capacity = capacity;
            this.dfsUsed = dfsUsed;
            this.remaining = remaining;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public long getDfsUsed() {
            return this.dfsUsed;
        }

        public long getRemaining() {
            return this.remaining;
        }
    }
}

