/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlocksMap;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.dfs.INodeDirectory;
import org.apache.hadoop.dfs.INodeFile;
import org.apache.hadoop.dfs.INodeFileUnderConstruction;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSDirectory
implements FSConstants {
    FSNamesystem namesystem = null;
    final INodeDirectory rootDir;
    FSImage fsImage;
    boolean ready = false;
    private MetricsRecord directoryMetrics = null;
    private volatile long totalInodes = 1L;

    public FSDirectory(FSNamesystem ns, Configuration conf) throws IOException {
        this(new FSImage(), ns, conf);
    }

    public FSDirectory(FSImage fsImage, FSNamesystem ns, Configuration conf) throws IOException {
        this.rootDir = new INodeDirectory("", ns.createFsOwnerPermissions(new FsPermission(493)));
        this.fsImage = fsImage;
        this.namesystem = ns;
        this.initialize(conf);
    }

    private void initialize(Configuration conf) {
        MetricsContext metricsContext = MetricsUtil.getContext("dfs");
        this.directoryMetrics = MetricsUtil.createRecord(metricsContext, "FSDirectory");
        this.directoryMetrics.setTag("sessionId", conf.get("session.id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFSImage(Collection<File> dataDirs, FSConstants.StartupOption startOpt) throws IOException {
        if (startOpt == FSConstants.StartupOption.FORMAT) {
            this.fsImage.setStorageDirectories(dataDirs);
            this.fsImage.format();
            startOpt = FSConstants.StartupOption.REGULAR;
        }
        try {
            this.fsImage.recoverTransitionRead(dataDirs, startOpt);
        }
        catch (IOException e) {
            this.fsImage.close();
            throw e;
        }
        FSDirectory fSDirectory = this;
        synchronized (fSDirectory) {
            this.ready = true;
            this.notifyAll();
        }
    }

    private void incrDeletedFileCount(int count) {
        this.directoryMetrics.incrMetric("files_deleted", count);
        this.directoryMetrics.update();
    }

    public void close() throws IOException {
        this.fsImage.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReady() {
        if (!this.ready) {
            FSDirectory fSDirectory = this;
            synchronized (fSDirectory) {
                while (!this.ready) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode addFile(String path, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine, DatanodeDescriptor clientNode, long generationStamp) throws IOException {
        this.waitForReady();
        long modTime = FSNamesystem.now();
        if (!this.mkdirs(new Path(path).getParent().toString(), permissions, true, modTime)) {
            return null;
        }
        INodeFileUnderConstruction newNode = new INodeFileUnderConstruction(permissions, replication, preferredBlockSize, modTime, clientName, clientMachine, clientNode);
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            try {
                newNode = this.rootDir.addNode(path, newNode);
            }
            catch (FileNotFoundException e) {
                newNode = null;
            }
            if (newNode != null) {
                ++this.totalInodes;
            }
        }
        if (newNode == null) {
            NameNode.stateChangeLog.info((Object)("DIR* FSDirectory.addFile: failed to add " + path + " to the file system"));
            return null;
        }
        this.fsImage.getEditLog().logOpenFile(path, newNode);
        this.fsImage.getEditLog().logGenerationStamp(generationStamp);
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " is added to the file system"));
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedAddFile(String path, PermissionStatus permissions, Block[] blocks, short replication, long modificationTime, long preferredBlockSize) {
        INode newNode = blocks == null ? new INodeDirectory(permissions, modificationTime) : new INodeFile(permissions, blocks.length, replication, modificationTime, preferredBlockSize);
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            try {
                newNode = this.rootDir.addNode(path, newNode);
                if (newNode != null && blocks != null) {
                    int nrBlocks = blocks.length;
                    INodeFile newF = (INodeFile)newNode;
                    for (int i = 0; i < nrBlocks; ++i) {
                        newF.setBlock(i, this.namesystem.blocksMap.addINode(blocks[i], newF));
                    }
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            if (newNode != null) {
                ++this.totalInodes;
            }
            return newNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block addBlock(String path, INode file, Block block) throws IOException {
        this.waitForReady();
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INodeFile fileNode = (INodeFile)file;
            this.namesystem.blocksMap.addINode(block, fileNode);
            BlocksMap.BlockInfo blockInfo = this.namesystem.blocksMap.getStoredBlock(block);
            fileNode.addBlock(blockInfo);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the in-memory " + "file system"));
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBlocks(String path, INodeFileUnderConstruction file) throws IOException {
        this.waitForReady();
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            this.fsImage.getEditLog().logOpenFile(path, file);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.persistBlocks: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFile(String path, INode file) throws IOException {
        this.waitForReady();
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INodeFile fileNode = (INodeFile)file;
            this.fsImage.getEditLog().logCloseFile(path, fileNode);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.closeFile: " + path + " with " + fileNode.getBlocks().length + " blocks is persisted to the file system"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBlock(String path, INodeFileUnderConstruction fileNode, Block block) throws IOException {
        this.waitForReady();
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            fileNode.removeBlock(block);
            this.namesystem.blocksMap.removeINode(block);
            fileNode.setLastBlockLocations(new DatanodeDescriptor[0]);
            this.fsImage.getEditLog().logOpenFile(path, fileNode);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the file system"));
        }
        return true;
    }

    public boolean renameTo(String src, String dst) {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.renameTo: " + src + " to " + dst));
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        if (!this.unprotectedRenameTo(src, dst, now)) {
            return false;
        }
        this.fsImage.getEditLog().logRename(src, dst, now);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unprotectedRenameTo(String src, String dst, long timestamp) {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode renamedNode = this.rootDir.getNode(src);
            if (renamedNode == null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source does not exist"));
                return false;
            }
            if (this.isDir(dst)) {
                dst = dst + "/" + new Path(src).getName();
            }
            if (this.rootDir.getNode(dst) != null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists"));
                return false;
            }
            INodeDirectory oldParent = renamedNode.getParent();
            oldParent.removeChild(renamedNode);
            try {
                if (this.rootDir.addNode(dst, renamedNode) != null) {
                    NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst));
                    oldParent.setModificationTime(timestamp);
                    renamedNode.getParent().setModificationTime(timestamp);
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst));
                try {
                    this.rootDir.addNode(src, renamedNode);
                }
                catch (FileNotFoundException e2) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    Block[] setReplication(String src, short replication, int[] oldReplication) throws IOException {
        this.waitForReady();
        Block[] fileBlocks = this.unprotectedSetReplication(src, replication, oldReplication);
        if (fileBlocks != null) {
            this.fsImage.getEditLog().logSetReplication(src, replication);
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] unprotectedSetReplication(String src, short replication, int[] oldReplication) throws IOException {
        if (oldReplication == null) {
            oldReplication = new int[]{-1};
        }
        Block[] fileBlocks = null;
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                return null;
            }
            if (inode.isDirectory()) {
                return null;
            }
            INodeFile fileNode = (INodeFile)inode;
            oldReplication[0] = fileNode.getReplication();
            fileNode.setReplication(replication);
            fileBlocks = fileNode.getBlocks();
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPreferredBlockSize(String filename) throws IOException {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode fileNode = this.rootDir.getNode(filename);
            if (fileNode == null) {
                throw new IOException("Unknown file: " + filename);
            }
            if (fileNode.isDirectory()) {
                throw new IOException("Getting block size of a directory: " + filename);
            }
            return ((INodeFile)fileNode).getPreferredBlockSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exists(String src) {
        src = this.normalizePath(src);
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                return false;
            }
            return inode.isDirectory() ? true : ((INodeFile)inode).getBlocks() != null;
        }
    }

    void setPermission(String src, FsPermission permission) throws IOException {
        this.unprotectedSetPermission(src, permission);
        this.fsImage.getEditLog().logSetPermissions(src, permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetPermission(String src, FsPermission permissions) throws FileNotFoundException {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            inode.setPermission(permissions);
        }
    }

    void setOwner(String src, String username, String groupname) throws IOException {
        this.unprotectedSetOwner(src, username, groupname);
        this.fsImage.getEditLog().logSetOwner(src, username, groupname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetOwner(String src, String username, String groupname) throws FileNotFoundException {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            if (username != null) {
                inode.setUser(username);
            }
            if (groupname != null) {
                inode.setGroup(groupname);
            }
        }
    }

    public INode delete(String src, Collection<Block> deletedBlocks) {
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.delete: " + src));
        this.waitForReady();
        long now = FSNamesystem.now();
        INode deletedNode = this.unprotectedDelete(src, now, deletedBlocks);
        if (deletedNode != null) {
            this.fsImage.getEditLog().logDelete(src, now);
        }
        return deletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirEmpty(String src) {
        boolean dirNotEmpty = true;
        if (!this.isDir(src)) {
            return true;
        }
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode targetNode = this.rootDir.getNode(src);
            assert (targetNode != null) : "should be taken care in isDir() above";
            if (((INodeDirectory)targetNode).getChildren().size() != 0) {
                dirNotEmpty = false;
            }
        }
        return dirNotEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedDelete(String src, long modificationTime, Collection<Block> deletedBlocks) {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode targetNode = this.rootDir.getNode(src);
            if (targetNode == null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist"));
                return null;
            }
            if (!targetNode.removeNode()) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not have a parent"));
                return null;
            }
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: " + src + " is removed"));
            targetNode.getParent().setModificationTime(modificationTime);
            ArrayList<Block> v = new ArrayList<Block>();
            int filesRemoved = targetNode.collectSubtreeBlocks(v);
            this.incrDeletedFileCount(filesRemoved);
            this.totalInodes -= (long)filesRemoved;
            for (Block b : v) {
                this.namesystem.blocksMap.removeINode(b);
                if (deletedBlocks == null) continue;
                deletedBlocks.add(b);
            }
            return targetNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceNode(String path, INodeFile oldnode, INodeFile newnode) throws IOException {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            if (!oldnode.removeNode()) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.replaceNode: failed to remove " + path));
                throw new IOException("FSDirectory.replaceNode: failed to remove " + path);
            }
            this.rootDir.addNode(path, newnode);
            for (BlocksMap.BlockInfo b : newnode.getBlocks()) {
                this.namesystem.blocksMap.addINode(b, newnode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DFSFileInfo[] getListing(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                return null;
            }
            if (!targetNode.isDirectory()) {
                return new DFSFileInfo[]{new DFSFileInfo(srcs, targetNode)};
            }
            List<INode> contents = ((INodeDirectory)targetNode).getChildren();
            DFSFileInfo[] listing = new DFSFileInfo[contents.size()];
            if (!srcs.endsWith("/")) {
                srcs = srcs + "/";
            }
            int i = 0;
            for (INode cur : contents) {
                listing[i] = new DFSFileInfo(srcs + cur.getLocalName(), cur);
                ++i;
            }
            return listing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DFSFileInfo getFileInfo(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                return null;
            }
            return new DFSFileInfo(srcs, targetNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] getFileBlocks(String src) {
        this.waitForReady();
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode targetNode = this.rootDir.getNode(src);
            if (targetNode == null) {
                return null;
            }
            if (targetNode.isDirectory()) {
                return null;
            }
            return ((INodeFile)targetNode).getBlocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFile getFileINode(String src) {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null || inode.isDirectory()) {
                return null;
            }
            return (INodeFile)inode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidToCreate(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            return srcs.startsWith("/") && !srcs.endsWith("/") && this.rootDir.getNode(srcs) == null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDir(String src) {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode node = this.rootDir.getNode(this.normalizePath(src));
            return node != null && node.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mkdirs(String src, PermissionStatus permissions, boolean inheritPermission, long now) throws IOException {
        src = this.normalizePath(src);
        String[] names = INode.getPathNames(src);
        byte[][] components = INode.getPathComponents(names);
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            int i;
            INode[] inodes = new INode[components.length];
            this.rootDir.getExistingPathINodes(components, inodes);
            StringBuilder pathbuilder = new StringBuilder();
            for (i = 1; i < inodes.length && inodes[i] != null; ++i) {
                pathbuilder.append("/" + names[i]);
                if (inodes[i].isDirectory()) continue;
                throw new FileNotFoundException("Parent path is not a directory: " + pathbuilder);
            }
            while (i < inodes.length) {
                pathbuilder.append("/" + names[i]);
                String cur = pathbuilder.toString();
                inodes[i] = new INodeDirectory(permissions, now);
                inodes[i].name = components[i];
                INode inserted = ((INodeDirectory)inodes[i - 1]).addChild(inodes[i], inheritPermission || i != inodes.length - 1);
                assert (inserted == inodes[i]);
                ++this.totalInodes;
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.mkdirs: created directory " + cur));
                this.fsImage.getEditLog().logMkDir(cur, inserted);
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedMkdir(String src, PermissionStatus permissions, boolean inheritPermission, long timestamp) throws FileNotFoundException {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INodeDirectory newNode = this.rootDir.addNode(src, new INodeDirectory(permissions, timestamp), inheritPermission);
            if (newNode != null) {
                ++this.totalInodes;
            }
            return newNode;
        }
    }

    String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws IOException {
        String srcs = this.normalizePath(src);
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + srcs);
            }
            return targetNode.computeContentSummary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long totalInodes() {
        INodeDirectory iNodeDirectory = this.rootDir;
        synchronized (iNodeDirectory) {
            return this.totalInodes;
        }
    }
}

