/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.FSDirectory;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.dfs.INodeFile;
import org.apache.hadoop.dfs.INodeFileUnderConstruction;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.NameNodeMetrics;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSEditLog {
    private static final byte OP_ADD = 0;
    private static final byte OP_RENAME = 1;
    private static final byte OP_DELETE = 2;
    private static final byte OP_MKDIR = 3;
    private static final byte OP_SET_REPLICATION = 4;
    @Deprecated
    private static final byte OP_DATANODE_ADD = 5;
    @Deprecated
    private static final byte OP_DATANODE_REMOVE = 6;
    private static final byte OP_SET_PERMISSIONS = 7;
    private static final byte OP_SET_OWNER = 8;
    private static final byte OP_CLOSE = 9;
    private static final byte OP_SET_GENSTAMP = 10;
    private static int sizeFlushBuffer = 524288;
    private ArrayList<EditLogOutputStream> editStreams = null;
    private FSImage fsimage = null;
    private long txid = 0L;
    private long synctxid = 0L;
    private long lastPrintTime;
    private boolean isSyncRunning;
    private long numTransactions;
    private long totalTimeTransactions;
    private NameNodeMetrics metrics;
    private static final ThreadLocal<TransactionId> myTransactionId = new ThreadLocal<TransactionId>(){

        @Override
        protected synchronized TransactionId initialValue() {
            return new TransactionId(Long.MAX_VALUE);
        }
    };

    FSEditLog(FSImage image) {
        this.fsimage = image;
        this.isSyncRunning = false;
        this.metrics = NameNode.getNameNodeMetrics();
        this.lastPrintTime = FSNamesystem.now();
    }

    private File getEditFile(int idx) {
        return this.fsimage.getEditFile(idx);
    }

    private File getEditNewFile(int idx) {
        return this.fsimage.getEditNewFile(idx);
    }

    private int getNumStorageDirs() {
        return this.fsimage.getNumStorageDirs();
    }

    synchronized int getNumEditStreams() {
        return this.editStreams == null ? 0 : this.editStreams.size();
    }

    boolean isOpen() {
        return this.getNumEditStreams() > 0;
    }

    synchronized void open() throws IOException {
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        int size = this.getNumStorageDirs();
        if (this.editStreams == null) {
            this.editStreams = new ArrayList(size);
        }
        for (int idx = 0; idx < size; ++idx) {
            File eFile = this.getEditFile(idx);
            try {
                EditLogOutputStream eStream = new EditLogOutputStream(eFile);
                this.editStreams.add(eStream);
                continue;
            }
            catch (IOException e) {
                FSNamesystem.LOG.warn((Object)("Unable to open edit log file " + eFile));
                this.fsimage.processIOError(idx);
                --idx;
            }
        }
    }

    synchronized void createEditLogFile(File name) throws IOException {
        EditLogOutputStream eStream = new EditLogOutputStream(name);
        eStream.create();
        eStream.close();
    }

    synchronized void createNewIfMissing() throws IOException {
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            File newFile = this.getEditNewFile(idx);
            if (newFile.exists()) continue;
            this.createEditLogFile(newFile);
        }
    }

    synchronized void close() throws IOException {
        while (this.isSyncRunning) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException ie) {}
        }
        if (this.editStreams == null) {
            return;
        }
        this.printStatistics(true);
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.flushAndSync();
                eStream.close();
                continue;
            }
            catch (IOException e) {
                this.processIOError(idx);
                --idx;
            }
        }
        this.editStreams.clear();
    }

    synchronized void processIOError(int index) {
        if (this.editStreams == null || this.editStreams.size() <= 1) {
            FSNamesystem.LOG.fatal((Object)"Fatal Error : All storage directories are inaccessible.");
            Runtime.getRuntime().exit(-1);
        }
        assert (index < this.getNumStorageDirs());
        assert (this.getNumStorageDirs() == this.editStreams.size());
        this.editStreams.remove(index);
        this.fsimage.processIOError(index);
    }

    private void processIOError(ArrayList<EditLogOutputStream> errorStreams) {
        if (errorStreams == null) {
            return;
        }
        for (int idx = 0; idx < errorStreams.size(); ++idx) {
            EditLogOutputStream eStream = errorStreams.get(idx);
            int j = 0;
            for (j = 0; j < this.editStreams.size() && this.editStreams.get(j) != eStream; ++j) {
            }
            if (j == this.editStreams.size()) {
                FSNamesystem.LOG.error((Object)"Unable to find sync log on which  IO error occured. Fatal Error.");
                Runtime.getRuntime().exit(-1);
            }
            this.processIOError(j);
        }
        int failedStreamIdx = 0;
        while (failedStreamIdx >= 0) {
            failedStreamIdx = this.fsimage.incrementCheckpointTime();
            if (failedStreamIdx < 0) continue;
            this.processIOError(failedStreamIdx);
        }
    }

    boolean existsNew() throws IOException {
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            if (!this.getEditNewFile(idx).exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int loadFSEdits(File edits) throws IOException {
        int logVersion;
        int numEdits;
        block51: {
            FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
            FSDirectory fsDir = fsNamesys.dir;
            numEdits = 0;
            logVersion = 0;
            INode old = null;
            String clientName = null;
            String clientMachine = null;
            DatanodeDescriptor[] lastLocations = null;
            if (edits != null) {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(edits)));
                in.mark(4);
                boolean available = true;
                try {
                    logVersion = in.readByte();
                }
                catch (EOFException e) {
                    available = false;
                }
                if (available) {
                    in.reset();
                    logVersion = logVersion >= 0 ? 0 : in.readInt();
                    if (logVersion < -13) {
                        throw new IOException("Unexpected version of the file system log file: " + logVersion + ". Current version = " + -13 + ".");
                    }
                }
                short replication = fsNamesys.getDefaultReplication();
                try {
                    int opcode;
                    block19: while (true) {
                        long timestamp = 0L;
                        long mtime = 0L;
                        long blockSize = 0L;
                        opcode = -1;
                        try {
                            opcode = in.readByte();
                        }
                        catch (EOFException e) {
                            break block51;
                        }
                        ++numEdits;
                        switch (opcode) {
                            case 0: 
                            case 9: {
                                INodeFileUnderConstruction cons;
                                Writable[] writables;
                                UTF8 name = new UTF8();
                                String path = null;
                                ArrayWritable aw = null;
                                if (logVersion >= 0) {
                                    name.readFields(in);
                                } else {
                                    aw = new ArrayWritable(UTF8.class);
                                    aw.readFields(in);
                                    writables = aw.get();
                                    if (-4 <= logVersion && writables.length != 2 || -7 <= logVersion && logVersion < -4 && writables.length != 3 || logVersion < -7 && writables.length != 4) {
                                        throw new IOException("Incorrect data format. logVersion is " + logVersion + " but writables.length is " + writables.length + ". ");
                                    }
                                    name = (UTF8)writables[0];
                                    path = name.toString();
                                    replication = Short.parseShort(((UTF8)writables[1]).toString());
                                    replication = FSEditLog.adjustReplication(replication);
                                    if (logVersion < -4) {
                                        mtime = Long.parseLong(((UTF8)writables[2]).toString());
                                    }
                                    if (logVersion < -7) {
                                        blockSize = Long.parseLong(((UTF8)writables[3]).toString());
                                    }
                                }
                                aw = new ArrayWritable(Block.class);
                                aw.readFields(in);
                                writables = aw.get();
                                Block[] blocks = new Block[writables.length];
                                System.arraycopy(writables, 0, blocks, 0, blocks.length);
                                if (-8 <= logVersion && blockSize == 0L) {
                                    if (blocks.length > 1) {
                                        blockSize = blocks[0].getNumBytes();
                                    } else {
                                        long first = blocks.length == 1 ? blocks[0].getNumBytes() : 0L;
                                        blockSize = Math.max(fsNamesys.getDefaultBlockSize(), first);
                                    }
                                }
                                PermissionStatus permissions = fsNamesys.getUpgradePermission();
                                if (logVersion <= -11) {
                                    permissions = PermissionStatus.read(in);
                                }
                                clientName = "";
                                clientMachine = "";
                                lastLocations = null;
                                if (opcode == 0 && logVersion <= -12) {
                                    UTF8 uu = new UTF8();
                                    UTF8 cl = new UTF8();
                                    aw = new ArrayWritable(DatanodeDescriptor.class);
                                    uu.readFields(in);
                                    cl.readFields(in);
                                    aw.readFields(in);
                                    clientName = uu.toString();
                                    clientMachine = cl.toString();
                                    writables = aw.get();
                                    lastLocations = new DatanodeDescriptor[writables.length];
                                    System.arraycopy(writables, 0, lastLocations, 0, writables.length);
                                } else {
                                    lastLocations = new DatanodeDescriptor[]{};
                                }
                                if (FSNamesystem.LOG.isDebugEnabled()) {
                                    FSNamesystem.LOG.debug((Object)(opcode + ": " + name.toString() + " numblocks : " + blocks.length + " clientHolder " + clientName + " clientMachine " + clientMachine));
                                }
                                old = fsDir.unprotectedDelete(path, mtime, null);
                                INodeFile node = (INodeFile)fsDir.unprotectedAddFile(path, permissions, blocks, replication, mtime, blockSize);
                                if (opcode == 0) {
                                    cons = new INodeFileUnderConstruction(INode.string2Bytes(node.getLocalName()), node.getReplication(), node.getModificationTime(), node.getPreferredBlockSize(), node.getBlocks(), node.getPermissionStatus(), clientName, clientMachine, null, lastLocations);
                                    fsDir.replaceNode(path, node, cons);
                                    fsNamesys.addLease(path, clientName);
                                    continue block19;
                                }
                                if (opcode != 9 || !old.isUnderConstruction()) continue block19;
                                cons = (INodeFileUnderConstruction)old;
                                fsNamesys.removeLease(path, cons.getClientName());
                                continue block19;
                            }
                            case 4: {
                                UTF8 src = new UTF8();
                                UTF8 repl = new UTF8();
                                src.readFields(in);
                                repl.readFields(in);
                                replication = FSEditLog.adjustReplication(FSEditLog.fromLogReplication(repl));
                                fsDir.unprotectedSetReplication(src.toString(), replication, null);
                                continue block19;
                            }
                            case 1: {
                                Writable[] writables;
                                ArrayWritable aw;
                                UTF8 src = null;
                                UTF8 dst = null;
                                if (logVersion >= -4) {
                                    src = new UTF8();
                                    dst = new UTF8();
                                    src.readFields(in);
                                    dst.readFields(in);
                                } else {
                                    aw = null;
                                    aw = new ArrayWritable(UTF8.class);
                                    aw.readFields(in);
                                    writables = aw.get();
                                    if (writables.length != 3) {
                                        throw new IOException("Incorrect data format. Mkdir operation.");
                                    }
                                    src = (UTF8)writables[0];
                                    dst = (UTF8)writables[1];
                                    timestamp = Long.parseLong(((UTF8)writables[2]).toString());
                                }
                                fsDir.unprotectedRenameTo(src.toString(), dst.toString(), timestamp);
                                continue block19;
                            }
                            case 2: {
                                UTF8 src = null;
                                if (logVersion >= -4) {
                                    src = new UTF8();
                                    src.readFields(in);
                                } else {
                                    ArrayWritable aw = null;
                                    aw = new ArrayWritable(UTF8.class);
                                    aw.readFields(in);
                                    Writable[] writables = aw.get();
                                    if (writables.length != 2) {
                                        throw new IOException("Incorrect data format. delete operation.");
                                    }
                                    src = (UTF8)writables[0];
                                    timestamp = Long.parseLong(((UTF8)writables[1]).toString());
                                }
                                if ((old = fsDir.unprotectedDelete(src.toString(), timestamp, null)) == null || !old.isUnderConstruction()) continue block19;
                                INodeFileUnderConstruction cons = (INodeFileUnderConstruction)old;
                                fsNamesys.removeLease(src.toString(), cons.getClientName());
                                continue block19;
                            }
                            case 3: {
                                Writable[] writables;
                                ArrayWritable aw;
                                UTF8 src = null;
                                PermissionStatus permissions = fsNamesys.getUpgradePermission();
                                if (logVersion >= -4) {
                                    src = new UTF8();
                                    src.readFields(in);
                                } else {
                                    aw = null;
                                    aw = new ArrayWritable(UTF8.class);
                                    aw.readFields(in);
                                    writables = aw.get();
                                    if (writables.length != 2) {
                                        throw new IOException("Incorrect data format. Mkdir operation.");
                                    }
                                    src = (UTF8)writables[0];
                                    timestamp = Long.parseLong(((UTF8)writables[1]).toString());
                                    if (logVersion <= -11) {
                                        permissions = PermissionStatus.read(in);
                                    }
                                }
                                fsDir.unprotectedMkdir(src.toString(), permissions, false, timestamp);
                                continue block19;
                            }
                            case 10: {
                                LongWritable aw = new LongWritable();
                                aw.readFields(in);
                                fsDir.namesystem.setGenerationStamp(aw.get());
                                continue block19;
                            }
                            case 5: {
                                if (logVersion > -3) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                FSImage.DatanodeImage nodeimage = new FSImage.DatanodeImage();
                                nodeimage.readFields(in);
                                continue block19;
                            }
                            case 6: {
                                if (logVersion > -3) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                DatanodeID nodeID = new DatanodeID();
                                nodeID.readFields(in);
                                continue block19;
                            }
                            case 7: {
                                if (logVersion > -11) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                fsDir.unprotectedSetPermission(this.readUTF8String(in), FsPermission.read(in));
                                continue block19;
                            }
                            case 8: {
                                if (logVersion > -11) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                fsDir.unprotectedSetOwner(this.readUTF8String(in), this.readUTF8String(in), this.readUTF8String(in));
                                continue block19;
                            }
                        }
                        break;
                    }
                    throw new IOException("Never seen opcode " + opcode);
                }
                finally {
                    in.close();
                }
            }
        }
        if (logVersion != -13) {
            ++numEdits;
        }
        return numEdits;
    }

    private String readUTF8String(DataInputStream in) throws IOException {
        UTF8 utf8 = new UTF8();
        utf8.readFields(in);
        String s = utf8.toString();
        return s.length() == 0 ? null : s;
    }

    static short adjustReplication(short replication) {
        short maxReplication;
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        short minReplication = fsNamesys.getMinReplication();
        if (replication < minReplication) {
            replication = minReplication;
        }
        if (replication > (maxReplication = fsNamesys.getMaxReplication())) {
            replication = maxReplication;
        }
        return replication;
    }

    synchronized void logEdit(byte op, Writable ... writables) {
        assert (this.getNumEditStreams() > 0) : "no editlog streams";
        long start = FSNamesystem.now();
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                DataOutputStream od = eStream.getOutputStream();
                od.write(op);
                for (Writable w : writables) {
                    w.write(od);
                }
                continue;
            }
            catch (IOException ie) {
                this.processIOError(idx);
            }
        }
        ++this.txid;
        TransactionId id = myTransactionId.get();
        id.txid = this.txid;
        long end = FSNamesystem.now();
        ++this.numTransactions;
        this.totalTimeTransactions += end - start;
        this.metrics.transactions.inc(end - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logSync() {
        ArrayList<EditLogOutputStream> errorStreams = null;
        long syncStart = 0L;
        TransactionId id = myTransactionId.get();
        long mytxid = id.txid;
        FSEditLog fSEditLog = this;
        synchronized (fSEditLog) {
            assert (this.getNumEditStreams() > 0) : "no editlog streams";
            this.printStatistics(false);
            while (mytxid > this.synctxid && this.isSyncRunning) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException ie) {}
            }
            if (mytxid <= this.synctxid) {
                return;
            }
            syncStart = this.txid;
            this.isSyncRunning = true;
            for (int idx = 0; idx < this.editStreams.size(); ++idx) {
                EditLogOutputStream eStream = this.editStreams.get(idx);
                eStream.swap();
            }
        }
        long start = FSNamesystem.now();
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.flushAndSyncOld();
                continue;
            }
            catch (IOException ie) {
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
                FSNamesystem.LOG.error((Object)"Unable to sync edit log. Fatal Error.");
            }
        }
        long elapsed = FSNamesystem.now() - start;
        FSEditLog fSEditLog2 = this;
        synchronized (fSEditLog2) {
            this.processIOError(errorStreams);
            this.synctxid = syncStart;
            this.isSyncRunning = false;
            this.notifyAll();
        }
        this.metrics.syncs.inc(elapsed);
    }

    private void printStatistics(boolean force) {
        long now = FSNamesystem.now();
        if (this.lastPrintTime + 60000L > now && !force) {
            return;
        }
        if (this.editStreams == null) {
            return;
        }
        this.lastPrintTime = now;
        StringBuffer buf = new StringBuffer();
        buf.append("Number of transactions: " + this.numTransactions + " Total time for transactions(ms): " + this.totalTimeTransactions);
        buf.append(" Number of syncs: " + this.editStreams.get(0).getNumSync());
        buf.append(" SyncTimes(ms): ");
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            buf.append(eStream.getTotalSyncTime());
            buf.append(" ");
        }
        FSNamesystem.LOG.info((Object)buf);
    }

    void logOpenFile(String path, INodeFileUnderConstruction newNode) throws IOException {
        Writable[] locations = newNode.getLastBlockLocations();
        Writable[] nameReplicationPair = new UTF8[]{new UTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)0, new ArrayWritable(UTF8.class, nameReplicationPair), new ArrayWritable(Block.class, newNode.getBlocks()), newNode.getPermissionStatus(), new UTF8(newNode.getClientName()), new UTF8(newNode.getClientMachine()), new ArrayWritable(DatanodeDescriptor.class, locations));
    }

    void logCloseFile(String path, INodeFile newNode) {
        Writable[] nameReplicationPair = new UTF8[]{new UTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)9, new ArrayWritable(UTF8.class, nameReplicationPair), new ArrayWritable(Block.class, newNode.getBlocks()), newNode.getPermissionStatus());
    }

    void logMkDir(String path, INode newNode) {
        Writable[] info = new UTF8[]{new UTF8(path), FSEditLog.toLogLong(newNode.getModificationTime())};
        this.logEdit((byte)3, new ArrayWritable(UTF8.class, info), newNode.getPermissionStatus());
    }

    void logRename(String src, String dst, long timestamp) {
        Writable[] info = new UTF8[]{new UTF8(src), new UTF8(dst), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)1, new ArrayWritable(UTF8.class, info));
    }

    void logSetReplication(String src, short replication) {
        this.logEdit((byte)4, new UTF8(src), FSEditLog.toLogReplication(replication));
    }

    void logSetPermissions(String src, FsPermission permissions) {
        this.logEdit((byte)7, new UTF8(src), permissions);
    }

    void logSetOwner(String src, String username, String groupname) {
        UTF8 u = new UTF8(username == null ? "" : username);
        UTF8 g = new UTF8(groupname == null ? "" : groupname);
        this.logEdit((byte)8, new UTF8(src), u, g);
    }

    void logDelete(String src, long timestamp) {
        Writable[] info = new UTF8[]{new UTF8(src), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)2, new ArrayWritable(UTF8.class, info));
    }

    void logGenerationStamp(long genstamp) {
        this.logEdit((byte)10, new LongWritable(genstamp));
    }

    static UTF8 toLogReplication(short replication) {
        return new UTF8(Short.toString(replication));
    }

    static short fromLogReplication(UTF8 replication) {
        return Short.parseShort(replication.toString());
    }

    static UTF8 toLogLong(long timestamp) {
        return new UTF8(Long.toString(timestamp));
    }

    synchronized long getEditLogSize() throws IOException {
        assert (this.getNumStorageDirs() == this.editStreams.size());
        long size = 0L;
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            assert (size == 0L || size == this.getEditFile(idx).length() + (long)eStream.getBufSize());
            size = this.getEditFile(idx).length() + (long)eStream.getBufSize();
        }
        return size;
    }

    synchronized void rollEditLog() throws IOException {
        if (this.existsNew()) {
            for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
                if (this.getEditNewFile(idx).exists()) continue;
                throw new IOException("Inconsistent existance of edits.new " + this.getEditNewFile(idx));
            }
            return;
        }
        this.close();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            try {
                EditLogOutputStream eStream = new EditLogOutputStream(this.getEditNewFile(idx));
                eStream.create();
                this.editStreams.add(eStream);
                continue;
            }
            catch (IOException e) {
                this.processIOError(idx);
                --idx;
            }
        }
    }

    synchronized void purgeEditLog() throws IOException {
        if (!this.existsNew()) {
            throw new IOException("Attempt to purge edit log but edits.new does not exist.");
        }
        this.close();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            if (this.getEditNewFile(idx).renameTo(this.getEditFile(idx))) continue;
            this.getEditFile(idx).delete();
            if (this.getEditNewFile(idx).renameTo(this.getEditFile(idx))) continue;
            this.fsimage.processIOError(idx);
            --idx;
        }
        this.open();
    }

    synchronized File getFsEditName() throws IOException {
        return this.getEditFile(0);
    }

    synchronized long getFsEditTime() throws IOException {
        return this.getEditFile(0).lastModified();
    }

    static void setBufferCapacity(int size) {
        sizeFlushBuffer = size;
    }

    static /* synthetic */ int access$000() {
        return sizeFlushBuffer;
    }

    static class EditLogOutputStream {
        private FileChannel fc;
        private FileOutputStream fp;
        private DataOutputStream od;
        private DataOutputStream od1;
        private DataOutputStream od2;
        private ByteArrayOutputStream buf1;
        private ByteArrayOutputStream buf2;
        private int bufSize = FSEditLog.access$000();
        private long numSync;
        private long totalTimeSync;

        EditLogOutputStream(File name) throws IOException {
            this.buf1 = new ByteArrayOutputStream(this.bufSize);
            this.buf2 = new ByteArrayOutputStream(this.bufSize);
            this.od1 = new DataOutputStream(this.buf1);
            this.od2 = new DataOutputStream(this.buf2);
            this.od = this.od1;
            this.fp = new FileOutputStream(name, true);
            this.fc = this.fp.getChannel();
            this.totalTimeSync = 0L;
            this.numSync = 0L;
        }

        DataOutputStream getOutputStream() {
            return this.od;
        }

        void flushAndSync() throws IOException {
            this.flush();
            this.fc.force(true);
        }

        void create() throws IOException {
            this.fc.truncate(0L);
            this.od.writeInt(-13);
            this.flushAndSync();
        }

        private void flush() throws IOException {
            ByteArrayOutputStream buf = this.getBuffer();
            if (buf.size() == 0) {
                return;
            }
            buf.writeTo(this.fp);
            buf.reset();
        }

        void close() throws IOException {
            if (this.getBufSize() != 0) {
                throw new IOException("FSEditStream has " + this.getBufSize() + " bytes still to be flushed and cannot " + "closed.");
            }
            this.od.close();
            this.fp.close();
            this.buf2 = null;
            this.buf1 = null;
            this.od2 = null;
            this.od1 = null;
            this.od = null;
        }

        int getBufSize() {
            return this.getBuffer().size();
        }

        private ByteArrayOutputStream getBuffer() {
            if (this.od == this.od1) {
                return this.buf1;
            }
            return this.buf2;
        }

        void swap() {
            this.od = this.od == this.od1 ? this.od2 : this.od1;
        }

        void flushAndSyncOld() throws IOException {
            ++this.numSync;
            ByteArrayOutputStream oldbuf = this.od == this.od1 ? this.buf2 : this.buf1;
            long start = FSNamesystem.now();
            oldbuf.writeTo(this.fp);
            oldbuf.reset();
            this.fc.force(true);
            long end = FSNamesystem.now();
            this.totalTimeSync += end - start;
        }

        long getTotalSyncTime() {
            return this.totalTimeSync;
        }

        long getNumSync() {
            return this.numSync;
        }
    }

    private static class TransactionId {
        public long txid;

        TransactionId(long value) {
            this.txid = value;
        }
    }
}

