/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class INodeDirectory
extends INode {
    protected static final int DEFAULT_FILES_PER_DIRECTORY = 5;
    static final String ROOT_NAME = "";
    private List<INode> children = null;

    INodeDirectory(String name, PermissionStatus permissions) {
        super(name, permissions);
    }

    INodeDirectory(PermissionStatus permissions, long mTime) {
        super(permissions, mTime);
    }

    @Override
    boolean isDirectory() {
        return true;
    }

    void removeChild(INode node) {
        assert (this.children != null);
        int low = Collections.binarySearch(this.children, node.name);
        if (low >= 0) {
            this.children.remove(low);
        }
    }

    INode getChild(String name) {
        return this.getChildINode(INodeDirectory.string2Bytes(name));
    }

    private INode getChildINode(byte[] name) {
        if (this.children == null) {
            return null;
        }
        int low = Collections.binarySearch(this.children, name);
        if (low >= 0) {
            return this.children.get(low);
        }
        return null;
    }

    private INode getNode(byte[][] components) {
        INode[] inode = new INode[1];
        this.getExistingPathINodes(components, inode);
        return inode[0];
    }

    INode getNode(String path) {
        return this.getNode(INodeDirectory.getPathComponents(path));
    }

    int getExistingPathINodes(byte[][] components, INode[] existing) {
        assert (INodeDirectory.compareBytes(this.name, components[0]) == 0) : "Incorrect name " + this.getLocalName() + " expected " + components[0];
        INode curNode = this;
        int count = 0;
        int index = existing.length - components.length;
        if (index > 0) {
            index = 0;
        }
        while (count < components.length && curNode != null) {
            if (index >= 0) {
                existing[index] = curNode;
            }
            if (!((INode)curNode).isDirectory() || count == components.length - 1) break;
            INodeDirectory parentDir = curNode;
            curNode = parentDir.getChildINode(components[count + 1]);
            ++count;
            ++index;
        }
        return count;
    }

    INode[] getExistingPathINodes(String path) {
        byte[][] components = INodeDirectory.getPathComponents(path);
        INode[] inodes = new INode[components.length];
        this.getExistingPathINodes(components, inodes);
        return inodes;
    }

    <T extends INode> T addChild(T node, boolean inheritPermission) {
        int low;
        if (inheritPermission) {
            FsPermission p = this.getFsPermission();
            if (!p.getUserAction().implies(FsAction.WRITE_EXECUTE)) {
                p = new FsPermission(p.getUserAction().or(FsAction.WRITE_EXECUTE), p.getGroupAction(), p.getOtherAction());
            }
            node.setPermission(p);
        }
        if (this.children == null) {
            this.children = new ArrayList<INode>(5);
        }
        if ((low = Collections.binarySearch(this.children, node.name)) >= 0) {
            return null;
        }
        node.parent = this;
        this.children.add(-low - 1, node);
        this.setModificationTime(node.getModificationTime());
        if (node.getGroupName() == null) {
            node.setGroup(this.getGroupName());
        }
        return node;
    }

    <T extends INode> T addNode(String path, T newNode) throws FileNotFoundException {
        return this.addNode(path, newNode, false);
    }

    <T extends INode> T addNode(String path, T newNode, boolean inheritPermission) throws FileNotFoundException {
        byte[][] pathComponents = INodeDirectory.getPathComponents(path);
        assert (pathComponents != null) : "Incorrect path " + path;
        int pathLen = pathComponents.length;
        if (pathLen < 2) {
            return null;
        }
        INode[] inode = new INode[2];
        this.getExistingPathINodes(pathComponents, inode);
        INode node = inode[0];
        if (node == null) {
            throw new FileNotFoundException("Parent path does not exist: " + path);
        }
        if (!node.isDirectory()) {
            throw new FileNotFoundException("Parent path is not a directory: " + path);
        }
        newNode.name = pathComponents[pathLen - 1];
        return ((INodeDirectory)node).addChild(newNode, inheritPermission);
    }

    int numItemsInTree() {
        int total = 1;
        if (this.children == null) {
            return total;
        }
        for (INode child : this.children) {
            if (!child.isDirectory()) {
                ++total;
                continue;
            }
            total += ((INodeDirectory)child).numItemsInTree();
        }
        return total;
    }

    @Override
    long[] computeContentSummary(long[] summary) {
        if (this.children != null) {
            for (INode child : this.children) {
                child.computeContentSummary(summary);
            }
        }
        summary[2] = summary[2] + 1L;
        return summary;
    }

    List<INode> getChildren() {
        return this.children == null ? new ArrayList() : this.children;
    }

    @Override
    int collectSubtreeBlocks(List<Block> v) {
        int total = 1;
        if (this.children == null) {
            return total;
        }
        for (INode child : this.children) {
            total += child.collectSubtreeBlocks(v);
        }
        return total;
    }
}

