/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import org.apache.hadoop.dfs.BlocksMap;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.INodeFile;
import org.apache.hadoop.dfs.StringBytesWritable;
import org.apache.hadoop.fs.permission.PermissionStatus;

class INodeFileUnderConstruction
extends INodeFile {
    protected StringBytesWritable clientName;
    protected StringBytesWritable clientMachine;
    protected DatanodeDescriptor clientNode;
    protected DatanodeDescriptor[] targets;

    INodeFileUnderConstruction() {
        this.clientName = null;
        this.clientMachine = null;
        this.clientNode = null;
        this.clientNode = null;
    }

    INodeFileUnderConstruction(PermissionStatus permissions, short replication, long preferredBlockSize, long modTime, String clientName, String clientMachine, DatanodeDescriptor clientNode) throws IOException {
        super(permissions.applyUMask(UMASK), 0, replication, modTime, preferredBlockSize);
        this.clientName = new StringBytesWritable(clientName);
        this.clientMachine = new StringBytesWritable(clientMachine);
        this.clientNode = clientNode;
        this.targets = new DatanodeDescriptor[0];
    }

    INodeFileUnderConstruction(byte[] name, short blockReplication, long modificationTime, long preferredBlockSize, BlocksMap.BlockInfo[] blocks, PermissionStatus perm, String clientName, String clientMachine, DatanodeDescriptor clientNode, DatanodeDescriptor[] targets) throws IOException {
        super(perm, blocks, blockReplication, modificationTime, preferredBlockSize);
        this.setLocalName(name);
        this.clientName = new StringBytesWritable(clientName);
        this.clientMachine = new StringBytesWritable(clientMachine);
        this.clientNode = clientNode;
        this.targets = targets;
    }

    String getClientName() throws IOException {
        return this.clientName.getString();
    }

    String getClientMachine() throws IOException {
        return this.clientMachine.getString();
    }

    DatanodeDescriptor getClientNode() {
        return this.clientNode;
    }

    void setLastBlockLocations(DatanodeDescriptor[] targets) {
        this.targets = targets;
    }

    DatanodeDescriptor[] getLastBlockLocations() {
        return this.targets;
    }

    boolean isUnderConstruction() {
        return true;
    }

    INodeFile convertToInodeFile() {
        INodeFile obj = new INodeFile(this.getPermissionStatus(), this.getBlocks(), this.getReplication(), this.getModificationTime(), this.getPreferredBlockSize());
        return obj;
    }
}

