/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UnixUserGroupInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspHelper {
    public static final String WEB_UGI_PROPERTY_NAME = "dfs.web.ugi";
    static FSNamesystem fsn = null;
    static InetSocketAddress nameNodeAddr;
    public static Configuration conf;
    public static final UnixUserGroupInformation webUGI;
    static int defaultChunkSizeToView;
    static Random rand;

    public JspHelper() {
        if (DataNode.getDataNode() != null) {
            nameNodeAddr = DataNode.getDataNode().getNameNodeAddr();
        } else {
            fsn = FSNamesystem.getFSNamesystem();
            nameNodeAddr = new InetSocketAddress(fsn.getDFSNameNodeMachine(), fsn.getDFSNameNodePort());
        }
        UnixUserGroupInformation.saveToConf(conf, "hadoop.job.ugi", webUGI);
    }

    public DatanodeID randomNode() throws IOException {
        return fsn.getRandomDatanode();
    }

    public DatanodeInfo bestNode(LocatedBlock blk) throws IOException {
        TreeSet<DatanodeInfo> deadNodes = new TreeSet<DatanodeInfo>();
        DatanodeInfo chosenNode = null;
        int failures = 0;
        Socket s = null;
        DatanodeInfo[] nodes = blk.getLocations();
        if (nodes == null || nodes.length == 0) {
            throw new IOException("No nodes contain this block");
        }
        while (s == null) {
            if (chosenNode == null) {
                while (deadNodes.contains(chosenNode = nodes[rand.nextInt(nodes.length)])) {
                }
            }
            int index = rand.nextInt(nodes.length);
            chosenNode = nodes[index];
            InetSocketAddress targetAddr = NetUtils.createSocketAddr(chosenNode.getHost() + ":" + chosenNode.getInfoPort());
            try {
                s = new Socket();
                s.connect(targetAddr, 60000);
                s.setSoTimeout(60000);
            }
            catch (IOException e) {
                deadNodes.add(chosenNode);
                s.close();
                s = null;
                ++failures;
            }
            if (failures != nodes.length) continue;
            throw new IOException("Could not reach the block containing the data. Please try again");
        }
        s.close();
        return chosenNode;
    }

    public void streamBlockInAscii(InetSocketAddress addr, long blockId, long blockSize, long offsetIntoBlock, long chunkSizeToView, JspWriter out) throws IOException {
        if (chunkSizeToView == 0L) {
            return;
        }
        Socket s = new Socket();
        s.connect(addr, 60000);
        s.setSoTimeout(60000);
        long amtToRead = Math.min(chunkSizeToView, blockSize - offsetIntoBlock);
        DFSClient.BlockReader blockReader = DFSClient.BlockReader.newBlockReader(s, addr.toString() + ":" + blockId, blockId, offsetIntoBlock, amtToRead, conf.getInt("io.file.buffer.size", 4096));
        byte[] buf = new byte[(int)amtToRead];
        int readOffset = 0;
        int retries = 2;
        while (amtToRead > 0L) {
            int numRead;
            try {
                numRead = blockReader.readAll(buf, readOffset, (int)amtToRead);
            }
            catch (IOException e) {
                if (--retries != 0) continue;
                throw new IOException("Could not read data from datanode");
            }
            amtToRead -= (long)numRead;
            readOffset += numRead;
        }
        blockReader = null;
        s.close();
        out.print(new String(buf));
    }

    public void DFSNodesStatus(ArrayList<DatanodeDescriptor> live, ArrayList<DatanodeDescriptor> dead) {
        if (fsn != null) {
            fsn.DFSNodesStatus(live, dead);
        }
    }

    public void addTableHeader(JspWriter out) throws IOException {
        out.print("<table border=\"1\" cellpadding=\"2\" cellspacing=\"2\">");
        out.print("<tbody>");
    }

    public void addTableRow(JspWriter out, String[] columns) throws IOException {
        out.print("<tr>");
        for (int i = 0; i < columns.length; ++i) {
            out.print("<td style=\"vertical-align: top;\"><B>" + columns[i] + "</B><br></td>");
        }
        out.print("</tr>");
    }

    public void addTableRow(JspWriter out, String[] columns, int row) throws IOException {
        out.print("<tr>");
        for (int i = 0; i < columns.length; ++i) {
            if (row / 2 * 2 == row) {
                out.print("<td style=\"vertical-align: top;background-color:LightGrey;\"><B>" + columns[i] + "</B><br></td>");
                continue;
            }
            out.print("<td style=\"vertical-align: top;background-color:LightBlue;\"><B>" + columns[i] + "</B><br></td>");
        }
        out.print("</tr>");
    }

    public void addTableFooter(JspWriter out) throws IOException {
        out.print("</tbody></table>");
    }

    public String getSafeModeText() {
        if (!fsn.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. <em>" + fsn.getSafeModeTip() + "</em><br>";
    }

    public String getInodeLimitText() {
        long inodes = JspHelper.fsn.dir.totalInodes();
        long blocks = fsn.getBlocksTotal();
        long maxobjects = fsn.getMaxObjects();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long used = totalMemory * 100L / maxMemory;
        String str = inodes + " files and directories, " + blocks + " blocks = " + (inodes + blocks) + " total";
        if (maxobjects != 0L) {
            long pct = (inodes + blocks) * 100L / maxobjects;
            str = str + " / " + maxobjects + " (" + pct + "%)";
        }
        str = str + ".  Heap Size is " + FsShell.byteDesc(totalMemory) + " / " + FsShell.byteDesc(maxMemory) + " (" + used + "%) <br>";
        return str;
    }

    public String getUpgradeStatusText() {
        String statusText = "";
        try {
            UpgradeStatusReport status = fsn.distributedUpgradeProgress(FSConstants.UpgradeAction.GET_STATUS);
            statusText = status == null ? "There are no upgrades in progress." : status.getStatusText(false);
        }
        catch (IOException e) {
            statusText = "Upgrade status unknown.";
        }
        return statusText;
    }

    public void sortNodeList(ArrayList<DatanodeDescriptor> nodes, String field, String order) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NodeComapare
        implements Comparator<DatanodeDescriptor> {
            static final int FIELD_NAME = 1;
            static final int FIELD_LAST_CONTACT = 2;
            static final int FIELD_BLOCKS = 3;
            static final int FIELD_SIZE = 4;
            static final int FIELD_DISK_USED = 5;
            static final int SORT_ORDER_ASC = 1;
            static final int SORT_ORDER_DSC = 2;
            int sortField = 1;
            int sortOrder = 1;

            public NodeComapare(String field, String order) {
                this.sortField = field.equals("lastcontact") ? 2 : (field.equals("size") ? 4 : (field.equals("blocks") ? 3 : (field.equals("pcused") ? 5 : 1)));
                this.sortOrder = order.equals("DSC") ? 2 : 1;
            }

            @Override
            public int compare(DatanodeDescriptor d1, DatanodeDescriptor d2) {
                int ret = 0;
                switch (this.sortField) {
                    case 2: {
                        ret = (int)(d2.getLastUpdate() - d1.getLastUpdate());
                        break;
                    }
                    case 3: {
                        ret = d1.numBlocks() - d2.numBlocks();
                        break;
                    }
                    case 4: {
                        long dlong = d1.getCapacity() - d2.getCapacity();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 5: {
                        double ddbl = (double)d2.getRemaining() * 1.0 / (double)d2.getCapacity() - (double)d1.getRemaining() * 1.0 / (double)d1.getCapacity();
                        ret = ddbl < 0.0 ? -1 : (ddbl > 0.0 ? 1 : 0);
                        break;
                    }
                    case 1: {
                        ret = d1.getHostName().compareTo(d2.getHostName());
                    }
                }
                return this.sortOrder == 2 ? -ret : ret;
            }
        }
        Collections.sort(nodes, new NodeComapare(field, order));
    }

    public static void printPathWithLinks(String dir, JspWriter out, int namenodeInfoPort) throws IOException {
        try {
            String[] parts = dir.split("/");
            StringBuilder tempPath = new StringBuilder(dir.length());
            out.print("<a href=\"browseDirectory.jsp?dir=/&namenodeInfoPort=" + namenodeInfoPort + "\">" + "/" + "</a>");
            tempPath.append("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                if (parts[i].equals("")) continue;
                tempPath.append(parts[i]);
                out.print("<a href=\"browseDirectory.jsp?dir=" + tempPath.toString() + "&namenodeInfoPort=" + namenodeInfoPort);
                out.print("\">" + parts[i] + "</a>" + "/");
                tempPath.append("/");
            }
            if (parts.length > 0) {
                out.print(parts[parts.length - 1]);
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    public static void printGotoForm(JspWriter out, int namenodeInfoPort, String file) throws IOException {
        out.print("<form action=\"browseDirectory.jsp\" method=\"get\" name=\"goto\">");
        out.print("Goto : ");
        out.print("<input name=\"dir\" type=\"text\" width=\"50\" id\"dir\" value=\"" + file + "\">");
        out.print("<input name=\"go\" type=\"submit\" value=\"go\">");
        out.print("<input name=\"namenodeInfoPort\" type=\"hidden\" value=\"" + namenodeInfoPort + "\">");
        out.print("</form>");
    }

    public static void createTitle(JspWriter out, HttpServletRequest req, String file) throws IOException {
        int start;
        if (file == null) {
            file = "";
        }
        if ((start = Math.max(0, file.length() - 100)) != 0) {
            file = "..." + file.substring(start, file.length());
        }
        out.print("<title>HDFS:" + file + "</title>");
    }

    public static String percentageGraph(int perc, int width) throws IOException {
        assert (perc >= 0);
        assert (perc <= 100);
        StringBuilder builder = new StringBuilder();
        builder.append("<table border=\"1px\" width=\"");
        builder.append(width);
        builder.append("px\"><tr>");
        if (perc > 0) {
            builder.append("<td cellspacing=\"0\" class=\"perc_filled\" width=\"");
            builder.append(perc);
            builder.append("%\"></td>");
        }
        if (perc < 100) {
            builder.append("<td cellspacing=\"0\" class=\"perc_nonfilled\" width=\"");
            builder.append(100 - perc);
            builder.append("%\"></td>");
        }
        builder.append("</tr></table>");
        return builder.toString();
    }

    public static String percentageGraph(float perc, int width) throws IOException {
        return JspHelper.percentageGraph((int)perc, width);
    }

    static {
        conf = new Configuration();
        webUGI = UnixUserGroupInformation.createImmutable(conf.getStrings(WEB_UGI_PROPERTY_NAME));
        defaultChunkSizeToView = conf.getInt("dfs.default.chunk.view.size", 32768);
        rand = new Random();
    }
}

