/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.LocatedBlocks;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.ReplicationTargetChooser;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NodeBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamenodeFsck {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.NameNode");
    public static final int FIXING_NONE = 0;
    public static final int FIXING_MOVE = 1;
    public static final int FIXING_DELETE = 2;
    private NameNode nn;
    private String lostFound = null;
    private boolean lfInited = false;
    private boolean lfInitedOk = false;
    private boolean showFiles = false;
    private boolean showBlocks = false;
    private boolean showLocations = false;
    private boolean showRacks = false;
    private int fixing = 0;
    private String path = "/";
    private Configuration conf;
    private PrintWriter out;
    Random r = new Random();

    public NamenodeFsck(Configuration conf, NameNode nn, Map<String, String[]> pmap, HttpServletResponse response) throws IOException {
        this.conf = conf;
        this.nn = nn;
        this.out = response.getWriter();
        for (String key : pmap.keySet()) {
            if (key.equals("path")) {
                this.path = pmap.get("path")[0];
                continue;
            }
            if (key.equals("move")) {
                this.fixing = 1;
                continue;
            }
            if (key.equals("delete")) {
                this.fixing = 2;
                continue;
            }
            if (key.equals("files")) {
                this.showFiles = true;
                continue;
            }
            if (key.equals("blocks")) {
                this.showBlocks = true;
                continue;
            }
            if (key.equals("locations")) {
                this.showLocations = true;
                continue;
            }
            if (!key.equals("racks")) continue;
            this.showRacks = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fsck() throws IOException {
        try {
            DFSFileInfo[] files = this.nn.namesystem.dir.getListing(this.path);
            FsckResult res = new FsckResult();
            res.totalRacks = this.nn.getNetworkTopology().getNumOfRacks();
            res.totalDatanodes = this.nn.namesystem.getNumberOfDatanodes(FSConstants.DatanodeReportType.LIVE);
            res.setReplication((short)this.conf.getInt("dfs.replication", 3));
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.check(files[i], res);
                }
                this.out.println(res);
                if (res.isHealthy()) {
                    this.out.println("\n\nThe filesystem under path '" + this.path + "' is HEALTHY");
                } else {
                    this.out.println("\n\nThe filesystem under path '" + this.path + "' is CORRUPT");
                }
            } else {
                this.out.println("\n\nPath '" + this.path + "' does not exist.");
            }
        }
        finally {
            this.out.close();
        }
    }

    private void check(DFSFileInfo file, FsckResult res) throws IOException {
        short minReplication = this.nn.namesystem.getMinReplication();
        String path = file.getPath().toString();
        if (file.isDir()) {
            DFSFileInfo[] files = this.nn.namesystem.dir.getListing(path);
            if (files == null) {
                return;
            }
            if (this.showFiles) {
                this.out.println(path + " <dir>");
            }
            res.totalDirs++;
            for (int i = 0; i < files.length; ++i) {
                this.check(files[i], res);
            }
            return;
        }
        res.totalFiles++;
        long fileLen = file.getLen();
        res.totalSize += fileLen;
        LocatedBlocks blocks = this.nn.namesystem.getBlockLocations(path, 0L, fileLen);
        res.totalBlocks += blocks.locatedBlockCount();
        if (this.showFiles) {
            this.out.print(path + " " + fileLen + " bytes, " + blocks.locatedBlockCount() + " block(s): ");
        } else {
            this.out.print('.');
        }
        if (res.totalFiles % 100L == 0L) {
            this.out.flush();
        }
        int missing = 0;
        long missize = 0L;
        int underReplicatedPerFile = 0;
        int misReplicatedPerFile = 0;
        StringBuffer report = new StringBuffer();
        int i = 0;
        for (LocatedBlock lBlk : blocks.getLocatedBlocks()) {
            int missingRacks;
            Block block = lBlk.getBlock();
            String blkName = block.getBlockName();
            DatanodeInfo[] locs = lBlk.getLocations();
            res.totalReplicas += locs.length;
            short targetFileReplication = file.getReplication();
            if (locs.length > targetFileReplication) {
                res.excessiveReplicas += locs.length - targetFileReplication;
                res.numOverReplicatedBlocks += 1L;
            }
            if (locs.length >= minReplication) {
                res.numMinReplicatedBlocks++;
            }
            if (locs.length < targetFileReplication && locs.length > 0) {
                res.missingReplicas += targetFileReplication - locs.length;
                res.numUnderReplicatedBlocks += 1L;
                ++underReplicatedPerFile;
                if (!this.showFiles) {
                    this.out.print("\n" + path + ": ");
                }
                this.out.println(" Under replicated " + block.getBlockName() + ". Target Replicas is " + targetFileReplication + " but found " + locs.length + " replica(s).");
            }
            if ((missingRacks = ReplicationTargetChooser.verifyBlockPlacement(lBlk, targetFileReplication, this.nn.getNetworkTopology())) > 0) {
                res.numMisReplicatedBlocks++;
                ++misReplicatedPerFile;
                if (!this.showFiles) {
                    if (underReplicatedPerFile == 0) {
                        this.out.println();
                    }
                    this.out.print(path + ": ");
                }
                this.out.println(" Replica placement policy is violated for " + block.getBlockName() + ". Block should be additionally replicated on " + missingRacks + " more rack(s).");
            }
            report.append(i + ". " + blkName + " len=" + block.getNumBytes());
            if (locs.length == 0) {
                report.append(" MISSING!");
                res.addMissing(block.getBlockName(), block.getNumBytes());
                ++missing;
                missize += block.getNumBytes();
            } else {
                report.append(" repl=" + locs.length);
                if (this.showLocations || this.showRacks) {
                    StringBuffer sb = new StringBuffer("[");
                    for (int j = 0; j < locs.length; ++j) {
                        if (j > 0) {
                            sb.append(", ");
                        }
                        if (this.showRacks) {
                            sb.append(NodeBase.getPath(locs[j]));
                            continue;
                        }
                        sb.append(locs[j]);
                    }
                    sb.append(']');
                    report.append(" " + sb.toString());
                }
            }
            report.append('\n');
            ++i;
        }
        if (missing > 0) {
            if (!this.showFiles) {
                this.out.print("\n" + path + ": MISSING " + missing + " blocks of total size " + missize + " B.");
            }
            res.corruptFiles++;
            switch (this.fixing) {
                case 0: {
                    break;
                }
                case 1: {
                    this.lostFoundMove(file, blocks);
                    break;
                }
                case 2: {
                    this.nn.namesystem.deleteInternal(path, true, false);
                }
            }
        }
        if (this.showFiles) {
            if (missing > 0) {
                this.out.print(" MISSING " + missing + " blocks of total size " + missize + " B\n");
            } else if (underReplicatedPerFile == 0 && misReplicatedPerFile == 0) {
                this.out.print(" OK\n");
            }
            if (this.showBlocks) {
                this.out.print(report.toString() + "\n");
            }
        }
    }

    private void lostFoundMove(DFSFileInfo file, LocatedBlocks blocks) throws IOException {
        DFSClient dfs = new DFSClient(this.conf);
        if (!this.lfInited) {
            this.lostFoundInit(dfs);
        }
        if (!this.lfInitedOk) {
            return;
        }
        String target = this.lostFound + file.getPath();
        String errmsg = "Failed to move " + file.getPath() + " to /lost+found";
        try {
            PermissionStatus ps = new PermissionStatus(file.getOwner(), file.getGroup(), file.getPermission());
            if (!this.nn.namesystem.dir.mkdirs(target, ps, false, FSNamesystem.now())) {
                LOG.warn((Object)errmsg);
                return;
            }
            int chain = 0;
            OutputStream fos = null;
            for (LocatedBlock lBlk : blocks.getLocatedBlocks()) {
                LocatedBlock lblock = lBlk;
                DatanodeInfo[] locs = lblock.getLocations();
                if (locs == null || locs.length == 0) {
                    if (fos == null) continue;
                    fos.flush();
                    fos.close();
                    fos = null;
                    continue;
                }
                if (fos == null) {
                    fos = dfs.create(target + "/" + chain, true);
                    if (fos != null) {
                        ++chain;
                    } else {
                        LOG.warn((Object)(errmsg + ": could not store chain " + chain));
                        continue;
                    }
                }
                try {
                    this.copyBlock(dfs, lblock, fos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOG.warn((Object)(" - could not copy block " + lblock.getBlock().getBlockName() + " to " + target));
                    fos.flush();
                    fos.close();
                    fos = null;
                }
            }
            if (fos != null) {
                fos.close();
            }
            LOG.warn((Object)("\n - moved corrupted file " + file.getPath() + " to /lost+found"));
            dfs.delete(file.getPath().toString(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.warn((Object)(errmsg + ": " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBlock(DFSClient dfs, LocatedBlock lblock, OutputStream fos) throws Exception {
        int failures = 0;
        InetSocketAddress targetAddr = null;
        TreeSet<DatanodeInfo> deadNodes = new TreeSet<DatanodeInfo>();
        Socket s = null;
        DFSClient.BlockReader blockReader = null;
        Block block = lblock.getBlock();
        while (s == null) {
            DatanodeInfo chosenNode;
            try {
                chosenNode = this.bestNode(dfs, lblock.getLocations(), deadNodes);
                targetAddr = NetUtils.createSocketAddr(chosenNode.getName());
            }
            catch (IOException ie) {
                if (failures >= 3) {
                    throw new IOException("Could not obtain block " + lblock);
                }
                LOG.info((Object)("Could not obtain block from any node:  " + ie));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
                deadNodes.clear();
                ++failures;
                continue;
            }
            try {
                s = new Socket();
                s.connect(targetAddr, 60000);
                s.setSoTimeout(60000);
                blockReader = DFSClient.BlockReader.newBlockReader(s, targetAddr.toString() + ":" + block.getBlockId(), block.getBlockId(), 0L, -1L, this.conf.getInt("io.file.buffer.size", 4096));
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to connect to " + targetAddr + ":" + ex));
                deadNodes.add(chosenNode);
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iex) {
                        // empty catch block
                    }
                }
                s = null;
            }
        }
        if (blockReader == null) {
            throw new Exception("Could not open data stream for " + lblock.getBlock().getBlockName());
        }
        byte[] buf = new byte[1024];
        int cnt = 0;
        boolean success = true;
        long bytesRead = 0L;
        try {
            while ((cnt = blockReader.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, cnt);
                bytesRead += (long)cnt;
            }
            if (bytesRead != block.getNumBytes()) {
                throw new IOException("Recorded block size is " + block.getNumBytes() + ", but datanode returned " + bytesRead + " bytes");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        finally {
            try {
                s.close();
            }
            catch (Exception e1) {}
        }
        if (!success) {
            throw new Exception("Could not copy block data for " + lblock.getBlock().getBlockName());
        }
    }

    private DatanodeInfo bestNode(DFSClient dfs, DatanodeInfo[] nodes, TreeSet<DatanodeInfo> deadNodes) throws IOException {
        DatanodeInfo chosenNode;
        if (nodes == null || nodes.length - deadNodes.size() < 1) {
            throw new IOException("No live nodes contain current block");
        }
        while (deadNodes.contains(chosenNode = nodes[this.r.nextInt(nodes.length)])) {
        }
        return chosenNode;
    }

    private void lostFoundInit(DFSClient dfs) {
        this.lfInited = true;
        try {
            String lfName = "/lost+found";
            if (!dfs.exists(lfName)) {
                this.lfInitedOk = dfs.mkdirs(lfName);
                this.lostFound = lfName;
            } else if (!dfs.isDirectory(lfName)) {
                LOG.warn((Object)"Cannot use /lost+found : a regular file with this name exists.");
                this.lfInitedOk = false;
            } else {
                this.lostFound = lfName;
                this.lfInitedOk = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lfInitedOk = false;
        }
        if (this.lostFound == null) {
            LOG.warn((Object)"Cannot initialize /lost+found .");
            this.lfInitedOk = false;
        }
    }

    public int run(String[] args) throws Exception {
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FsckResult {
        private ArrayList<String> missingIds = new ArrayList();
        private long missingSize = 0L;
        private long corruptFiles = 0L;
        private long excessiveReplicas = 0L;
        private long missingReplicas = 0L;
        private long numOverReplicatedBlocks = 0L;
        private long numUnderReplicatedBlocks = 0L;
        private long numMisReplicatedBlocks = 0L;
        private long numMinReplicatedBlocks = 0L;
        private int replication = 0;
        private long totalBlocks = 0L;
        private long totalFiles = 0L;
        private long totalDirs = 0L;
        private long totalSize = 0L;
        private long totalReplicas = 0L;
        private int totalDatanodes = 0;
        private int totalRacks = 0;

        public boolean isHealthy() {
            return this.missingIds.size() == 0;
        }

        public void addMissing(String id, long size) {
            this.missingIds.add(id);
            this.missingSize += size;
        }

        public ArrayList<String> getMissingIds() {
            return this.missingIds;
        }

        public long getMissingSize() {
            return this.missingSize;
        }

        public void setMissingSize(long missingSize) {
            this.missingSize = missingSize;
        }

        public long getExcessiveReplicas() {
            return this.excessiveReplicas;
        }

        public void setExcessiveReplicas(long overReplicatedBlocks) {
            this.excessiveReplicas = overReplicatedBlocks;
        }

        public float getReplicationFactor() {
            if (this.totalBlocks == 0L) {
                return 0.0f;
            }
            return (float)this.totalReplicas / (float)this.totalBlocks;
        }

        public long getMissingReplicas() {
            return this.missingReplicas;
        }

        public void setMissingReplicas(long underReplicatedBlocks) {
            this.missingReplicas = underReplicatedBlocks;
        }

        public long getTotalDirs() {
            return this.totalDirs;
        }

        public void setTotalDirs(long totalDirs) {
            this.totalDirs = totalDirs;
        }

        public long getTotalFiles() {
            return this.totalFiles;
        }

        public void setTotalFiles(long totalFiles) {
            this.totalFiles = totalFiles;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public void setTotalSize(long totalSize) {
            this.totalSize = totalSize;
        }

        public int getReplication() {
            return this.replication;
        }

        public void setReplication(int replication) {
            this.replication = replication;
        }

        public long getTotalBlocks() {
            return this.totalBlocks;
        }

        public void setTotalBlocks(long totalBlocks) {
            this.totalBlocks = totalBlocks;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("Status: " + (this.isHealthy() ? "HEALTHY" : "CORRUPT"));
            res.append("\n Total size:\t" + this.totalSize + " B");
            res.append("\n Total dirs:\t" + this.totalDirs);
            res.append("\n Total files:\t" + this.totalFiles);
            res.append("\n Total blocks:\t" + this.totalBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (avg. block size " + this.totalSize / this.totalBlocks + " B)");
            }
            if (this.missingSize > 0L) {
                res.append("\n  ********************************");
                res.append("\n  CORRUPT FILES:\t" + this.corruptFiles);
                res.append("\n  MISSING BLOCKS:\t" + this.missingIds.size());
                res.append("\n  MISSING SIZE:\t\t" + this.missingSize + " B");
                res.append("\n  ********************************");
            }
            res.append("\n Minimally replicated blocks:\t" + this.numMinReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.numMinReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Over-replicated blocks:\t" + this.numOverReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.numOverReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Under-replicated blocks:\t" + this.numUnderReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.numUnderReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Mis-replicated blocks:\t\t" + this.numMisReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.numMisReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Default replication factor:\t" + this.replication);
            res.append("\n Average block replication:\t" + this.getReplicationFactor());
            res.append("\n Missing replicas:\t\t" + this.missingReplicas);
            if (this.totalReplicas > 0L) {
                res.append(" (" + (float)(this.missingReplicas * 100L) / (float)this.totalReplicas + " %)");
            }
            res.append("\n Number of data-nodes:\t\t" + this.totalDatanodes);
            res.append("\n Number of racks:\t\t" + this.totalRacks);
            return res.toString();
        }

        public long getCorruptFiles() {
            return this.corruptFiles;
        }

        public void setCorruptFiles(long corruptFiles) {
            this.corruptFiles = corruptFiles;
        }
    }
}

