/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.DatanodeCommand;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class UpgradeCommand
extends DatanodeCommand {
    static final int UC_ACTION_UNKNOWN = 0;
    static final int UC_ACTION_REPORT_STATUS = 100;
    static final int UC_ACTION_START_UPGRADE = 101;
    private int version;
    private short upgradeStatus;

    UpgradeCommand() {
        super(0);
        this.version = 0;
        this.upgradeStatus = 0;
    }

    UpgradeCommand(int action, int version, short status) {
        super(action);
        this.version = version;
        this.upgradeStatus = status;
    }

    int getVersion() {
        return this.version;
    }

    short getCurrentStatus() {
        return this.upgradeStatus;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.version);
        out.writeShort(this.upgradeStatus);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.version = in.readInt();
        this.upgradeStatus = in.readShort();
    }

    static {
        WritableFactories.setFactory(UpgradeCommand.class, new WritableFactory(){

            public Writable newInstance() {
                return new UpgradeCommand();
            }
        });
    }
}

