/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs.datanode.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.datanode.metrics.DataNodeStatistics;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingInt;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class DataNodeMetrics
implements Updater {
    private final MetricsRecord metricsRecord;
    private DataNodeStatistics datanodeStats;
    public MetricsTimeVaryingInt bytesWritten = new MetricsTimeVaryingInt("bytes_written");
    public MetricsTimeVaryingInt bytesRead = new MetricsTimeVaryingInt("bytes_read");
    public MetricsTimeVaryingInt blocksWritten = new MetricsTimeVaryingInt("blocks_written");
    public MetricsTimeVaryingInt blocksRead = new MetricsTimeVaryingInt("blocks_read");
    public MetricsTimeVaryingInt blocksReplicated = new MetricsTimeVaryingInt("blocks_replicated");
    public MetricsTimeVaryingInt blocksRemoved = new MetricsTimeVaryingInt("blocks_removed");
    public MetricsTimeVaryingInt blocksVerified = new MetricsTimeVaryingInt("blocks_verified");
    public MetricsTimeVaryingInt blockVerificationFailures = new MetricsTimeVaryingInt("block_verification_failures");
    public MetricsTimeVaryingInt readsFromLocalClient = new MetricsTimeVaryingInt("reads_from_local_client");
    public MetricsTimeVaryingInt readsFromRemoteClient = new MetricsTimeVaryingInt("reads_from_remote_client");
    public MetricsTimeVaryingInt writesFromLocalClient = new MetricsTimeVaryingInt("writes_from_local_client");
    public MetricsTimeVaryingInt writesFromRemoteClient = new MetricsTimeVaryingInt("writes_from_remote_client");
    public MetricsTimeVaryingRate readBlockOp = new MetricsTimeVaryingRate("readBlockOp");
    public MetricsTimeVaryingRate writeBlockOp = new MetricsTimeVaryingRate("writeBlockOp");
    public MetricsTimeVaryingRate readMetadataOp = new MetricsTimeVaryingRate("readMetadataOp");
    public MetricsTimeVaryingRate copyBlockOp = new MetricsTimeVaryingRate("copyBlockOp");
    public MetricsTimeVaryingRate replaceBlockOp = new MetricsTimeVaryingRate("replaceBlockOp");
    public MetricsTimeVaryingRate heartbeats = new MetricsTimeVaryingRate("heartBeats");
    public MetricsTimeVaryingRate blockReports = new MetricsTimeVaryingRate("blockReports");

    public DataNodeMetrics(Configuration conf, String storageId) {
        String sessionId = conf.get("session.id");
        JvmMetrics.init("DataNode", sessionId);
        this.datanodeStats = new DataNodeStatistics(this, storageId);
        MetricsContext context = MetricsUtil.getContext("dfs");
        this.metricsRecord = MetricsUtil.createRecord(context, "datanode");
        this.metricsRecord.setTag("sessionId", sessionId);
        context.registerUpdater(this);
    }

    public void shutdown() {
        if (this.datanodeStats != null) {
            this.datanodeStats.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        DataNodeMetrics dataNodeMetrics = this;
        synchronized (dataNodeMetrics) {
            this.bytesWritten.pushMetric(this.metricsRecord);
            this.bytesRead.pushMetric(this.metricsRecord);
            this.blocksWritten.pushMetric(this.metricsRecord);
            this.blocksRead.pushMetric(this.metricsRecord);
            this.blocksReplicated.pushMetric(this.metricsRecord);
            this.blocksRemoved.pushMetric(this.metricsRecord);
            this.blocksVerified.pushMetric(this.metricsRecord);
            this.blockVerificationFailures.pushMetric(this.metricsRecord);
            this.readsFromLocalClient.pushMetric(this.metricsRecord);
            this.writesFromLocalClient.pushMetric(this.metricsRecord);
            this.readsFromRemoteClient.pushMetric(this.metricsRecord);
            this.writesFromRemoteClient.pushMetric(this.metricsRecord);
            this.readBlockOp.pushMetric(this.metricsRecord);
            this.writeBlockOp.pushMetric(this.metricsRecord);
            this.readMetadataOp.pushMetric(this.metricsRecord);
            this.copyBlockOp.pushMetric(this.metricsRecord);
            this.replaceBlockOp.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }

    public void resetAllMinMax() {
        this.readBlockOp.resetMinMax();
        this.writeBlockOp.resetMinMax();
        this.readMetadataOp.resetMinMax();
        this.copyBlockOp.resetMinMax();
        this.replaceBlockOp.resetMinMax();
    }
}

