/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

public abstract class FSInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    public abstract void seek(long var1) throws IOException;

    public abstract long getPos() throws IOException;

    public abstract boolean seekToNewSource(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        FSInputStream fSInputStream = this;
        synchronized (fSInputStream) {
            long oldPos = this.getPos();
            int nread = -1;
            try {
                this.seek(position);
                nread = this.read(buffer, offset, length);
            }
            finally {
                this.seek(oldPos);
            }
            return nread;
        }
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int nbytes;
        for (int nread = 0; nread < length; nread += nbytes) {
            nbytes = this.read(position + (long)nread, buffer, offset + nread, length - nread);
            if (nbytes >= 0) continue;
            throw new EOFException("End of file reached before reading fully.");
        }
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }
}

