/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.kfs;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.kfs.IFSImpl;
import org.apache.hadoop.fs.kfs.KFSInputStream;
import org.apache.hadoop.fs.kfs.KFSOutputStream;
import org.kosmix.kosmosfs.access.KfsAccess;

class KFSImpl
implements IFSImpl {
    private KfsAccess kfsAccess = null;
    private FileSystem.Statistics statistics;

    @Deprecated
    public KFSImpl(String metaServerHost, int metaServerPort) throws IOException {
        this(metaServerHost, metaServerPort, null);
    }

    public KFSImpl(String metaServerHost, int metaServerPort, FileSystem.Statistics stats) throws IOException {
        this.kfsAccess = new KfsAccess(metaServerHost, metaServerPort);
        this.statistics = stats;
    }

    public boolean exists(String path) throws IOException {
        return this.kfsAccess.kfs_exists(path);
    }

    public boolean isDirectory(String path) throws IOException {
        return this.kfsAccess.kfs_isDirectory(path);
    }

    public boolean isFile(String path) throws IOException {
        return this.kfsAccess.kfs_isFile(path);
    }

    public String[] readdir(String path) throws IOException {
        return this.kfsAccess.kfs_readdir(path);
    }

    public int mkdirs(String path) throws IOException {
        return this.kfsAccess.kfs_mkdirs(path);
    }

    public int rename(String source, String dest) throws IOException {
        return this.kfsAccess.kfs_rename(source, dest);
    }

    public int rmdir(String path) throws IOException {
        return this.kfsAccess.kfs_rmdir(path);
    }

    public int remove(String path) throws IOException {
        return this.kfsAccess.kfs_remove(path);
    }

    public long filesize(String path) throws IOException {
        return this.kfsAccess.kfs_filesize(path);
    }

    public short getReplication(String path) throws IOException {
        return this.kfsAccess.kfs_getReplication(path);
    }

    public short setReplication(String path, short replication) throws IOException {
        return this.kfsAccess.kfs_setReplication(path, (int)replication);
    }

    public String[][] getDataLocation(String path, long start, long len) throws IOException {
        return this.kfsAccess.kfs_getDataLocation(path, start, len);
    }

    public long getModificationTime(String path) throws IOException {
        return 0L;
    }

    public FSDataOutputStream create(String path, short replication, int bufferSize) throws IOException {
        return new FSDataOutputStream(new KFSOutputStream(this.kfsAccess, path, replication), this.statistics);
    }

    public FSDataInputStream open(String path, int bufferSize) throws IOException {
        return new FSDataInputStream(new KFSInputStream(this.kfsAccess, path, this.statistics));
    }
}

