/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.kfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.kosmix.kosmosfs.access.KfsAccess;
import org.kosmix.kosmosfs.access.KfsInputChannel;

class KFSInputStream
extends FSInputStream {
    private KfsInputChannel kfsChannel;
    private FileSystem.Statistics statistics;
    private long fsize;

    @Deprecated
    public KFSInputStream(KfsAccess kfsAccess, String path) {
        this(kfsAccess, path, null);
    }

    public KFSInputStream(KfsAccess kfsAccess, String path, FileSystem.Statistics stats) {
        this.statistics = stats;
        this.kfsChannel = kfsAccess.kfs_open(path);
        this.fsize = this.kfsChannel != null ? kfsAccess.kfs_filesize(path) : 0L;
    }

    public long getPos() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        return this.kfsChannel.tell();
    }

    public synchronized int available() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        return (int)(this.fsize - this.getPos());
    }

    public synchronized void seek(long targetPos) throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        this.kfsChannel.seek(targetPos);
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized int read() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        byte[] b = new byte[4];
        int res = this.read(b, 0, 4);
        if (res == 4) {
            if (this.statistics != null) {
                this.statistics.incrementBytesRead(1L);
            }
            return b[0] + (b[1] << 8) + (b[2] << 16) + (b[3] << 24);
        }
        return -1;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        int res = this.kfsChannel.read(ByteBuffer.wrap(b, off, len));
        if (res == 0) {
            return -1;
        }
        if (this.statistics != null) {
            this.statistics.incrementBytesRead(res);
        }
        return res;
    }

    public synchronized void close() throws IOException {
        if (this.kfsChannel == null) {
            return;
        }
        this.kfsChannel.close();
        this.kfsChannel = null;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Mark not supported");
    }
}

