/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.kfs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.kosmix.kosmosfs.access.KfsAccess;
import org.kosmix.kosmosfs.access.KfsOutputChannel;

class KFSOutputStream
extends OutputStream {
    private String path;
    private KfsOutputChannel kfsChannel;

    public KFSOutputStream(KfsAccess kfsAccess, String path, short replication) {
        this.path = path;
        this.kfsChannel = kfsAccess.kfs_create(path, (int)replication);
    }

    public long getPos() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        return this.kfsChannel.tell();
    }

    public void write(int v) throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        byte[] b = new byte[4];
        b[0] = (byte)(v & 0xFF);
        b[1] = (byte)(v >> 8 & 0xFF);
        b[1] = (byte)(v >> 16 & 0xFF);
        b[1] = (byte)(v >> 24 & 0xFF);
        this.write(b, 0, 4);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        this.kfsChannel.write(ByteBuffer.wrap(b, off, len));
    }

    public void flush() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        this.kfsChannel.sync();
    }

    public synchronized void close() throws IOException {
        if (this.kfsChannel == null) {
            return;
        }
        this.flush();
        this.kfsChannel.close();
        this.kfsChannel = null;
    }
}

