/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.kfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.kfs.IFSImpl;
import org.apache.hadoop.fs.kfs.KFSImpl;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class KosmosFileSystem
extends FileSystem {
    private FileSystem localFs;
    private IFSImpl kfsImpl = null;
    private URI uri;
    private Path workingDir = new Path("/");

    public KosmosFileSystem() {
    }

    KosmosFileSystem(IFSImpl fsimpl) {
        this.kfsImpl = fsimpl;
    }

    public URI getUri() {
        return this.uri;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        try {
            if (this.kfsImpl == null) {
                this.kfsImpl = new KFSImpl(conf.get("fs.kfs.metaServerHost", ""), conf.getInt("fs.kfs.metaServerPort", -1), this.statistics);
            }
            this.localFs = FileSystem.getLocal(conf);
            this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to initialize KFS");
            System.exit(-1);
        }
    }

    @Deprecated
    public String getName() {
        return this.getUri().toString();
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(Path dir) {
        this.workingDir = this.makeAbsolute(dir);
    }

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        int res = this.kfsImpl.mkdirs(srep);
        return res == 0;
    }

    @Deprecated
    public boolean isDirectory(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.isDirectory(srep);
    }

    @Deprecated
    public boolean isFile(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.isFile(srep);
    }

    public long getContentLength(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        if (this.kfsImpl.isFile(srep)) {
            return this.kfsImpl.filesize(srep);
        }
        String[] entries = this.kfsImpl.readdir(srep);
        if (entries == null) {
            return 0L;
        }
        long numEntries = 0L;
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].compareTo(".") == 0 || entries[i].compareTo("..") == 0) continue;
            ++numEntries;
        }
        return numEntries;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        if (this.kfsImpl.isFile(srep)) {
            return new FileStatus[]{this.getFileStatus(path)};
        }
        String[] entries = this.kfsImpl.readdir(srep);
        if (entries == null) {
            return null;
        }
        int numEntries = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].compareTo(".") == 0 || entries[i].compareTo("..") == 0) continue;
            ++numEntries;
        }
        if (numEntries == 0) {
            return null;
        }
        FileStatus[] pathEntries = new FileStatus[numEntries];
        int j = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].compareTo(".") == 0 || entries[i].compareTo("..") == 0) continue;
            pathEntries[j] = this.getFileStatus(new Path(path, entries[i]));
            ++j;
        }
        return pathEntries;
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        if (!this.kfsImpl.exists(srep)) {
            throw new FileNotFoundException("File " + path + " does not exist.");
        }
        if (this.kfsImpl.isDirectory(srep)) {
            return new FileStatus(0L, true, 1, 0L, 0L, path);
        }
        return new FileStatus(this.kfsImpl.filesize(srep), false, this.kfsImpl.getReplication(srep), this.getDefaultBlockSize(), this.kfsImpl.getModificationTime(srep), path);
    }

    public FSDataOutputStream create(Path file, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent;
        if (this.exists(file)) {
            if (overwrite) {
                this.delete(file);
            } else {
                throw new IOException("File already exists: " + file);
            }
        }
        if ((parent = file.getParent()) != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent);
        }
        Path absolute = this.makeAbsolute(file);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.create(srep, replication, bufferSize);
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        if (!this.exists(path)) {
            throw new IOException("File does not exist: " + path);
        }
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.open(srep, bufferSize);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        Path absoluteD;
        String srepD;
        Path absoluteS = this.makeAbsolute(src);
        String srepS = absoluteS.toUri().getPath();
        return this.kfsImpl.rename(srepS, srepD = (absoluteD = this.makeAbsolute(dst)).toUri().getPath()) == 0;
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        if (this.kfsImpl.isFile(srep)) {
            return this.kfsImpl.remove(srep) == 0;
        }
        FileStatus[] dirEntries = this.listStatus(absolute);
        if (!recursive && dirEntries != null && dirEntries.length != 0) {
            throw new IOException("Directory " + path.toString() + " is not empty.");
        }
        if (dirEntries != null) {
            for (int i = 0; i < dirEntries.length; ++i) {
                this.delete(new Path(absolute, dirEntries[i].getPath()), recursive);
            }
        }
        return this.kfsImpl.rmdir(srep) == 0;
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    @Deprecated
    public long getLength(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.filesize(srep);
    }

    @Deprecated
    public short getReplication(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.getReplication(srep);
    }

    public short getDefaultReplication() {
        return 3;
    }

    public boolean setReplication(Path path, short replication) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        short res = this.kfsImpl.setReplication(srep, replication);
        return res >= 0;
    }

    public long getDefaultBlockSize() {
        return 0x4000000L;
    }

    @Deprecated
    public void lock(Path path, boolean shared) throws IOException {
    }

    @Deprecated
    public void release(Path path) throws IOException {
    }

    public BlockLocation[] getBlockLocations(Path f, long start, long len) throws IOException {
        if (!this.exists(f)) {
            return null;
        }
        String srep = this.makeAbsolute(f).toUri().getPath();
        String[][] hints = this.kfsImpl.getDataLocation(srep, start, len);
        BlockLocation[] result = new BlockLocation[hints.length];
        long blockSize = this.getDefaultBlockSize();
        long length = len;
        for (int i = 0; i < result.length; ++i) {
            result[i] = new BlockLocation(null, hints[i], start, length < blockSize ? length : blockSize);
            length -= blockSize;
        }
        return result;
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this.localFs, src, this, dst, delSrc, this.getConf());
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, this.localFs, dst, delSrc, this.getConf());
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return tmpLocalFile;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.moveFromLocalFile(tmpLocalFile, fsOutputFile);
    }
}

