/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class ObjectWritable
implements Writable,
Configurable {
    private Class declaredClass;
    private Object instance;
    private Configuration conf;
    private static final Map<String, Class<?>> PRIMITIVE_NAMES = new HashMap();

    public ObjectWritable() {
    }

    public ObjectWritable(Object instance) {
        this.set(instance);
    }

    public ObjectWritable(Class declaredClass, Object instance) {
        this.declaredClass = declaredClass;
        this.instance = instance;
    }

    public Object get() {
        return this.instance;
    }

    public Class getDeclaredClass() {
        return this.declaredClass;
    }

    public void set(Object instance) {
        this.declaredClass = instance.getClass();
        this.instance = instance;
    }

    public String toString() {
        return "OW[class=" + this.declaredClass + ",value=" + this.instance + "]";
    }

    public void readFields(DataInput in) throws IOException {
        ObjectWritable.readObject(in, this, this.conf);
    }

    public void write(DataOutput out) throws IOException {
        ObjectWritable.writeObject(out, this.instance, this.declaredClass, this.conf);
    }

    public static void writeObject(DataOutput out, Object instance, Class declaredClass, Configuration conf) throws IOException {
        if (instance == null) {
            instance = new NullInstance(declaredClass, conf);
            declaredClass = Writable.class;
        }
        UTF8.writeString(out, declaredClass.getName());
        if (declaredClass.isArray()) {
            int length = Array.getLength(instance);
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                ObjectWritable.writeObject(out, Array.get(instance, i), declaredClass.getComponentType(), conf);
            }
        } else if (declaredClass == String.class) {
            UTF8.writeString(out, (String)instance);
        } else if (declaredClass.isPrimitive()) {
            if (declaredClass == Boolean.TYPE) {
                out.writeBoolean((Boolean)instance);
            } else if (declaredClass == Character.TYPE) {
                out.writeChar(((Character)instance).charValue());
            } else if (declaredClass == Byte.TYPE) {
                out.writeByte(((Byte)instance).byteValue());
            } else if (declaredClass == Short.TYPE) {
                out.writeShort(((Short)instance).shortValue());
            } else if (declaredClass == Integer.TYPE) {
                out.writeInt((Integer)instance);
            } else if (declaredClass == Long.TYPE) {
                out.writeLong((Long)instance);
            } else if (declaredClass == Float.TYPE) {
                out.writeFloat(((Float)instance).floatValue());
            } else if (declaredClass == Double.TYPE) {
                out.writeDouble((Double)instance);
            } else if (declaredClass != Void.TYPE) {
                throw new IllegalArgumentException("Not a primitive: " + declaredClass);
            }
        } else if (declaredClass.isEnum()) {
            UTF8.writeString(out, ((Enum)instance).name());
        } else if (Writable.class.isAssignableFrom(declaredClass)) {
            UTF8.writeString(out, instance.getClass().getName());
            ((Writable)instance).write(out);
        } else {
            throw new IOException("Can't write: " + instance + " as " + declaredClass);
        }
    }

    public static Object readObject(DataInput in, Configuration conf) throws IOException {
        return ObjectWritable.readObject(in, null, conf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readObject(DataInput in, ObjectWritable objectWritable, Configuration conf) throws IOException {
        Object instance;
        String className = UTF8.readString(in);
        Class declaredClass = PRIMITIVE_NAMES.get(className);
        if (declaredClass == null) {
            try {
                declaredClass = conf.getClassByName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("readObject can't find class", e);
            }
        }
        if (declaredClass.isPrimitive()) {
            if (declaredClass == Boolean.TYPE) {
                instance = in.readBoolean();
            } else if (declaredClass == Character.TYPE) {
                instance = Character.valueOf(in.readChar());
            } else if (declaredClass == Byte.TYPE) {
                instance = in.readByte();
            } else if (declaredClass == Short.TYPE) {
                instance = in.readShort();
            } else if (declaredClass == Integer.TYPE) {
                instance = in.readInt();
            } else if (declaredClass == Long.TYPE) {
                instance = in.readLong();
            } else if (declaredClass == Float.TYPE) {
                instance = Float.valueOf(in.readFloat());
            } else if (declaredClass == Double.TYPE) {
                instance = in.readDouble();
            } else {
                if (declaredClass != Void.TYPE) throw new IllegalArgumentException("Not a primitive: " + declaredClass);
                instance = null;
            }
        } else if (declaredClass.isArray()) {
            int length = in.readInt();
            instance = Array.newInstance(declaredClass.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(instance, i, ObjectWritable.readObject(in, conf));
            }
        } else if (declaredClass == String.class) {
            instance = UTF8.readString(in);
        } else if (declaredClass.isEnum()) {
            instance = Enum.valueOf(declaredClass, UTF8.readString(in));
        } else {
            Class<?> instanceClass = null;
            try {
                instanceClass = conf.getClassByName(UTF8.readString(in));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("readObject can't find class", e);
            }
            Writable writable = WritableFactories.newInstance(instanceClass, conf);
            writable.readFields(in);
            instance = writable;
            if (instanceClass == NullInstance.class) {
                declaredClass = ((NullInstance)instance).declaredClass;
                instance = null;
            }
        }
        if (objectWritable == null) return instance;
        objectWritable.declaredClass = declaredClass;
        objectWritable.instance = instance;
        return instance;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    static {
        PRIMITIVE_NAMES.put("boolean", Boolean.TYPE);
        PRIMITIVE_NAMES.put("byte", Byte.TYPE);
        PRIMITIVE_NAMES.put("char", Character.TYPE);
        PRIMITIVE_NAMES.put("short", Short.TYPE);
        PRIMITIVE_NAMES.put("int", Integer.TYPE);
        PRIMITIVE_NAMES.put("long", Long.TYPE);
        PRIMITIVE_NAMES.put("float", Float.TYPE);
        PRIMITIVE_NAMES.put("double", Double.TYPE);
        PRIMITIVE_NAMES.put("void", Void.TYPE);
    }

    private static class NullInstance
    extends Configured
    implements Writable {
        private Class<?> declaredClass;

        public NullInstance() {
            super(null);
        }

        public NullInstance(Class declaredClass, Configuration conf) {
            super(conf);
            this.declaredClass = declaredClass;
        }

        public void readFields(DataInput in) throws IOException {
            String className = UTF8.readString(in);
            this.declaredClass = (Class)PRIMITIVE_NAMES.get(className);
            if (this.declaredClass == null) {
                try {
                    this.declaredClass = this.getConf().getClassByName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }

        public void write(DataOutput out) throws IOException {
            UTF8.writeString(out, this.declaredClass.getName());
        }
    }
}

