/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.lzo;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.NativeCodeLoader;

public class LzoDecompressor
implements Decompressor {
    private static final Log LOG = LogFactory.getLog((String)LzoDecompressor.class.getName());
    private int directBufferSize;
    private Buffer compressedDirectBuf = null;
    private int compressedDirectBufLen;
    private Buffer uncompressedDirectBuf = null;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private boolean finished;
    private CompressionStrategy strategy;
    private long lzoDecompressor = 0L;
    private static boolean nativeLzoLoaded = false;

    public static boolean isNativeLzoLoaded() {
        return nativeLzoLoaded;
    }

    public LzoDecompressor(CompressionStrategy strategy, int directBufferSize) {
        this.directBufferSize = directBufferSize;
        this.strategy = strategy;
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.uncompressedDirectBuf.position(directBufferSize);
        this.init(this.strategy.getDecompressor());
    }

    public LzoDecompressor() {
        this(CompressionStrategy.LZO1X, 65536);
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.setInputFromSavedData();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
    }

    synchronized void setInputFromSavedData() {
        this.compressedDirectBufLen = this.userBufLen;
        if (this.compressedDirectBufLen > this.directBufferSize) {
            this.compressedDirectBufLen = this.directBufferSize;
        }
        this.compressedDirectBuf.rewind();
        ((ByteBuffer)this.compressedDirectBuf).put(this.userBuf, this.userBufOff, this.compressedDirectBufLen);
        this.userBufOff += this.compressedDirectBufLen;
        this.userBufLen -= this.compressedDirectBufLen;
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
    }

    public synchronized boolean needsInput() {
        if (this.uncompressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.compressedDirectBufLen <= 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
        }
        return false;
    }

    public synchronized boolean needsDictionary() {
        return false;
    }

    public synchronized boolean finished() {
        return this.finished && this.uncompressedDirectBuf.remaining() == 0;
    }

    public synchronized int decompress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = 0;
        n = this.uncompressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, n);
            return n;
        }
        if (this.compressedDirectBufLen <= 0) {
            return 0;
        }
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        n = this.decompressBytesDirect(this.strategy.getDecompressor());
        this.uncompressedDirectBuf.limit(n);
        if (this.userBufLen <= 0) {
            this.finished = true;
        }
        n = Math.min(n, len);
        ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, n);
        return n;
    }

    public synchronized void reset() {
        this.finished = false;
        this.compressedDirectBufLen = 0;
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
    }

    public synchronized void end() {
    }

    protected void finalize() {
        this.end();
    }

    private static native void initIDs();

    private native void init(int var1);

    private native int decompressBytesDirect(int var1);

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            LzoDecompressor.initIDs();
            nativeLzoLoaded = true;
        } else {
            LOG.error((Object)("Cannot load " + LzoDecompressor.class.getName() + " without native-hadoop library!"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressionStrategy {
        LZO1(0),
        LZO1A(1),
        LZO1B(2),
        LZO1B_SAFE(3),
        LZO1C(4),
        LZO1C_SAFE(5),
        LZO1C_ASM(6),
        LZO1C_ASM_SAFE(7),
        LZO1F(8),
        LZO1F_SAFE(9),
        LZO1F_ASM_FAST(10),
        LZO1F_ASM_FAST_SAFE(11),
        LZO1X(12),
        LZO1X_SAFE(13),
        LZO1X_ASM(14),
        LZO1X_ASM_SAFE(15),
        LZO1X_ASM_FAST(16),
        LZO1X_ASM_FAST_SAFE(17),
        LZO1Y(18),
        LZO1Y_SAFE(19),
        LZO1Y_ASM(20),
        LZO1Y_ASM_SAFE(21),
        LZO1Y_ASM_FAST(22),
        LZO1Y_ASM_FAST_SAFE(23),
        LZO1Z(24),
        LZO1Z_SAFE(25),
        LZO2A(26),
        LZO2A_SAFE(27);

        private final int decompressor;

        private CompressionStrategy(int decompressor) {
            this.decompressor = decompressor;
        }

        int getDecompressor() {
            return this.decompressor;
        }
    }
}

