/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.Client");
    private Hashtable<ConnectionId, Connection> connections = new Hashtable();
    private Class valueClass;
    private int timeout;
    private int counter;
    private boolean running = true;
    private Configuration conf;
    private int maxIdleTime;
    private int maxRetries;
    private boolean tcpNoDelay;
    private Thread connectionCullerThread;
    private SocketFactory socketFactory;
    private int refCount = 1;

    synchronized void incCount() {
        ++this.refCount;
    }

    synchronized void decCount() {
        --this.refCount;
    }

    synchronized boolean isZeroReference() {
        return this.refCount == 0;
    }

    public Client(Class valueClass, Configuration conf, SocketFactory factory) {
        this.valueClass = valueClass;
        this.timeout = conf.getInt("ipc.client.timeout", 10000);
        this.maxIdleTime = conf.getInt("ipc.client.connection.maxidletime", 1000);
        this.maxRetries = conf.getInt("ipc.client.connect.max.retries", 10);
        this.tcpNoDelay = conf.getBoolean("ipc.client.tcpnodelay", false);
        this.conf = conf;
        this.socketFactory = factory;
        this.connectionCullerThread = new ConnectionCuller();
        this.connectionCullerThread.setDaemon(true);
        this.connectionCullerThread.setName(valueClass.getName() + " Connection Culler");
        LOG.debug((Object)(valueClass.getName() + "Connection culler maxidletime= " + this.maxIdleTime + "ms"));
        this.connectionCullerThread.start();
    }

    public Client(Class<?> valueClass, Configuration conf) {
        this(valueClass, conf, NetUtils.getDefaultSocketFactory(conf));
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping client");
        }
        if (!this.running) {
            return;
        }
        this.running = false;
        this.connectionCullerThread.interrupt();
        try {
            this.connectionCullerThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Hashtable<ConnectionId, Connection> e = this.connections;
        synchronized (e) {
            Iterator<Connection> i$ = this.connections.values().iterator();
            while (i$.hasNext()) {
                Connection conn;
                Connection connection = conn = i$.next();
                synchronized (connection) {
                    conn.setCloseConnection();
                    conn.notifyAll();
                }
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Writable call(Writable param, InetSocketAddress address) throws InterruptedException, IOException {
        return this.call(param, address, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable call(Writable param, InetSocketAddress addr, UserGroupInformation ticket) throws InterruptedException, IOException {
        Call call;
        Connection connection = this.getConnection(addr, ticket);
        Call call2 = call = new Call(param);
        synchronized (call2) {
            connection.sendParam(call);
            long wait = this.timeout;
            do {
                call.wait(wait);
                wait = (long)this.timeout - (System.currentTimeMillis() - call.lastActivity);
            } while (!call.done && wait > 0L);
            if (call.error != null) {
                throw new RemoteException(call.errorClass, call.error);
            }
            if (!call.done) {
                throw new SocketTimeoutException("timed out waiting for rpc response");
            }
            return call.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses) throws IOException {
        ParallelResults results;
        if (addresses.length == 0) {
            return new Writable[0];
        }
        ParallelResults parallelResults = results = new ParallelResults(params.length);
        synchronized (parallelResults) {
            for (int i = 0; i < params.length; ++i) {
                ParallelCall call = new ParallelCall(params[i], results, i);
                try {
                    Connection connection = this.getConnection(addresses[i], null);
                    connection.sendParam(call);
                    continue;
                }
                catch (IOException e) {
                    LOG.info((Object)("Calling " + addresses[i] + " caught: " + StringUtils.stringifyException(e)));
                    results.size--;
                }
            }
            try {
                results.wait(this.timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (results.count == 0) {
                throw new IOException("no responses");
            }
            return results.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(InetSocketAddress addr, UserGroupInformation ticket) throws IOException {
        Connection connection;
        ConnectionId remoteId = new ConnectionId(addr, ticket);
        Hashtable<ConnectionId, Connection> hashtable = this.connections;
        synchronized (hashtable) {
            connection = this.connections.get(remoteId);
            if (connection == null) {
                connection = new Connection(remoteId);
                this.connections.put(remoteId, connection);
                connection.start();
            }
            connection.incrementRef();
        }
        connection.setupIOstreams();
        return connection;
    }

    private static class ConnectionId {
        InetSocketAddress address;
        UserGroupInformation ticket;

        ConnectionId(InetSocketAddress address, UserGroupInformation ticket) {
            this.address = address;
            this.ticket = ticket;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        UserGroupInformation getTicket() {
            return this.ticket;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionId) {
                ConnectionId id = (ConnectionId)obj;
                return this.address.equals(id.address) && this.ticket == id.ticket;
            }
            return false;
        }

        public int hashCode() {
            return this.address.hashCode() ^ System.identityHashCode(this.ticket);
        }
    }

    private class ConnectionCuller
    extends Thread {
        public static final int MIN_SLEEP_TIME = 1000;

        private ConnectionCuller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.debug((Object)(this.getName() + ": starting"));
            while (Client.this.running) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Hashtable hashtable = Client.this.connections;
                synchronized (hashtable) {
                    Iterator i = Client.this.connections.values().iterator();
                    while (i.hasNext()) {
                        Connection c = (Connection)i.next();
                        if (!c.isIdle()) continue;
                        i.remove();
                        Connection connection = c;
                        synchronized (connection) {
                            c.setCloseConnection();
                            c.notify();
                        }
                    }
                }
            }
        }
    }

    private static class ParallelResults {
        private Writable[] values;
        private int size;
        private int count;

        public ParallelResults(int size) {
            this.values = new Writable[size];
            this.size = size;
        }

        public synchronized void callComplete(ParallelCall call) {
            this.values[((ParallelCall)call).index] = call.value;
            ++this.count;
            if (this.count == this.size) {
                this.notify();
            }
        }
    }

    private class ParallelCall
    extends Call {
        private ParallelResults results;
        private int index;

        public ParallelCall(Writable param, ParallelResults results, int index) {
            super(param);
            this.results = results;
            this.index = index;
        }

        public void callComplete() {
            this.results.callComplete(this);
        }
    }

    private class Connection
    extends Thread {
        private ConnectionId remoteId;
        private Socket socket = null;
        private DataInputStream in;
        private DataOutputStream out;
        private Hashtable<Integer, Call> calls = new Hashtable();
        private Call readingCall;
        private Call writingCall;
        private int inUse = 0;
        private long lastActivity = 0L;
        private boolean shouldCloseConnection = false;

        public Connection(InetSocketAddress address) throws IOException {
            this(new ConnectionId(address, null));
        }

        public Connection(ConnectionId remoteId) throws IOException {
            if (remoteId.getAddress().isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            this.remoteId = remoteId;
            this.setName("IPC Client connection to " + remoteId.getAddress().toString());
            this.setDaemon(true);
        }

        public synchronized void setupIOstreams() throws IOException {
            if (this.socket != null) {
                this.notify();
                return;
            }
            int failures = 0;
            while (true) {
                try {
                    this.socket = Client.this.socketFactory.createSocket();
                    this.socket.setTcpNoDelay(Client.this.tcpNoDelay);
                    this.socket.connect(this.remoteId.getAddress(), 60000);
                }
                catch (IOException ie) {
                    if (failures == Client.this.maxRetries) {
                        this.inUse = 0;
                        this.socket.close();
                        this.socket = null;
                        throw ie;
                    }
                    failures = (short)(failures + 1);
                    LOG.info((Object)("Retrying connect to server: " + this.remoteId.getAddress() + ". Already tried " + failures + " time(s)."));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
            this.socket.setSoTimeout(Client.this.timeout);
            this.in = new DataInputStream(new BufferedInputStream(new FilterInputStream(NetUtils.getInputStream(this.socket)){

                public int read(byte[] buf, int off, int len) throws IOException {
                    int value = super.read(buf, off, len);
                    if (Connection.this.readingCall != null) {
                        Connection.this.readingCall.touch();
                    }
                    return value;
                }
            }));
            this.out = new DataOutputStream(new BufferedOutputStream(new FilterOutputStream(NetUtils.getOutputStream(this.socket)){

                public void write(byte[] buf, int o, int len) throws IOException {
                    this.out.write(buf, o, len);
                    if (Connection.this.writingCall != null) {
                        Connection.this.writingCall.touch();
                    }
                }
            }));
            this.writeHeader();
            this.notify();
        }

        private synchronized void writeHeader() throws IOException {
            this.out.write(Server.HEADER.array());
            this.out.write(1);
            DataOutputBuffer buf = new DataOutputBuffer();
            ObjectWritable.writeObject(buf, this.remoteId.getTicket(), UserGroupInformation.class, Client.this.conf);
            int bufLen = buf.getLength();
            this.out.writeInt(bufLen);
            this.out.write(buf.getData(), 0, bufLen);
        }

        private synchronized boolean waitForWork() {
            while (!(this.inUse != 0 && this.socket != null || this.shouldCloseConnection)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return !this.shouldCloseConnection;
        }

        private synchronized void incrementRef() {
            ++this.inUse;
        }

        private synchronized void decrementRef() {
            this.lastActivity = System.currentTimeMillis();
            --this.inUse;
        }

        public synchronized boolean isIdle() {
            if (this.inUse != 0) {
                return false;
            }
            long currTime = System.currentTimeMillis();
            return currTime - this.lastActivity > (long)Client.this.maxIdleTime;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteId.getAddress();
        }

        public void setCloseConnection() {
            this.shouldCloseConnection = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": starting"));
            }
            try {
                while (Client.this.running) {
                    int id;
                    if (!this.waitForWork()) {
                        break;
                    }
                    try {
                        id = this.in.readInt();
                    }
                    catch (SocketTimeoutException e) {
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + " got value #" + id));
                    }
                    Call call = this.calls.remove(id);
                    boolean isError = this.in.readBoolean();
                    if (isError) {
                        call.setResult(null, WritableUtils.readString(this.in), WritableUtils.readString(this.in));
                    } else {
                        Writable value = (Writable)ReflectionUtils.newInstance(Client.this.valueClass, Client.this.conf);
                        try {
                            this.readingCall = call;
                            value.readFields(this.in);
                        }
                        finally {
                            this.readingCall = null;
                        }
                        call.setResult(value, null, null);
                    }
                    call.callComplete();
                    this.decrementRef();
                }
            }
            catch (EOFException eof) {
            }
            catch (Exception e) {
                LOG.info((Object)StringUtils.stringifyException(e));
            }
            finally {
                Hashtable hashtable = Client.this.connections;
                synchronized (hashtable) {
                    if (Client.this.connections.get(this.remoteId) == this) {
                        Client.this.connections.remove(this.remoteId);
                    }
                }
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendParam(Call call) throws IOException {
            Object object;
            boolean error = true;
            try {
                this.calls.put(call.id, call);
                object = this.out;
                synchronized (object) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + " sending #" + call.id));
                    }
                    try {
                        this.writingCall = call;
                        DataOutputBuffer d = new DataOutputBuffer();
                        d.writeInt(call.id);
                        call.param.write(d);
                        byte[] data = d.getData();
                        int dataLength = d.getLength();
                        this.out.writeInt(dataLength);
                        this.out.write(data, 0, dataLength);
                        this.out.flush();
                    }
                    finally {
                        this.writingCall = null;
                    }
                }
                error = false;
            }
            finally {
                if (error) {
                    object = Client.this.connections;
                    synchronized (object) {
                        if (Client.this.connections.get(this.remoteId) == this) {
                            Client.this.connections.remove(this.remoteId);
                        }
                    }
                    this.close();
                }
            }
        }

        public void close() {
            if (this.socket == null) {
                return;
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closing"));
            }
        }
    }

    private class Call {
        int id;
        Writable param;
        Writable value;
        String error;
        String errorClass;
        long lastActivity;
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Call(Writable param) {
            this.param = param;
            Client client2 = Client.this;
            synchronized (client2) {
                this.id = Client.this.counter++;
            }
            this.touch();
        }

        public synchronized void callComplete() {
            this.notify();
        }

        public synchronized void touch() {
            this.lastActivity = System.currentTimeMillis();
        }

        public synchronized void setResult(Writable value, String errorClass, String error) {
            this.value = value;
            this.error = error;
            this.errorClass = errorClass;
            this.done = true;
        }
    }
}

