/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobHistory {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.JobHistory");
    private static final String DELIMITER = " ";
    private static final String KEY = "(\\w+)";
    private static final String VALUE = "[[^\"]?]+";
    private static final Pattern pattern = Pattern.compile("(\\w+)=\"[[^\"]?]+\"");
    public static final String JOBTRACKER_START_TIME = String.valueOf(System.currentTimeMillis());
    private static String JOBTRACKER_UNIQUE_STRING = null;
    private static String LOG_DIR = null;
    private static Map<String, ArrayList<PrintWriter>> openJobs = new HashMap<String, ArrayList<PrintWriter>>();
    private static boolean disableHistory = false;
    private static Map<Keys, String> parseBuffer = new HashMap<Keys, String>();

    public static boolean init(JobConf conf, String hostname) {
        try {
            LOG_DIR = conf.get("hadoop.job.history.location", "file:///" + new File(System.getProperty("hadoop.log.dir")).getAbsolutePath() + File.separator + "history");
            JOBTRACKER_UNIQUE_STRING = hostname + "_" + JOBTRACKER_START_TIME + "_";
            Path logDir = new Path(LOG_DIR);
            FileSystem fs = logDir.getFileSystem(conf);
            if (!fs.exists(logDir) && !fs.mkdirs(logDir)) {
                throw new IOException("Mkdirs failed to create " + logDir.toString());
            }
            conf.set("hadoop.job.history.location", LOG_DIR);
            disableHistory = false;
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to initialize JobHistory log file", (Throwable)e);
            disableHistory = true;
        }
        return !disableHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseHistoryFromFS(String path, Listener l, FileSystem fs) throws IOException {
        FSDataInputStream in = fs.open(new Path(path));
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            StringBuffer buf = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                if (!line.trim().endsWith("\"")) continue;
                JobHistory.parseLine(buf.toString(), l);
                buf = new StringBuffer();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {}
        }
    }

    private static void parseLine(String line, Listener l) throws IOException {
        int idx = line.indexOf(32);
        String recType = line.substring(0, idx);
        String data = line.substring(idx + 1, line.length());
        Matcher matcher = pattern.matcher(data);
        while (matcher.find()) {
            String tuple = matcher.group(0);
            String[] parts = tuple.split("=");
            parseBuffer.put(Keys.valueOf(parts[0]), parts[1].substring(1, parts[1].length() - 1));
        }
        l.handle(RecordTypes.valueOf(recType), parseBuffer);
        parseBuffer.clear();
    }

    static void log(PrintWriter out, RecordTypes recordType, Keys key, String value) {
        out.println(recordType.name() + DELIMITER + (Object)((Object)key) + "=\"" + value + "\"");
    }

    static void log(ArrayList<PrintWriter> writers, RecordTypes recordType, Keys[] keys, String[] values) {
        StringBuffer buf = new StringBuffer(recordType.name());
        buf.append(DELIMITER);
        for (int i = 0; i < keys.length; ++i) {
            buf.append((Object)keys[i]);
            buf.append("=\"");
            buf.append(values[i]);
            buf.append("\"");
            buf.append(DELIMITER);
        }
        for (PrintWriter out : writers) {
            out.println(buf.toString());
        }
    }

    public static boolean isDisableHistory() {
        return disableHistory;
    }

    public static void setDisableHistory(boolean disableHistory) {
        JobHistory.disableHistory = disableHistory;
    }

    public static class HistoryCleaner
    implements Runnable {
        static final long ONE_DAY_IN_MS = 86400000L;
        static final long THIRTY_DAYS_IN_MS = 2592000000L;
        private long now;
        private static boolean isRunning = false;
        private static long lastRan;

        public void run() {
            File[] oldFiles;
            if (isRunning) {
                return;
            }
            this.now = System.currentTimeMillis();
            if (lastRan == 0L || this.now - lastRan < 86400000L) {
                return;
            }
            lastRan = this.now;
            isRunning = true;
            for (File f : oldFiles = new File(LOG_DIR).listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return HistoryCleaner.this.now - file.lastModified() > 2592000000L;
                }
            })) {
                f.delete();
                LOG.info((Object)("Deleting old history file : " + f.getName()));
            }
            isRunning = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener {
        public void handle(RecordTypes var1, Map<Keys, String> var2) throws IOException;
    }

    public static class ReduceAttempt
    extends TaskAttempt {
        public static void logStarted(String jobId, String taskId, String taskAttemptId, long startTime, String hostName) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.START_TIME, Keys.HOSTNAME}, new String[]{Values.REDUCE.name(), taskId, taskAttemptId, String.valueOf(startTime), hostName});
            }
        }

        public static void logFinished(String jobId, String taskId, String taskAttemptId, long shuffleFinished, long sortFinished, long finishTime, String hostName) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.SHUFFLE_FINISHED, Keys.SORT_FINISHED, Keys.FINISH_TIME, Keys.HOSTNAME}, new String[]{Values.REDUCE.name(), taskId, taskAttemptId, Values.SUCCESS.name(), String.valueOf(shuffleFinished), String.valueOf(sortFinished), String.valueOf(finishTime), hostName});
            }
        }

        public static void logFailed(String jobId, String taskId, String taskAttemptId, long timestamp, String hostName, String error) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{Values.REDUCE.name(), taskId, taskAttemptId, Values.FAILED.name(), String.valueOf(timestamp), hostName, error});
            }
        }

        public static void logKilled(String jobId, String taskId, String taskAttemptId, long timestamp, String hostName, String error) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{Values.REDUCE.name(), taskId, taskAttemptId, Values.KILLED.name(), String.valueOf(timestamp), hostName, error});
            }
        }
    }

    public static class MapAttempt
    extends TaskAttempt {
        public static void logStarted(String jobId, String taskId, String taskAttemptId, long startTime, String hostName) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.START_TIME, Keys.HOSTNAME}, new String[]{Values.MAP.name(), taskId, taskAttemptId, String.valueOf(startTime), hostName});
            }
        }

        public static void logFinished(String jobId, String taskId, String taskAttemptId, long finishTime, String hostName) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME}, new String[]{Values.MAP.name(), taskId, taskAttemptId, Values.SUCCESS.name(), String.valueOf(finishTime), hostName});
            }
        }

        public static void logFailed(String jobId, String taskId, String taskAttemptId, long timestamp, String hostName, String error) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{Values.MAP.name(), taskId, taskAttemptId, Values.FAILED.name(), String.valueOf(timestamp), hostName, error});
            }
        }

        public static void logKilled(String jobId, String taskId, String taskAttemptId, long timestamp, String hostName, String error) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{Values.MAP.name(), taskId, taskAttemptId, Values.KILLED.name(), String.valueOf(timestamp), hostName, error});
            }
        }
    }

    public static class TaskAttempt
    extends Task {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Task
    extends KeyValuePair {
        private Map<String, TaskAttempt> taskAttempts = new TreeMap<String, TaskAttempt>();

        public static void logStarted(String jobId, String taskId, String taskType, long startTime) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.TASK_TYPE, Keys.START_TIME}, new String[]{taskId, taskType, String.valueOf(startTime)});
            }
        }

        public static void logFinished(String jobId, String taskId, String taskType, long finishTime, Counters counters) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.TASK_TYPE, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.COUNTERS}, new String[]{taskId, taskType, Values.SUCCESS.name(), String.valueOf(finishTime), counters.makeCompactString()});
            }
        }

        public static void logFailed(String jobId, String taskId, String taskType, long time, String error) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + jobId))) {
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.TASK_TYPE, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.ERROR}, new String[]{taskId, taskType, Values.FAILED.name(), String.valueOf(time), error});
            }
        }

        public Map<String, TaskAttempt> getTaskAttempts() {
            return this.taskAttempts;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JobInfo
    extends KeyValuePair {
        private Map<String, Task> allTasks = new TreeMap<String, Task>();

        public JobInfo(String jobId) {
            this.set(Keys.JOBID, jobId);
        }

        public Map<String, Task> getAllTasks() {
            return this.allTasks;
        }

        public static String getLocalJobFilePath(String jobId) {
            return System.getProperty("hadoop.log.dir") + File.separator + jobId + "_conf.xml";
        }

        public static String encodeJobHistoryFilePath(String logFile) throws IOException {
            Path rawPath = new Path(logFile);
            String encodedFileName = null;
            try {
                encodedFileName = URLEncoder.encode(rawPath.getName(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                IOException ioe = new IOException();
                ioe.initCause(uee);
                ioe.setStackTrace(uee.getStackTrace());
                throw ioe;
            }
            Path encodedPath = new Path(rawPath.getParent(), encodedFileName);
            return encodedPath.toString();
        }

        public static String encodeJobHistoryFileName(String logFileName) throws IOException {
            String encodedFileName = null;
            try {
                encodedFileName = URLEncoder.encode(logFileName, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                IOException ioe = new IOException();
                ioe.initCause(uee);
                ioe.setStackTrace(uee.getStackTrace());
                throw ioe;
            }
            return encodedFileName;
        }

        public static String decodeJobHistoryFileName(String logFileName) throws IOException {
            String decodedFileName = null;
            try {
                decodedFileName = URLDecoder.decode(logFileName, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                IOException ioe = new IOException();
                ioe.initCause(uee);
                ioe.setStackTrace(uee.getStackTrace());
                throw ioe;
            }
            return decodedFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void logSubmitted(String jobId, JobConf jobConf, String jobConfPath, long submitTime) throws IOException {
            FileSystem fs = null;
            String userLogDir = null;
            String jobUniqueString = JOBTRACKER_UNIQUE_STRING + jobId;
            if (!disableHistory) {
                String user;
                String jobName = jobConf.getJobName();
                if (jobName == null || jobName.length() == 0) {
                    jobName = "NA";
                }
                if ((user = jobConf.getUser()) == null || user.length() == 0) {
                    user = "NA";
                }
                String logFileName = JobInfo.encodeJobHistoryFileName(jobUniqueString + "_" + user + "_" + jobName);
                Path outputPath = FileOutputFormat.getOutputPath(jobConf);
                userLogDir = jobConf.get("hadoop.job.history.user.location", outputPath == null ? null : outputPath.toString());
                if ("none".equals(userLogDir)) {
                    userLogDir = null;
                }
                if (userLogDir != null) {
                    userLogDir = userLogDir + "/" + "_logs" + "/" + "history";
                }
                Path logFile = null;
                Path userLogFile = null;
                if (LOG_DIR != null) {
                    logFile = new Path(LOG_DIR, logFileName);
                }
                if (userLogDir != null) {
                    userLogFile = new Path(userLogDir, logFileName);
                }
                try {
                    ArrayList<PrintWriter> writers = new ArrayList<PrintWriter>();
                    FSDataOutputStream out = null;
                    PrintWriter writer = null;
                    if (LOG_DIR != null) {
                        fs = new Path(LOG_DIR).getFileSystem(jobConf);
                        out = fs.create(logFile, true, 4096);
                        writer = new PrintWriter(out);
                        writers.add(writer);
                    }
                    if (userLogDir != null) {
                        fs = new Path(userLogDir).getFileSystem(jobConf);
                        out = fs.create(userLogFile, true, 4096);
                        writer = new PrintWriter(out);
                        writers.add(writer);
                    }
                    openJobs.put(jobUniqueString, writers);
                    JobHistory.log(writers, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.JOBNAME, Keys.USER, Keys.SUBMIT_TIME, Keys.JOBCONF}, new String[]{jobId, jobName, user, String.valueOf(submitTime), jobConfPath});
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed creating job history log file, disabling history", (Throwable)e);
                    disableHistory = true;
                }
            }
            String localJobFilePath = JobInfo.getLocalJobFilePath(jobId);
            File localJobFile = new File(localJobFilePath);
            FileOutputStream jobOut = null;
            try {
                jobOut = new FileOutputStream(localJobFile);
                jobConf.write(jobOut);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Job conf for " + jobId + " stored at " + localJobFile.getAbsolutePath()));
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"Failed to store job conf on the local filesystem ", (Throwable)ioe);
            }
            finally {
                if (jobOut != null) {
                    try {
                        jobOut.close();
                    }
                    catch (IOException ie) {
                        LOG.info((Object)("Failed to close the job configuration file " + StringUtils.stringifyException(ie)));
                    }
                }
            }
            Path jobFilePath = null;
            if (LOG_DIR != null) {
                jobFilePath = new Path(LOG_DIR + File.separator + jobUniqueString + "_conf.xml");
            }
            Path userJobFilePath = null;
            if (userLogDir != null) {
                userJobFilePath = new Path(userLogDir + File.separator + jobUniqueString + "_conf.xml");
            }
            FSDataOutputStream jobFileOut = null;
            try {
                if (LOG_DIR != null && !(fs = new Path(LOG_DIR).getFileSystem(jobConf)).exists(jobFilePath)) {
                    jobFileOut = fs.create(jobFilePath);
                    jobConf.write(jobFileOut);
                    jobFileOut.close();
                }
                if (userLogDir != null) {
                    fs = new Path(userLogDir).getFileSystem(jobConf);
                    jobFileOut = fs.create(userJobFilePath);
                    jobConf.write(jobFileOut);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Job conf for " + jobId + " stored at " + jobFilePath + "and" + userJobFilePath));
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"Failed to store job conf on the local filesystem ", (Throwable)ioe);
            }
            finally {
                if (jobFileOut != null) {
                    try {
                        jobFileOut.close();
                    }
                    catch (IOException ie) {
                        LOG.info((Object)("Failed to close the job configuration file " + StringUtils.stringifyException(ie)));
                    }
                }
            }
        }

        public static void logStarted(String jobId, long startTime, int totalMaps, int totalReduces) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobId;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.LAUNCH_TIME, Keys.TOTAL_MAPS, Keys.TOTAL_REDUCES}, new String[]{jobId, String.valueOf(startTime), String.valueOf(totalMaps), String.valueOf(totalReduces)});
                }
            }
        }

        public static void logFinished(String jobId, long finishTime, int finishedMaps, int finishedReduces, int failedMaps, int failedReduces, Counters counters) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobId;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES, Keys.FAILED_MAPS, Keys.FAILED_REDUCES, Keys.COUNTERS}, new String[]{jobId, Long.toString(finishTime), Values.SUCCESS.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces), String.valueOf(failedMaps), String.valueOf(failedReduces), counters.makeCompactString()});
                    for (PrintWriter out : writer) {
                        out.close();
                    }
                    openJobs.remove(logFileKey);
                }
                Thread historyCleaner = new Thread(new HistoryCleaner());
                historyCleaner.start();
            }
        }

        public static void logFailed(String jobid, long timestamp, int finishedMaps, int finishedReduces) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobid;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES}, new String[]{jobid, String.valueOf(timestamp), Values.FAILED.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces)});
                    for (PrintWriter out : writer) {
                        out.close();
                    }
                    openJobs.remove(logFileKey);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyValuePair {
        private Map<Keys, String> values = new HashMap<Keys, String>();

        KeyValuePair() {
        }

        public String get(Keys k) {
            String s = this.values.get((Object)k);
            return s == null ? "" : s;
        }

        public int getInt(Keys k) {
            String s = this.values.get((Object)k);
            if (null != s) {
                return Integer.parseInt(s);
            }
            return 0;
        }

        public long getLong(Keys k) {
            String s = this.values.get((Object)k);
            if (null != s) {
                return Long.parseLong(s);
            }
            return 0L;
        }

        public void set(Keys k, String s) {
            this.values.put(k, s);
        }

        public void set(Map<Keys, String> m) {
            this.values.putAll(m);
        }

        public synchronized void handle(Map<Keys, String> values) {
            this.set(values);
        }

        public Map<Keys, String> getValues() {
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Values {
        SUCCESS,
        FAILED,
        KILLED,
        MAP,
        REDUCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keys {
        JOBTRACKERID,
        START_TIME,
        FINISH_TIME,
        JOBID,
        JOBNAME,
        USER,
        JOBCONF,
        SUBMIT_TIME,
        LAUNCH_TIME,
        TOTAL_MAPS,
        TOTAL_REDUCES,
        FAILED_MAPS,
        FAILED_REDUCES,
        FINISHED_MAPS,
        FINISHED_REDUCES,
        JOB_STATUS,
        TASKID,
        HOSTNAME,
        TASK_TYPE,
        ERROR,
        TASK_ATTEMPT_ID,
        TASK_STATUS,
        COPY_PHASE,
        SORT_PHASE,
        REDUCE_PHASE,
        SHUFFLE_FINISHED,
        SORT_FINISHED,
        COUNTERS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecordTypes {
        Jobtracker,
        Job,
        Task,
        MapAttempt,
        ReduceAttempt;

    }
}

