/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineRecordReader
implements RecordReader<LongWritable, Text> {
    private CompressionCodecFactory compressionCodecs = null;
    private long start;
    private long pos;
    private long end;
    private LineReader in;

    public LineRecordReader(Configuration job, FileSplit split) throws IOException {
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        this.compressionCodecs = new CompressionCodecFactory(job);
        CompressionCodec codec = this.compressionCodecs.getCodec(file);
        FileSystem fs = file.getFileSystem(job);
        FSDataInputStream fileIn = fs.open(split.getPath());
        boolean skipFirstLine = false;
        if (codec != null) {
            this.in = new LineReader((InputStream)codec.createInputStream(fileIn), job);
            this.end = Long.MAX_VALUE;
        } else {
            if (this.start != 0L) {
                skipFirstLine = true;
                --this.start;
                fileIn.seek(this.start);
            }
            this.in = new LineReader((InputStream)fileIn, job);
        }
        if (skipFirstLine) {
            this.start += (long)this.in.readLine(new Text());
        }
        this.pos = this.start;
    }

    public LineRecordReader(InputStream in, long offset, long endOffset) {
        this.in = new LineReader(in, 65536);
        this.start = offset;
        this.pos = offset;
        this.end = endOffset;
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, Configuration job) throws IOException {
        this.in = new LineReader(in, job);
        this.start = offset;
        this.pos = offset;
        this.end = endOffset;
    }

    @Override
    public LongWritable createKey() {
        return new LongWritable();
    }

    @Override
    public Text createValue() {
        return new Text();
    }

    @Override
    public synchronized boolean next(LongWritable key, Text value) throws IOException {
        if (this.pos >= this.end) {
            return false;
        }
        key.set(this.pos);
        int newSize = this.in.readLine(value);
        if (newSize > 0) {
            this.pos += (long)newSize;
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public static class LineReader {
        private static final int DEFAULT_BUFFER_SIZE = 65536;
        private int bufferSize = 65536;
        private InputStream in;
        private byte[] buffer;
        private int bufferLength = 0;
        private int bufferPosn = 0;

        LineReader(InputStream in, int bufferSize) {
            this.in = in;
            this.bufferSize = bufferSize;
            this.buffer = new byte[this.bufferSize];
        }

        public LineReader(InputStream in, Configuration conf) throws IOException {
            this(in, conf.getInt("io.file.buffer.size", 65536));
        }

        boolean backfill() throws IOException {
            this.bufferPosn = 0;
            this.bufferLength = this.in.read(this.buffer);
            return this.bufferLength > 0;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public int readLine(Text str) throws IOException {
            int length;
            str.clear();
            boolean hadFinalNewline = false;
            boolean hadFinalReturn = false;
            boolean hitEndOfFile = false;
            int startPosn = this.bufferPosn;
            block4: while (true) {
                if (this.bufferPosn >= this.bufferLength && !this.backfill()) {
                    hitEndOfFile = true;
                    break;
                }
                startPosn = this.bufferPosn;
                while (this.bufferPosn < this.bufferLength) {
                    switch (this.buffer[this.bufferPosn]) {
                        case 10: {
                            hadFinalNewline = true;
                            ++this.bufferPosn;
                            break block4;
                        }
                        case 13: {
                            if (hadFinalReturn) break block4;
                            hadFinalReturn = true;
                            break;
                        }
                        default: {
                            if (hadFinalReturn) break block4;
                        }
                    }
                    ++this.bufferPosn;
                }
                int length2 = this.bufferPosn - startPosn - (hadFinalReturn ? 1 : 0);
                if (length2 < 0) continue;
                str.append(this.buffer, startPosn, length2);
            }
            int newlineLength = (hadFinalNewline ? 1 : 0) + (hadFinalReturn ? 1 : 0);
            if (!hitEndOfFile && (length = this.bufferPosn - startPosn - newlineLength) > 0) {
                str.append(this.buffer, startPosn, length);
            }
            return str.getLength() + newlineLength;
        }
    }
}

