/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class TaskCompletionEvent
implements Writable {
    private int eventId;
    private String taskTrackerHttp;
    private int taskRunTime;
    private String taskId;
    Status status;
    boolean isMap = false;
    private int idWithinJob;
    public static final TaskCompletionEvent[] EMPTY_ARRAY = new TaskCompletionEvent[0];

    public TaskCompletionEvent() {
    }

    public TaskCompletionEvent(int eventId, String taskId, int idWithinJob, boolean isMap, Status status, String taskTrackerHttp) {
        this.taskId = taskId;
        this.idWithinJob = idWithinJob;
        this.isMap = isMap;
        this.eventId = eventId;
        this.status = status;
        this.taskTrackerHttp = taskTrackerHttp;
    }

    public int getEventId() {
        return this.eventId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Status getTaskStatus() {
        return this.status;
    }

    public String getTaskTrackerHttp() {
        return this.taskTrackerHttp;
    }

    public int getTaskRunTime() {
        return this.taskRunTime;
    }

    public void setTaskRunTime(int taskCompletionTime) {
        this.taskRunTime = taskCompletionTime;
    }

    public void setEventId(int eventId) {
        this.eventId = eventId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskStatus(Status status) {
        this.status = status;
    }

    public void setTaskTrackerHttp(String taskTrackerHttp) {
        this.taskTrackerHttp = taskTrackerHttp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Task Id : ");
        buf.append(this.taskId);
        buf.append(", Status : ");
        buf.append(this.status.name());
        return buf.toString();
    }

    public boolean isMapTask() {
        return this.isMap;
    }

    public int idWithinJob() {
        return this.idWithinJob;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeString(out, this.taskId);
        WritableUtils.writeVInt(out, this.idWithinJob);
        out.writeBoolean(this.isMap);
        WritableUtils.writeEnum(out, this.status);
        WritableUtils.writeString(out, this.taskTrackerHttp);
        WritableUtils.writeVInt(out, this.taskRunTime);
    }

    public void readFields(DataInput in) throws IOException {
        this.taskId = WritableUtils.readString(in);
        this.idWithinJob = WritableUtils.readVInt(in);
        this.isMap = in.readBoolean();
        this.status = WritableUtils.readEnum(in, Status.class);
        this.taskTrackerHttp = WritableUtils.readString(in);
        this.taskRunTime = WritableUtils.readVInt(in);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        FAILED,
        KILLED,
        SUCCEEDED,
        OBSOLETE,
        TIPFAILED;

    }
}

