/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapred.JobConf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskLog {
    private static final Log LOG = LogFactory.getLog((String)TaskLog.class.getName());
    private static final File LOG_DIR = new File(System.getProperty("hadoop.log.dir"), "userlogs").getAbsoluteFile();
    private static final String bashCommand = "bash";
    private static final String tailCommand = "tail";

    public static File getTaskLogFile(String taskid, LogName filter) {
        return new File(new File(LOG_DIR, taskid), filter.toString());
    }

    public static synchronized void cleanup(int logsRetainHours) throws IOException {
        long purgeTimeStamp = System.currentTimeMillis() - (long)logsRetainHours * 60L * 60L * 1000L;
        File[] oldTaskLogs = LOG_DIR.listFiles(new TaskLogsPurgeFilter(purgeTimeStamp));
        if (oldTaskLogs != null) {
            for (int i = 0; i < oldTaskLogs.length; ++i) {
                FileUtil.fullyDelete(oldTaskLogs[i]);
            }
        }
    }

    public static long getTaskLogLength(JobConf conf) {
        return conf.getLong("mapred.userlog.limit.kb", 100L) * 1024L;
    }

    public static List<String> captureOutAndError(List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength) throws IOException {
        return TaskLog.captureOutAndError(null, cmd, stdoutFilename, stderrFilename, tailLength);
    }

    public static List<String> captureOutAndError(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength) throws IOException {
        String stdout = FileUtil.makeShellPath(stdoutFilename);
        String stderr = FileUtil.makeShellPath(stderrFilename);
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(bashCommand);
        result.add("-c");
        StringBuffer mergedCmd = new StringBuffer();
        if (setup != null && setup.size() > 0) {
            mergedCmd.append(TaskLog.addCommand(setup, false));
            mergedCmd.append(";");
        }
        if (tailLength > 0L) {
            mergedCmd.append("(");
        } else {
            mergedCmd.append("exec ");
        }
        mergedCmd.append(TaskLog.addCommand(cmd, true));
        mergedCmd.append(" < /dev/null ");
        if (tailLength > 0L) {
            mergedCmd.append(" | ");
            mergedCmd.append(tailCommand);
            mergedCmd.append(" -c ");
            mergedCmd.append(tailLength);
            mergedCmd.append(" >> ");
            mergedCmd.append(stdout);
            mergedCmd.append(" ; exit $PIPESTATUS ) 2>&1 | ");
            mergedCmd.append(tailCommand);
            mergedCmd.append(" -c ");
            mergedCmd.append(tailLength);
            mergedCmd.append(" >> ");
            mergedCmd.append(stderr);
            mergedCmd.append(" ; exit $PIPESTATUS");
        } else {
            mergedCmd.append(" 1>> ");
            mergedCmd.append(stdout);
            mergedCmd.append(" 2>> ");
            mergedCmd.append(stderr);
        }
        result.add(mergedCmd.toString());
        return result;
    }

    public static String addCommand(List<String> cmd, boolean isExecutable) throws IOException {
        StringBuffer command = new StringBuffer();
        for (String s : cmd) {
            command.append('\'');
            if (isExecutable) {
                command.append(FileUtil.makeShellPath(new File(s)));
                isExecutable = false;
            } else {
                command.append(s);
            }
            command.append('\'');
            command.append(" ");
        }
        return command.toString();
    }

    public static List<String> captureDebugOut(List<String> cmd, File debugoutFilename) throws IOException {
        String debugout = FileUtil.makeShellPath(debugoutFilename);
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(bashCommand);
        result.add("-c");
        StringBuffer mergedCmd = new StringBuffer();
        mergedCmd.append("exec ");
        boolean isExecutable = true;
        for (String s : cmd) {
            if (isExecutable) {
                mergedCmd.append(FileUtil.makeShellPath(new File(s)));
                isExecutable = false;
            } else {
                mergedCmd.append(s);
            }
            mergedCmd.append(" ");
        }
        mergedCmd.append(" < /dev/null ");
        mergedCmd.append(" >");
        mergedCmd.append(debugout);
        mergedCmd.append(" 2>&1 ");
        result.add(mergedCmd.toString());
        return result;
    }

    static {
        if (!LOG_DIR.exists()) {
            LOG_DIR.mkdirs();
        }
    }

    public static class Reader
    extends InputStream {
        private long bytesRemaining;
        private FileInputStream file;

        public Reader(String taskid, LogName kind, long start, long end) throws IOException {
            long result;
            File filename = TaskLog.getTaskLogFile(taskid, kind);
            long size = filename.length();
            if (start < 0L) {
                start += size + 1L;
            }
            if (end < 0L) {
                end += size + 1L;
            }
            start = Math.max(0L, Math.min(start, size));
            end = Math.max(0L, Math.min(end, size));
            this.bytesRemaining = end - start;
            this.file = new FileInputStream(filename);
            for (long pos = 0L; pos < start; pos += result) {
                result = this.file.skip(start - pos);
                if (result >= 0L) continue;
                this.bytesRemaining = 0L;
                break;
            }
        }

        public int read() throws IOException {
            int result = -1;
            if (this.bytesRemaining > 0L) {
                --this.bytesRemaining;
                result = this.file.read();
            }
            return result;
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            int bytes = this.file.read(buffer, offset, length = (int)Math.min((long)length, this.bytesRemaining));
            if (bytes > 0) {
                this.bytesRemaining -= (long)bytes;
            }
            return bytes;
        }

        public int available() throws IOException {
            return (int)Math.min(this.bytesRemaining, (long)this.file.available());
        }

        public void close() throws IOException {
            this.file.close();
        }
    }

    private static class TaskLogsPurgeFilter
    implements FileFilter {
        long purgeTimeStamp;

        TaskLogsPurgeFilter(long purgeTimeStamp) {
            this.purgeTimeStamp = purgeTimeStamp;
        }

        public boolean accept(File file) {
            LOG.debug((Object)("PurgeFilter - file: " + file + ", mtime: " + file.lastModified() + ", purge: " + this.purgeTimeStamp));
            return file.lastModified() < this.purgeTimeStamp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogName {
        STDOUT("stdout"),
        STDERR("stderr"),
        SYSLOG("syslog"),
        PROFILE("profile.out"),
        DEBUGOUT("debugout");

        private String prefix;

        private LogName(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

