/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.mapred.TaskStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskTrackerStatus
implements Writable {
    String trackerName;
    String host;
    int httpPort;
    int failures;
    List<TaskStatus> taskReports;
    volatile long lastSeen;
    private int maxMapTasks;
    private int maxReduceTasks;

    public TaskTrackerStatus() {
        this.taskReports = new ArrayList<TaskStatus>();
    }

    public TaskTrackerStatus(String trackerName, String host, int httpPort, List<TaskStatus> taskReports, int failures, int maxMapTasks, int maxReduceTasks) {
        this.trackerName = trackerName;
        this.host = host;
        this.httpPort = httpPort;
        this.taskReports = new ArrayList<TaskStatus>(taskReports);
        this.failures = failures;
        this.maxMapTasks = maxMapTasks;
        this.maxReduceTasks = maxReduceTasks;
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public String getHost() {
        return this.host;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getFailures() {
        return this.failures;
    }

    public List<TaskStatus> getTaskReports() {
        return this.taskReports;
    }

    public int countMapTasks() {
        int mapCount = 0;
        for (TaskStatus ts : this.taskReports) {
            TaskStatus.State state = ts.getRunState();
            if (!ts.getIsMap() || state != TaskStatus.State.RUNNING && state != TaskStatus.State.UNASSIGNED) continue;
            ++mapCount;
        }
        return mapCount;
    }

    public int countReduceTasks() {
        int reduceCount = 0;
        for (TaskStatus ts : this.taskReports) {
            TaskStatus.State state = ts.getRunState();
            if (ts.getIsMap() || state != TaskStatus.State.RUNNING && state != TaskStatus.State.UNASSIGNED) continue;
            ++reduceCount;
        }
        return reduceCount;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public int getMaxMapTasks() {
        return this.maxMapTasks;
    }

    public int getMaxReduceTasks() {
        return this.maxReduceTasks;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.trackerName);
        UTF8.writeString(out, this.host);
        out.writeInt(this.httpPort);
        out.writeInt(this.failures);
        out.writeInt(this.maxMapTasks);
        out.writeInt(this.maxReduceTasks);
        out.writeInt(this.taskReports.size());
        for (TaskStatus taskStatus : this.taskReports) {
            TaskStatus.writeTaskStatus(out, taskStatus);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.trackerName = UTF8.readString(in);
        this.host = UTF8.readString(in);
        this.httpPort = in.readInt();
        this.failures = in.readInt();
        this.maxMapTasks = in.readInt();
        this.maxReduceTasks = in.readInt();
        this.taskReports.clear();
        int numTasks = in.readInt();
        for (int i = 0; i < numTasks; ++i) {
            this.taskReports.add(TaskStatus.readTaskStatus(in));
        }
    }

    static {
        WritableFactories.setFactory(TaskTrackerStatus.class, new WritableFactory(){

            public Writable newInstance() {
                return new TaskTrackerStatus();
            }
        });
    }
}

