/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    @Override
    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path dir = TextOutputFormat.getWorkOutputPath(job);
        FileSystem fs = dir.getFileSystem(job);
        if (!fs.exists(dir)) {
            throw new IOException("Output directory doesnt exist");
        }
        boolean isCompressed = TextOutputFormat.getCompressOutput(job);
        if (!isCompressed) {
            FSDataOutputStream fileOut = fs.create(new Path(dir, name), progress);
            return new LineRecordWriter(fileOut);
        }
        Class<CompressionCodec> codecClass = TextOutputFormat.getOutputCompressorClass(job, GzipCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, job);
        Path filename = new Path(dir, name + codec.getDefaultExtension());
        FSDataOutputStream fileOut = fs.create(filename, progress);
        return new LineRecordWriter(new DataOutputStream(codec.createOutputStream(fileOut)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LineRecordWriter<K, V>
    implements RecordWriter<K, V> {
        private static final String utf8 = "UTF-8";
        private static final byte[] tab;
        private static final byte[] newline;
        private DataOutputStream out;

        public LineRecordWriter(DataOutputStream out) {
            this.out = out;
        }

        private void writeObject(Object o) throws IOException {
            if (o instanceof Text) {
                Text to = (Text)o;
                this.out.write(to.getBytes(), 0, to.getLength());
            } else {
                this.out.write(o.toString().getBytes(utf8));
            }
        }

        @Override
        public synchronized void write(K key, V value) throws IOException {
            boolean nullValue;
            boolean nullKey = key == null || key instanceof NullWritable;
            boolean bl = nullValue = value == null || value instanceof NullWritable;
            if (nullKey && nullValue) {
                return;
            }
            if (!nullKey) {
                this.writeObject(key);
            }
            if (!nullKey && !nullValue) {
                this.out.write(tab);
            }
            if (!nullValue) {
                this.writeObject(value);
            }
            this.out.write(newline);
        }

        @Override
        public synchronized void close(Reporter reporter) throws IOException {
            this.out.close();
        }

        static {
            try {
                tab = "\t".getBytes(utf8);
                newline = "\n".getBytes(utf8);
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalArgumentException("can't find UTF-8 encoding");
            }
        }
    }
}

