/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.join.ComposableRecordReader;
import org.apache.hadoop.mapred.join.ResetableIterator;
import org.apache.hadoop.mapred.join.TupleWritable;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeRecordReader<K extends WritableComparable, V extends Writable, X extends Writable>
implements Configurable {
    private int id;
    private Configuration conf;
    private final ResetableIterator<X> EMPTY = new ResetableIterator.EMPTY<X>();
    private WritableComparator cmp;
    private Class<? extends WritableComparable> keyclass;
    private PriorityQueue<ComposableRecordReader<K, ?>> q;
    protected final JoinCollector jc;
    protected final ComposableRecordReader<K, ? extends V>[] kids;

    protected abstract boolean combine(Object[] var1, TupleWritable var2);

    public CompositeRecordReader(int id, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        assert (capacity > 0) : "Invalid capacity";
        this.id = id;
        if (null != cmpcl) {
            this.cmp = (WritableComparator)ReflectionUtils.newInstance(cmpcl, null);
            this.q = new PriorityQueue(3, new Comparator<ComposableRecordReader<K, ?>>(){

                @Override
                public int compare(ComposableRecordReader<K, ?> o1, ComposableRecordReader<K, ?> o2) {
                    return CompositeRecordReader.this.cmp.compare((WritableComparable)o1.key(), (WritableComparable)o2.key());
                }
            });
        }
        this.jc = new JoinCollector(capacity);
        this.kids = new ComposableRecordReader[capacity];
    }

    public int id() {
        return this.id;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    protected PriorityQueue<ComposableRecordReader<K, ?>> getRecordReaderQueue() {
        return this.q;
    }

    protected WritableComparator getComparator() {
        return this.cmp;
    }

    public void add(ComposableRecordReader<K, ? extends V> rr) throws IOException {
        this.kids[rr.id()] = rr;
        if (null == this.q) {
            this.cmp = WritableComparator.get(((WritableComparable)rr.createKey()).getClass());
            this.q = new PriorityQueue(3, new Comparator<ComposableRecordReader<K, ?>>(){

                @Override
                public int compare(ComposableRecordReader<K, ?> o1, ComposableRecordReader<K, ?> o2) {
                    return CompositeRecordReader.this.cmp.compare((WritableComparable)o1.key(), (WritableComparable)o2.key());
                }
            });
        }
        this.q.add(rr);
    }

    public K key() {
        if (this.jc.hasNext()) {
            return this.jc.key();
        }
        if (!this.q.isEmpty()) {
            return this.q.peek().key();
        }
        return null;
    }

    public void key(K key) throws IOException {
        WritableUtils.cloneInto(key, this.key());
    }

    public boolean hasNext() {
        return this.jc.hasNext() || !this.q.isEmpty();
    }

    public void skip(K key) throws IOException {
        ArrayList tmp = new ArrayList();
        while (!this.q.isEmpty() && this.cmp.compare((WritableComparable)this.q.peek().key(), (WritableComparable)key) <= 0) {
            tmp.add(this.q.poll());
        }
        for (ComposableRecordReader composableRecordReader : tmp) {
            composableRecordReader.skip(key);
            this.q.add(composableRecordReader);
        }
    }

    protected abstract ResetableIterator<X> getDelegate();

    public void accept(JoinCollector jc, K key) throws IOException {
        if (this.hasNext() && 0 == this.cmp.compare((WritableComparable)key, (WritableComparable)this.key())) {
            this.fillJoinCollector(this.createKey());
            jc.add(this.id, this.getDelegate());
            return;
        }
        jc.add(this.id, this.EMPTY);
    }

    protected void fillJoinCollector(K iterkey) throws IOException {
        if (!this.q.isEmpty()) {
            this.q.peek().key(iterkey);
            while (0 == this.cmp.compare((WritableComparable)this.q.peek().key(), (WritableComparable)iterkey)) {
                ComposableRecordReader<K, ?> t = this.q.poll();
                t.accept(this.jc, iterkey);
                if (t.hasNext()) {
                    this.q.add(t);
                    continue;
                }
                if (!this.q.isEmpty()) continue;
                return;
            }
        }
    }

    public int compareTo(ComposableRecordReader<K, ?> other) {
        return this.cmp.compare((WritableComparable)this.key(), (WritableComparable)other.key());
    }

    public K createKey() {
        if (null == this.keyclass) {
            Class<?> cls = ((WritableComparable)this.kids[0].createKey()).getClass();
            for (ComposableRecordReader<K, V> composableRecordReader : this.kids) {
                if (cls.equals(((WritableComparable)composableRecordReader.createKey()).getClass())) continue;
                throw new ClassCastException("Child key classes fail to agree");
            }
            this.keyclass = cls.asSubclass(WritableComparable.class);
        }
        return (K)((WritableComparable)ReflectionUtils.newInstance(this.keyclass, this.getConf()));
    }

    protected TupleWritable createInternalValue() {
        Writable[] vals = new Writable[this.kids.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = (Writable)this.kids[i].createValue();
        }
        return new TupleWritable(vals);
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        if (this.kids != null) {
            for (ComposableRecordReader<K, V> composableRecordReader : this.kids) {
                composableRecordReader.close();
            }
        }
        if (this.jc != null) {
            this.jc.close();
        }
    }

    public float getProgress() throws IOException {
        float ret = 1.0f;
        for (ComposableRecordReader<K, V> composableRecordReader : this.kids) {
            ret = Math.min(ret, composableRecordReader.getProgress());
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinCollector {
        private K key;
        private ResetableIterator<X>[] iters;
        private long partial = 0L;
        private long replaymask = 0L;
        private int start = 0;
        private int pos = -1;
        private int iterpos = -1;
        private boolean first = true;

        public JoinCollector(int card) {
            this.iters = new ResetableIterator[card];
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i] = CompositeRecordReader.this.EMPTY;
            }
        }

        public void add(int id, ResetableIterator<X> i) throws IOException {
            this.iters[id] = i;
        }

        public K key() {
            return this.key;
        }

        public void reset(K key) {
            this.key = key;
            this.start = 0;
            this.pos = 0;
            this.first = true;
            this.partial = 0L;
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i].reset();
            }
        }

        public void clear() {
            this.key = null;
            this.pos = -1;
            this.first = true;
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i].clear();
                this.iters[i] = CompositeRecordReader.this.EMPTY;
            }
            this.partial = 0L;
        }

        protected boolean hasNext() {
            return this.pos >= 0;
        }

        protected boolean next(TupleWritable val) throws IOException {
            int i;
            if (this.pos < 0) {
                this.clear();
                return false;
            }
            if (this.first) {
                for (i = this.start; i < this.iters.length && !this.iters[i].hasNext(); ++i) {
                }
                if (this.iters.length <= i) {
                    this.clear();
                    return false;
                }
                this.start = i;
                for (int j = i; j < this.iters.length; ++j) {
                    if (!this.iters[j].hasNext()) continue;
                    this.partial |= (long)(1 << j);
                }
                this.iterpos = this.pos = this.iters.length - 1;
                this.first = false;
            } else {
                while (i < this.iterpos) {
                    if ((this.partial & (long)(1 << i)) != 0L) {
                        this.iters[i].replay(val.get(i));
                        val.setWritten(i);
                    }
                    ++i;
                }
            }
            long partialwritten = val.mask();
            if (this.iters[i].next(val.get(i))) {
                val.setWritten(i);
            }
            ++i;
            while (i < this.iters.length) {
                this.iters[i].reset();
                if (this.iters[i].hasNext() && this.iters[i].next(val.get(i))) {
                    val.setWritten(i);
                }
                ++i;
            }
            this.iterpos = this.iters.length - 1;
            while (this.iterpos > this.pos && !this.iters[this.iterpos].hasNext()) {
                --this.iterpos;
            }
            if (!this.iters[this.iterpos].hasNext()) {
                while (this.pos >= 0 && !this.iters[this.pos].hasNext()) {
                    --this.pos;
                }
                this.iterpos = this.pos;
            }
            this.replaymask = val.mask();
            if ((this.replaymask ^ partialwritten) == 0L) {
                return this.next(val);
            }
            return true;
        }

        public void replay(TupleWritable val) throws IOException {
            if (this.first) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < this.iters.length; ++i) {
                if ((this.replaymask & (long)(1 << i)) == 0L) continue;
                this.iters[i].replay(val.get(i));
            }
        }

        public void close() throws IOException {
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i].close();
            }
        }

        public boolean flush(TupleWritable value) throws IOException {
            while (this.hasNext()) {
                value.clearWritten();
                if (!this.next(value) || !CompositeRecordReader.this.combine(CompositeRecordReader.this.kids, value)) continue;
                return true;
            }
            return false;
        }
    }
}

