/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.pipes.PipesPartitioner;
import org.apache.hadoop.mapred.pipes.UpwardProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutputHandler<K extends WritableComparable, V extends Writable>
implements UpwardProtocol<K, V> {
    private Reporter reporter;
    private OutputCollector<K, V> collector;
    private float progressValue = 0.0f;
    private boolean done = false;
    private Throwable exception = null;

    public OutputHandler(OutputCollector<K, V> collector, Reporter reporter) {
        this.reporter = reporter;
        this.collector = collector;
    }

    @Override
    public void output(K key, V value) throws IOException {
        this.collector.collect(key, value);
    }

    @Override
    public void partitionedOutput(int reduce, K key, V value) throws IOException {
        PipesPartitioner.setNextPartition(reduce);
        this.collector.collect(key, value);
    }

    @Override
    public void status(String msg) {
        this.reporter.setStatus(msg);
    }

    @Override
    public void progress(float progress) throws IOException {
        this.progressValue = progress;
        this.reporter.progress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() throws IOException {
        OutputHandler outputHandler = this;
        synchronized (outputHandler) {
            this.done = true;
            this.notify();
        }
    }

    public float getProgress() {
        return this.progressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable e) {
        OutputHandler outputHandler = this;
        synchronized (outputHandler) {
            this.exception = e;
            this.notify();
        }
    }

    public synchronized boolean waitForFinish() throws Throwable {
        while (!this.done && this.exception == null) {
            this.wait();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.done;
    }
}

