/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunner;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.pipes.Application;
import org.apache.hadoop.mapred.pipes.DownwardProtocol;
import org.apache.hadoop.mapred.pipes.Submitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PipesMapRunner<K1 extends WritableComparable, V1 extends Writable, K2 extends WritableComparable, V2 extends Writable>
extends MapRunner<K1, V1, K2, V2> {
    private JobConf job;

    PipesMapRunner() {
    }

    @Override
    public void configure(JobConf job) {
        this.job = job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RecordReader<K1, V1> input, OutputCollector<K2, V2> output, Reporter reporter) throws IOException {
        Application application = null;
        try {
            application = new Application(this.job, output, reporter, this.job.getMapOutputKeyClass(), this.job.getMapOutputValueClass());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("interrupted", ie);
        }
        DownwardProtocol downlink = application.getDownlink();
        boolean isJavaInput = Submitter.getIsJavaRecordReader(this.job);
        downlink.runMap(reporter.getInputSplit(), this.job.getNumReduceTasks(), isJavaInput);
        try {
            if (isJavaInput) {
                WritableComparable key = (WritableComparable)input.createKey();
                Writable value = (Writable)input.createValue();
                downlink.setInputTypes(key.getClass().getName(), value.getClass().getName());
                while (input.next(key, value)) {
                    downlink.mapItem(key, value);
                }
                downlink.endOfInput();
            }
            application.waitForFinish();
        }
        catch (Throwable t) {
            application.abort(t);
        }
        finally {
            application.cleanup();
        }
    }
}

